/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.resource;

import blade.kit.Assert;
import blade.kit.CollectionKit;
import blade.kit.exception.ClassReaderException;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import blade.kit.resource.AbstractClassReader;
import blade.kit.resource.ClassReader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarReaderImpl
extends AbstractClassReader
implements ClassReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarReaderImpl.class);

    @Override
    public Set<Class<?>> getClass(String packageName, boolean recursive) {
        return this.getClassByAnnotation(packageName, null, null, recursive);
    }

    @Override
    public Set<Class<?>> getClass(String packageName, Class<?> parent, boolean recursive) {
        return this.getClassByAnnotation(packageName, parent, null, recursive);
    }

    @Override
    public Set<Class<?>> getClassByAnnotation(String packageName, Class<? extends Annotation> annotation, boolean recursive) {
        return this.getClassByAnnotation(packageName, null, annotation, recursive);
    }

    @Override
    public Set<Class<?>> getClassByAnnotation(String packageName, Class<?> parent, Class<? extends Annotation> annotation, boolean recursive) {
        Assert.notBlank(packageName);
        HashSet<Class<?>> classes = CollectionKit.newHashSet();
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                Set<Class<?>> subClasses = this.getClasses(url, packageDirName, packageName, parent, annotation, recursive, classes);
                if (subClasses.size() <= 0) continue;
                classes.addAll(subClasses);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return classes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<Class<?>> getClasses(URL url, String packageDirName, String packageName, Class<?> parent, Class<? extends Annotation> annotation, boolean recursive, Set<Class<?>> classes) {
        try {
            if (!url.toString().startsWith("jar:file:") && !url.toString().startsWith("wsjar:file:")) return classes;
            JarFile jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> eje = jarFile.entries();
            while (eje.hasMoreElements()) {
                JarEntry entry = eje.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName)) continue;
                int idx = name.lastIndexOf(47);
                if (idx != -1) {
                    packageName = name.substring(0, idx).replace('/', '.');
                }
                if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(packageName.length() + 1, name.length() - 6);
                try {
                    Class<?> clazz = Class.forName(packageName + '.' + className);
                    if (null != parent && null != annotation) {
                        if (null == clazz.getSuperclass() || !clazz.getSuperclass().equals(parent) || null == clazz.getAnnotation(annotation)) continue;
                        classes.add(clazz);
                        continue;
                    }
                    if (null != parent) {
                        if (null == clazz.getSuperclass() || !clazz.getSuperclass().equals(parent)) continue;
                        classes.add(clazz);
                        continue;
                    }
                    if (null != annotation) {
                        if (null == clazz.getAnnotation(annotation)) continue;
                        classes.add(clazz);
                        continue;
                    }
                    classes.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Add user custom view class error Can't find such Class files.");
                    throw new ClassReaderException(e);
                    return classes;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("The scan error when the user to define the view from a jar package file.", e);
        }
        return classes;
    }
}

