/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.reflect;

import blade.kit.Emptys;
import blade.kit.ExceptionKit;
import blade.kit.StringKit;
import blade.kit.SystemKit;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class ReflectKit {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectKit.class);
    private static final Method IS_SYNTHETIC;

    public static Object newInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object obj = null;
        Class<?> clazz = Class.forName(className);
        obj = clazz.newInstance();
        LOGGER.debug("New {}", className);
        return obj;
    }

    public static Object newInstance(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    public static <T> T newBean(Class<T> clazz) {
        try {
            T object = clazz.newInstance();
            return clazz.cast(object);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setProperty(Object bean, String name, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String methodName = "set" + StringKit.firstUpperCase(name);
        ReflectKit.invokeMehodByName(bean, methodName, value);
    }

    public static Object getProperty(Object bean, String name) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String methodName = "get" + StringKit.firstUpperCase(name);
        return ReflectKit.invokeMehodByName(bean, methodName, new Object[0]);
    }

    public static <T> T cast(Object value, Class<T> type) {
        if (value != null && !type.isAssignableFrom(value.getClass())) {
            if (ReflectKit.is(type, Integer.TYPE, Integer.class)) {
                value = Integer.parseInt(String.valueOf(value));
            } else if (ReflectKit.is(type, Long.TYPE, Long.class)) {
                value = Long.parseLong(String.valueOf(value));
            } else if (ReflectKit.is(type, Float.TYPE, Float.class)) {
                value = Float.valueOf(Float.parseFloat(String.valueOf(value)));
            } else if (ReflectKit.is(type, Double.TYPE, Double.class)) {
                value = Double.parseDouble(String.valueOf(value));
            } else if (ReflectKit.is(type, Boolean.TYPE, Boolean.class)) {
                value = Boolean.parseBoolean(String.valueOf(value));
            } else if (ReflectKit.is(type, String.class)) {
                value = String.valueOf(value);
            }
        }
        return (T)value;
    }

    public static Method getMethodByName(Object classOrBean, String methodName) {
        Method ret = null;
        if (classOrBean != null) {
            Class<?> clazz = null;
            clazz = classOrBean instanceof Class ? (Class<?>)classOrBean : classOrBean.getClass();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                ret = method;
                break;
            }
        }
        return ret;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) {
        Method ret = null;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            ret = method;
            break;
        }
        return ret;
    }

    public static Object invokeMehodByName(Object bean, String methodName, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = ReflectKit.getMethodByName(bean, methodName);
        Class<?>[] types = method.getParameterTypes();
        int argCount = args == null ? 0 : args.length;
        ExceptionKit.makeRunTimeWhen(argCount != types.length, "%s in %s", methodName, bean);
        for (int i = 0; i < argCount; ++i) {
            args[i] = ReflectKit.cast(args[i], types[i]);
        }
        return method.invoke(bean, args);
    }

    public static Object invokeMehod(Object bean, Method method, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?>[] types = method.getParameterTypes();
        int argCount = args == null ? 0 : args.length;
        ExceptionKit.makeRunTimeWhen(argCount != types.length, "%s in %s", method.getName(), bean);
        for (int i = 0; i < argCount; ++i) {
            args[i] = ReflectKit.cast(args[i], types[i]);
        }
        return method.invoke(bean, args);
    }

    public static boolean is(Object obj, Object ... mybe) {
        if (obj != null && mybe != null) {
            for (Object mb : mybe) {
                if (!obj.equals(mb)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNot(Object obj, Object ... mybe) {
        return !ReflectKit.is(obj, mybe);
    }

    public static List<String> scanPackageClass(String rootPackageName) {
        ArrayList<String> classNames = new ArrayList<String>();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = loader.getResource(rootPackageName.replace('.', '/'));
            ExceptionKit.makeRunTimeWhen(url == null, "package[%s] not found!", rootPackageName);
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                File[] files;
                LOGGER.debug("Scan in file ...");
                for (File f : files = new File(url.toURI()).listFiles()) {
                    ReflectKit.scanPackageClassInFile(rootPackageName, f, classNames);
                }
            } else if ("jar".equals(protocol)) {
                LOGGER.debug("Scan in jar ...");
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                ReflectKit.scanPackageClassInJar(jar, rootPackageName, classNames);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classNames;
    }

    private static void scanPackageClassInFile(String rootPackageName, File rootFile, List<String> classNames) {
        String absFileName = rootPackageName + "." + rootFile.getName();
        if (rootFile.isFile() && absFileName.endsWith(".class")) {
            classNames.add(absFileName.substring(0, absFileName.length() - 6));
        } else if (rootFile.isDirectory()) {
            String tmPackageName = rootPackageName + "." + rootFile.getName();
            for (File f : rootFile.listFiles()) {
                ReflectKit.scanPackageClassInFile(tmPackageName, f, classNames);
            }
        }
    }

    private static void scanPackageClassInJar(JarFile jar, String packageDirName, List<String> classNames) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName().replace('/', '.');
            if (!name.startsWith(packageDirName) || !name.endsWith(".class")) continue;
            classNames.add(name.substring(0, name.length() - 6));
        }
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (method == null) {
            return null;
        }
        method.setAccessible(true);
        return method.invoke(target, args);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class<?> ... parameterTypes) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method;
        if (object == null || StringKit.isEmpty(methodName)) {
            return null;
        }
        if (parameterTypes == null) {
            parameterTypes = Emptys.EMPTY_CLASS_ARRAY;
        }
        if (args == null) {
            args = Emptys.EMPTY_OBJECT_ARRAY;
        }
        try {
            method = object.getClass().getDeclaredMethod(methodName, parameterTypes);
        }
        catch (Exception ex) {
            throw ExceptionKit.toRuntimeException(ex);
        }
        if (method == null) {
            return null;
        }
        return ReflectKit.invokeMethod(method, object, args);
    }

    public static Object invokeStaticMethod(Class<?> clazz, String methodName, Object[] args, Class<?> ... parameterTypes) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = Emptys.EMPTY_CLASS_ARRAY;
        }
        if (args == null) {
            args = Emptys.EMPTY_OBJECT_ARRAY;
        }
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (Exception ex) {
            throw ExceptionKit.toRuntimeException(ex);
        }
        if (method == null) {
            return null;
        }
        return ReflectKit.invokeMethod(method, null, args);
    }

    public static boolean isAccessible(Member m) {
        return m != null && Modifier.isPublic(m.getModifiers()) && !ReflectKit.isSynthetic(m);
    }

    static boolean isSynthetic(Member m) {
        if (IS_SYNTHETIC != null) {
            try {
                return (Boolean)IS_SYNTHETIC.invoke((Object)m, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isPublic(Member m) {
        return m != null && Modifier.isPublic(m.getModifiers());
    }

    public static void forceAccess(AccessibleObject object) {
        if (object == null || object.isAccessible()) {
            return;
        }
        try {
            object.setAccessible(true);
        }
        catch (SecurityException e) {
            throw ExceptionKit.toRuntimeException(e);
        }
    }

    public static boolean hasInterface(Class<?> type, Class<?> interfaceType) {
        Class<?>[] interfaces;
        if (null != type && null != interfaceType && null != (interfaces = type.getInterfaces()) && interfaces.length > 0) {
            for (Class<?> inte : interfaces) {
                if (inte != interfaceType) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Method isSynthetic = null;
        if (SystemKit.getJavaInfo().isJavaVersionAtLeast(1.5f)) {
            try {
                isSynthetic = Member.class.getMethod("isSynthetic", Emptys.EMPTY_CLASS_ARRAY);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        IS_SYNTHETIC = isSynthetic;
    }
}

