/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.mail;

import blade.kit.FileKit;
import blade.kit.PatternKit;
import blade.kit.StringKit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class MailTemplate {
    private String templateBody;
    private List<String> ccMails = new ArrayList<String>();
    private List<String> toMails = new ArrayList<String>();
    private List<String> fileList = new ArrayList<String>();

    public MailTemplate() {
    }

    public MailTemplate(String templetPath, String toMail, String ccMail) throws IOException {
        this.loadTemplet(templetPath);
        if (PatternKit.isEmail(toMail)) {
            this.toMails.add(toMail);
        }
        if (PatternKit.isEmail(ccMail)) {
            this.ccMails.add(ccMail);
        }
    }

    public MailTemplate addFile(String filePath) {
        if (FileKit.isFile(filePath)) {
            this.fileList.add(filePath);
        }
        return this;
    }

    public MailTemplate addFiles(List<String> files) {
        if (null != files && files.size() > 0) {
            this.fileList.addAll(files);
        }
        return this;
    }

    public MailTemplate toMail(String ... toMails) {
        if (null != toMails && toMails.length > 0) {
            for (String toMail : toMails) {
                if (!PatternKit.isEmail(toMail)) continue;
                this.toMails.add(toMail);
            }
        }
        return this;
    }

    public MailTemplate ccMail(String ... ccMails) {
        if (null != ccMails && ccMails.length > 0) {
            for (String ccMail : ccMails) {
                if (!PatternKit.isEmail(ccMail)) continue;
                this.ccMails.add(ccMail);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailTemplate loadTemplet(String templetPath) throws IOException {
        FileInputStream input = null;
        InputStreamReader read = null;
        BufferedReader reader = null;
        if (!new File(templetPath).exists()) {
            this.templateBody = "";
        }
        try {
            String line;
            input = new FileInputStream(templetPath);
            read = new InputStreamReader((InputStream)input, "UTF-8");
            reader = new BufferedReader(read);
            String result = "";
            while ((line = reader.readLine()) != null) {
                result = result + line + "\n";
            }
            this.templateBody = result.substring(result.indexOf("<html>"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.templateBody = "";
        }
        finally {
            reader.close();
            read.close();
            ((InputStream)input).close();
        }
        return this;
    }

    public String toString() {
        return this.templateBody;
    }

    public String getToMail() {
        if (null != this.toMails && this.toMails.size() > 0) {
            StringKit.join(this.toMails, ",").substring(1);
        }
        return null;
    }

    public String getCcMail() {
        if (null != this.ccMails && this.ccMails.size() > 0) {
            StringKit.join(this.ccMails, ",").substring(1);
        }
        return null;
    }

    public List<String> getFileList() {
        return this.fileList;
    }
}

