/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.logging;

public final class FeatureDetector {
    private static Boolean jodaTimeAvailable;
    private static Boolean slf4jAvailable;
    private static Boolean log4jAvailable;
    private static Boolean oracleAvailable;
    private static boolean cacheUnderscoreToCamelcaseEnabled;

    private FeatureDetector() {
    }

    public static boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isJodaTimeAvailable() {
        if (jodaTimeAvailable == null) {
            jodaTimeAvailable = FeatureDetector.isPresent("org.joda.time.DateTime");
        }
        return jodaTimeAvailable;
    }

    public static boolean isSlf4jAvailable() {
        if (slf4jAvailable == null) {
            slf4jAvailable = FeatureDetector.isPresent("org.slf4j.Logger");
        }
        return slf4jAvailable;
    }

    public static boolean isLog4jAvailable() {
        if (log4jAvailable == null) {
            log4jAvailable = FeatureDetector.isPresent("org.apache.log4j.Logger");
        }
        return log4jAvailable;
    }

    public static boolean isOracleAvailable() {
        if (oracleAvailable == null) {
            oracleAvailable = FeatureDetector.isPresent("oracle.sql.TIMESTAMP");
        }
        return oracleAvailable;
    }

    public static boolean isCacheUnderscoreToCamelcaseEnabled() {
        return cacheUnderscoreToCamelcaseEnabled;
    }

    public static void setCacheUnderscoreToCamelcaseEnabled(boolean cacheUnderscoreToCamelcaseEnabled) {
        FeatureDetector.cacheUnderscoreToCamelcaseEnabled = cacheUnderscoreToCamelcaseEnabled;
    }

    static {
        FeatureDetector.setCacheUnderscoreToCamelcaseEnabled(true);
    }
}

