/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.json;

import blade.kit.json.JSON;
import blade.kit.json.JSONArray;
import blade.kit.json.JSONObject;
import blade.kit.json.JSONValue;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSONHelper {
    public static Object jsonValueAsObject(JSONValue value) {
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isNumber()) {
            return value.asInt();
        }
        if (value.isString()) {
            return value.asString();
        }
        if (value.isArray()) {
            return JSONHelper.jsonArrayAsList(value.asArray());
        }
        if (value.isObject()) {
            return JSONHelper.parseToMap(value.asObject());
        }
        return null;
    }

    public static Set<Object> jsonArrayAsSet(JSONArray array) {
        HashSet<Object> set = new HashSet<Object>();
        for (JSONValue value : array) {
            set.add(JSONHelper.jsonValueAsObject(value));
        }
        return set;
    }

    public static List<Object> jsonArrayAsList(JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>(array.size());
        for (JSONValue element : array) {
            list.add(JSONHelper.jsonValueAsObject(element));
        }
        return list;
    }

    public static <V> Map<String, V> parseToMap(JSONObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>(object.size(), 1.0f);
        for (JSONObject.Member member : object) {
            Object v = JSONHelper.jsonValueAsObject(member.getValue());
            map.put(member.getName(), v);
        }
        return map;
    }

    public static <V> Map<String, V> parseToMap(String json) {
        try {
            JSONObject jsonObject = JSON.parse(json).asObject();
            return JSONHelper.parseToMap(jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONValue objectAsJsonValue(Object object) {
        if (object == null) {
            return JSON.NULL;
        }
        if (object instanceof Boolean) {
            return JSON.value((Boolean)object);
        }
        if (object instanceof Integer) {
            return JSON.value((Integer)object);
        }
        if (object instanceof Long) {
            return JSON.value((Long)object);
        }
        if (object instanceof Float) {
            return JSON.value(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return JSON.value((Double)object);
        }
        if (object instanceof String) {
            return JSON.value((String)object);
        }
        if (object instanceof Collection) {
            return JSONHelper.collectionAsJsonArray((Collection)object);
        }
        if (object instanceof Map) {
            return JSONHelper.mapAsJsonObject((Map)object);
        }
        return null;
    }

    public static JSONObject parseJSONObject(Object object) {
        Map<String, Object> map = JSONHelper.bean2map(object);
        if (null != map) {
            return JSONHelper.mapAsJsonObject(map);
        }
        return null;
    }

    public static JSONArray parseJSONArray(Object object) {
        JSONValue jsonValue = JSONHelper.objectAsJsonValue(object);
        if (null != jsonValue) {
            return jsonValue.asArray();
        }
        return null;
    }

    public static JSONArray collectionAsJsonArray(Collection<?> collection) {
        JSONArray array = new JSONArray();
        for (Object element : collection) {
            array.add(JSONHelper.objectAsJsonValue(element));
        }
        return array;
    }

    public static JSONObject mapAsJsonObject(Map<?, ?> map) {
        JSONObject object = new JSONObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            object.put(String.valueOf(entry.getKey()), JSONHelper.objectAsJsonValue(entry.getValue()));
        }
        return object;
    }

    private static Map<String, Object> bean2map(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value);
            }
        }
        catch (Exception e) {
            System.out.println("transBean2Map Error " + e);
        }
        return map;
    }

    private static <T> T map2bean(Map<String, Object> map, Class<T> type) {
        T obj = null;
        try {
            PropertyDescriptor[] propertyDescriptors;
            obj = type.getConstructor(new Class[0]).newInstance(new Object[0]);
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (!map.containsKey(key)) continue;
                Object value = map.get(key);
                Method setter = property.getWriteMethod();
                setter.invoke(obj, value);
            }
        }
        catch (Exception e) {
            System.out.println("transMap2Bean Error " + e);
        }
        return obj;
    }

    public static <T> T parse(JSONObject jsonObject, Class<T> type) {
        Map<String, Object> map = JSONHelper.parseToMap(jsonObject);
        return JSONHelper.map2bean(map, type);
    }

    public static JSONObject parse(Object bean) {
        JSONObject json = new JSONObject();
        Class<?> klass = bean.getClass();
        boolean includeSuperClass = klass.getClassLoader() != null;
        Method[] methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            try {
                Method method = methods[i];
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = "getClass".equals(name) || "getDeclaringClass".equals(name) ? "" : name.substring(3);
                } else if (name.startsWith("is")) {
                    key = name.substring(2);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                Object result = method.invoke(bean, (Object[])null);
                if (result == null) continue;
                json.put(name, result);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return json;
    }

    public static <K, V> JSONObject parse(Map<K, V> map) {
        if (map != null && !map.isEmpty()) {
            JSONObject jsonObject = new JSONObject();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                String key = (String)entry.getKey();
                V val = entry.getValue();
                jsonObject.put(key, val);
            }
            return jsonObject;
        }
        return null;
    }
}

