/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.json;

import blade.kit.json.JSONArray;
import blade.kit.json.JSONLiteral;
import blade.kit.json.JSONNumber;
import blade.kit.json.JSONObject;
import blade.kit.json.JSONParser;
import blade.kit.json.JSONString;
import blade.kit.json.JSONValue;
import java.io.IOException;
import java.io.Reader;

public final class JSON {
    public static final JSONValue NULL = new JSONLiteral("null");
    public static final JSONValue TRUE = new JSONLiteral("true");
    public static final JSONValue FALSE = new JSONLiteral("false");

    private JSON() {
    }

    public static JSONValue value(int value) {
        return new JSONNumber(Integer.toString(value, 10));
    }

    public static JSONValue value(long value) {
        return new JSONNumber(Long.toString(value, 10));
    }

    public static JSONValue value(float value) {
        if (Float.isInfinite(value) || Float.isNaN(value)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JSONNumber(JSON.cutOffPointZero(Float.toString(value)));
    }

    public static JSONValue value(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JSONNumber(JSON.cutOffPointZero(Double.toString(value)));
    }

    public static JSONValue value(String string) {
        return string == null ? NULL : new JSONString(string);
    }

    public static JSONValue value(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static JSONValue array() {
        return new JSONArray();
    }

    public static JSONArray array(int ... values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        JSONArray array = new JSONArray();
        for (int value : values) {
            array.add(value);
        }
        return array;
    }

    public static JSONArray array(long ... values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        JSONArray array = new JSONArray();
        for (long value : values) {
            array.add(value);
        }
        return array;
    }

    public static JSONArray array(float ... values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        JSONArray array = new JSONArray();
        for (float value : values) {
            array.add(value);
        }
        return array;
    }

    public static JSONArray array(double ... values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        JSONArray array = new JSONArray();
        for (double value : values) {
            array.add(value);
        }
        return array;
    }

    public static JSONArray array(boolean ... values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        JSONArray array = new JSONArray();
        for (boolean value : values) {
            array.add(value);
        }
        return array;
    }

    public static JSONArray array(String ... strings) {
        if (strings == null) {
            throw new NullPointerException("values is null");
        }
        JSONArray array = new JSONArray();
        for (String value : strings) {
            array.add(value);
        }
        return array;
    }

    public static JSONObject object() {
        return new JSONObject();
    }

    public static JSONValue parse(String string) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        try {
            return new JSONParser(string).parse();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static JSONValue parse(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        return new JSONParser(reader).parse();
    }

    private static String cutOffPointZero(String string) {
        if (string.endsWith(".0")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }
}

