/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.http;

import blade.kit.Assert;
import blade.kit.Base64;
import blade.kit.http.ConnectionFactory;
import blade.kit.http.HttpRequestException;
import blade.kit.http.RequestOutputStream;
import blade.kit.http.TokenQueue;
import blade.kit.http.UploadProgress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpRequest {
    private static final String BOUNDARY = "00content0boundary00";
    private static final String CONTENT_TYPE_MULTIPART = "multipart/form-data; boundary=00content0boundary00";
    private static final String CRLF = "\r\n";
    private static final String[] EMPTY_STRINGS = new String[0];
    private static SSLSocketFactory TRUSTED_FACTORY;
    private static HostnameVerifier TRUSTED_VERIFIER;
    private static ConnectionFactory CONNECTION_FACTORY;
    private HttpURLConnection connection = null;
    private final URL url;
    private final String requestMethod;
    private RequestOutputStream output;
    private boolean multipart;
    private boolean form;
    private boolean ignoreCloseExceptions = true;
    private boolean uncompress = false;
    private int bufferSize = 8192;
    private long totalSize = -1L;
    private long totalWritten = 0L;
    private String httpProxyHost;
    private int httpProxyPort;
    private UploadProgress progress = UploadProgress.DEFAULT;
    private Map<String, String> cookies;

    public static String getValidCharset(String charset) {
        if (charset != null && charset.length() > 0) {
            return charset;
        }
        return "UTF-8";
    }

    private static SSLSocketFactory getTrustedFactory() throws HttpRequestException {
        if (TRUSTED_FACTORY == null) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }
            }};
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, trustAllCerts, new SecureRandom());
                TRUSTED_FACTORY = context.getSocketFactory();
            }
            catch (GeneralSecurityException e) {
                IOException ioException = new IOException("Security exception configuring SSL context");
                ioException.initCause(e);
                throw new HttpRequestException(ioException);
            }
        }
        return TRUSTED_FACTORY;
    }

    private static HostnameVerifier getTrustedVerifier() {
        if (TRUSTED_VERIFIER == null) {
            TRUSTED_VERIFIER = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
        }
        return TRUSTED_VERIFIER;
    }

    private static StringBuilder addPathSeparator(String baseUrl, StringBuilder result) {
        if (baseUrl.indexOf(58) + 2 == baseUrl.lastIndexOf(47)) {
            result.append('/');
        }
        return result;
    }

    private static StringBuilder addParamPrefix(String baseUrl, StringBuilder result) {
        int queryStart = baseUrl.indexOf(63);
        int lastChar = result.length() - 1;
        if (queryStart == -1) {
            result.append('?');
        } else if (queryStart < lastChar && baseUrl.charAt(lastChar) != '&') {
            result.append('&');
        }
        return result;
    }

    private static StringBuilder addParam(Object key, Object value, StringBuilder result) {
        if (value != null && value.getClass().isArray()) {
            value = HttpRequest.arrayToList(value);
        }
        if (value instanceof Iterable) {
            Iterator iterator = ((Iterable)value).iterator();
            while (iterator.hasNext()) {
                result.append(key);
                result.append("[]=");
                Object element = iterator.next();
                if (element != null) {
                    result.append(element);
                }
                if (!iterator.hasNext()) continue;
                result.append("&");
            }
        } else {
            result.append(key);
            result.append("=");
            if (value != null) {
                result.append(value);
            }
        }
        return result;
    }

    public static void setConnectionFactory(ConnectionFactory connectionFactory) {
        CONNECTION_FACTORY = connectionFactory == null ? ConnectionFactory.DEFAULT : connectionFactory;
    }

    private static List<Object> arrayToList(Object array) {
        ArrayList<Object> result;
        block10: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block9: {
                                        if (array instanceof Object[]) {
                                            return Arrays.asList((Object[])array);
                                        }
                                        result = new ArrayList<Object>();
                                        if (!(array instanceof int[])) break block9;
                                        for (int value : (int[])array) {
                                            result.add(value);
                                        }
                                        break block10;
                                    }
                                    if (!(array instanceof boolean[])) break block11;
                                    for (boolean value : (boolean[])array) {
                                        result.add(value);
                                    }
                                    break block10;
                                }
                                if (!(array instanceof long[])) break block12;
                                for (long value : (long[])array) {
                                    result.add(value);
                                }
                                break block10;
                            }
                            if (!(array instanceof float[])) break block13;
                            for (float value : (float[])array) {
                                result.add(Float.valueOf(value));
                            }
                            break block10;
                        }
                        if (!(array instanceof double[])) break block14;
                        for (double value : (double[])array) {
                            result.add(value);
                        }
                        break block10;
                    }
                    if (!(array instanceof short[])) break block15;
                    for (short value : (short[])array) {
                        result.add(value);
                    }
                    break block10;
                }
                if (!(array instanceof byte[])) break block16;
                for (byte value : (byte[])array) {
                    result.add(value);
                }
                break block10;
            }
            if (!(array instanceof char[])) break block10;
            for (char value : (char[])array) {
                result.add(Character.valueOf(value));
            }
        }
        return result;
    }

    public static String encode(String url) throws HttpRequestException {
        URL parsed;
        try {
            parsed = new URL(url.toString());
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        String host = parsed.getHost();
        int port = parsed.getPort();
        if (port != -1) {
            host = host + ':' + Integer.toString(port);
        }
        try {
            String encoded = new URI(parsed.getProtocol(), host, parsed.getPath(), parsed.getQuery(), null).toASCIIString();
            int paramsStart = encoded.indexOf(63);
            if (paramsStart > 0 && paramsStart + 1 < encoded.length()) {
                encoded = encoded.substring(0, paramsStart + 1) + encoded.substring(paramsStart + 1).replace("+", "%2B");
            }
            return encoded;
        }
        catch (URISyntaxException e) {
            IOException io = new IOException("Parsing URI failed");
            io.initCause(e);
            throw new HttpRequestException(io);
        }
    }

    public static String append(String url, Map<?, ?> params) {
        String baseUrl = url.toString();
        if (params == null || params.isEmpty()) {
            return baseUrl;
        }
        StringBuilder result = new StringBuilder(baseUrl);
        HttpRequest.addPathSeparator(baseUrl, result);
        HttpRequest.addParamPrefix(baseUrl, result);
        Iterator<Map.Entry<?, ?>> iterator = params.entrySet().iterator();
        Map.Entry<?, ?> entry = iterator.next();
        HttpRequest.addParam(entry.getKey().toString(), entry.getValue(), result);
        while (iterator.hasNext()) {
            result.append('&');
            entry = iterator.next();
            HttpRequest.addParam(entry.getKey().toString(), entry.getValue(), result);
        }
        return result.toString();
    }

    public static String append(String url, Object ... params) {
        String baseUrl = url.toString();
        if (params == null || params.length == 0) {
            return baseUrl;
        }
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("Must specify an even number of parameter names/values");
        }
        StringBuilder result = new StringBuilder(baseUrl);
        HttpRequest.addPathSeparator(baseUrl, result);
        HttpRequest.addParamPrefix(baseUrl, result);
        HttpRequest.addParam(params[0], params[1], result);
        for (int i = 2; i < params.length; i += 2) {
            result.append('&');
            HttpRequest.addParam(params[i], params[i + 1], result);
        }
        return result.toString();
    }

    public static HttpRequest get(String url) throws HttpRequestException {
        return new HttpRequest(url, "GET");
    }

    public static HttpRequest get(URL url) throws HttpRequestException {
        return new HttpRequest(url, "GET");
    }

    public static HttpRequest get(String baseUrl, Map<?, ?> params, boolean encode) {
        String url = HttpRequest.append(baseUrl, params);
        return HttpRequest.get(encode ? HttpRequest.encode(url) : url);
    }

    public static HttpRequest get(String baseUrl, boolean encode, Object ... params) {
        String url = HttpRequest.append(baseUrl, params);
        return HttpRequest.get(encode ? HttpRequest.encode(url) : url);
    }

    public static HttpRequest post(String url) throws HttpRequestException {
        return new HttpRequest(url, "POST");
    }

    public static HttpRequest post(URL url) throws HttpRequestException {
        return new HttpRequest(url, "POST");
    }

    public static HttpRequest post(String baseUrl, Map<?, ?> params, boolean encode) {
        String url = HttpRequest.append(baseUrl, params);
        return HttpRequest.post(encode ? HttpRequest.encode(url) : url);
    }

    public static HttpRequest post(String baseUrl, boolean encode, Object ... params) {
        String url = HttpRequest.append(baseUrl, params);
        return HttpRequest.post(encode ? HttpRequest.encode(url) : url);
    }

    public static HttpRequest put(String url) throws HttpRequestException {
        return new HttpRequest(url, "PUT");
    }

    public static HttpRequest put(URL url) throws HttpRequestException {
        return new HttpRequest(url, "PUT");
    }

    public static HttpRequest put(String baseUrl, Map<?, ?> params, boolean encode) {
        String url = HttpRequest.append(baseUrl, params);
        return HttpRequest.put(encode ? HttpRequest.encode(url) : url);
    }

    public static HttpRequest put(String baseUrl, boolean encode, Object ... params) {
        String url = HttpRequest.append(baseUrl, params);
        return HttpRequest.put(encode ? HttpRequest.encode(url) : url);
    }

    public static HttpRequest delete(String url) throws HttpRequestException {
        return new HttpRequest(url, "DELETE");
    }

    public static HttpRequest delete(URL url) throws HttpRequestException {
        return new HttpRequest(url, "DELETE");
    }

    public static HttpRequest delete(String baseUrl, Map<?, ?> params, boolean encode) {
        String url = HttpRequest.append(baseUrl, params);
        return HttpRequest.delete(encode ? HttpRequest.encode(url) : url);
    }

    public static HttpRequest delete(String baseUrl, boolean encode, Object ... params) {
        String url = HttpRequest.append(baseUrl, params);
        return HttpRequest.delete(encode ? HttpRequest.encode(url) : url);
    }

    public static HttpRequest head(String url) throws HttpRequestException {
        return new HttpRequest(url, "HEAD");
    }

    public static HttpRequest head(URL url) throws HttpRequestException {
        return new HttpRequest(url, "HEAD");
    }

    public static HttpRequest head(String baseUrl, Map<?, ?> params, boolean encode) {
        String url = HttpRequest.append(baseUrl, params);
        return HttpRequest.head(encode ? HttpRequest.encode(url) : url);
    }

    public static HttpRequest head(String baseUrl, boolean encode, Object ... params) {
        String url = HttpRequest.append(baseUrl, params);
        return HttpRequest.head(encode ? HttpRequest.encode(url) : url);
    }

    public static HttpRequest options(String url) throws HttpRequestException {
        return new HttpRequest(url, "OPTIONS");
    }

    public static HttpRequest options(URL url) throws HttpRequestException {
        return new HttpRequest(url, "OPTIONS");
    }

    public static HttpRequest trace(String url) throws HttpRequestException {
        return new HttpRequest(url, "TRACE");
    }

    public static HttpRequest trace(URL url) throws HttpRequestException {
        return new HttpRequest(url, "TRACE");
    }

    public static void keepAlive(boolean keepAlive) {
        HttpRequest.setProperty("http.keepAlive", Boolean.toString(keepAlive));
    }

    public static void maxConnections(int maxConnections) {
        HttpRequest.setProperty("http.maxConnections", Integer.toString(maxConnections));
    }

    public static void proxyHost(String host) {
        HttpRequest.setProperty("http.proxyHost", host);
        HttpRequest.setProperty("https.proxyHost", host);
    }

    public static void proxyPort(int port) {
        String portValue = Integer.toString(port);
        HttpRequest.setProperty("http.proxyPort", portValue);
        HttpRequest.setProperty("https.proxyPort", portValue);
    }

    public static void nonProxyHosts(String ... hosts) {
        if (hosts != null && hosts.length > 0) {
            StringBuilder separated = new StringBuilder();
            int last = hosts.length - 1;
            for (int i = 0; i < last; ++i) {
                separated.append(hosts[i]).append('|');
            }
            separated.append(hosts[last]);
            HttpRequest.setProperty("http.nonProxyHosts", separated.toString());
        } else {
            HttpRequest.setProperty("http.nonProxyHosts", null);
        }
    }

    private static String setProperty(final String name, final String value) {
        PrivilegedAction<String> action = value != null ? new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(name, value);
            }
        } : new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.clearProperty(name);
            }
        };
        return AccessController.doPrivileged(action);
    }

    public HttpRequest(String url, String method) throws HttpRequestException {
        try {
            this.url = new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new HttpRequestException(e);
        }
        this.requestMethod = method;
        this.cookies = new LinkedHashMap<String, String>();
    }

    public HttpRequest(URL url, String method) throws HttpRequestException {
        this.url = url;
        this.requestMethod = method;
        this.cookies = new LinkedHashMap<String, String>();
    }

    private Proxy createProxy() {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.httpProxyHost, this.httpProxyPort));
    }

    private HttpURLConnection createConnection() {
        try {
            HttpURLConnection connection = this.httpProxyHost != null ? CONNECTION_FACTORY.create(this.url, this.createProxy()) : CONNECTION_FACTORY.create(this.url);
            connection.setRequestMethod(this.requestMethod);
            return connection;
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public String toString() {
        return this.method() + ' ' + this.url();
    }

    public HttpURLConnection getConnection() {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        return this.connection;
    }

    public HttpRequest ignoreCloseExceptions(boolean ignore) {
        this.ignoreCloseExceptions = ignore;
        return this;
    }

    public boolean ignoreCloseExceptions() {
        return this.ignoreCloseExceptions;
    }

    public int code() throws HttpRequestException {
        try {
            this.closeOutput();
            return this.getConnection().getResponseCode();
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public HttpRequest code(AtomicInteger output) throws HttpRequestException {
        output.set(this.code());
        return this;
    }

    public boolean ok() throws HttpRequestException {
        return 200 == this.code();
    }

    public boolean created() throws HttpRequestException {
        return 201 == this.code();
    }

    public boolean noContent() throws HttpRequestException {
        return 204 == this.code();
    }

    public boolean serverError() throws HttpRequestException {
        return 500 == this.code();
    }

    public boolean badRequest() throws HttpRequestException {
        return 400 == this.code();
    }

    public boolean notFound() throws HttpRequestException {
        return 404 == this.code();
    }

    public boolean notModified() throws HttpRequestException {
        return 304 == this.code();
    }

    public String message() throws HttpRequestException {
        try {
            this.closeOutput();
            return this.getConnection().getResponseMessage();
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public HttpRequest disconnect() {
        this.getConnection().disconnect();
        return this;
    }

    public HttpRequest chunk(int size) {
        this.getConnection().setChunkedStreamingMode(size);
        return this;
    }

    public HttpRequest bufferSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Size must be greater than zero");
        }
        this.bufferSize = size;
        return this;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public HttpRequest uncompress(boolean uncompress) {
        this.uncompress = uncompress;
        return this;
    }

    protected ByteArrayOutputStream byteStream() {
        int size = this.contentLength();
        if (size > 0) {
            return new ByteArrayOutputStream(size);
        }
        return new ByteArrayOutputStream();
    }

    public String body(String charset) throws HttpRequestException {
        ByteArrayOutputStream output = this.byteStream();
        try {
            this.copy(this.buffer(), output);
            return output.toString(HttpRequest.getValidCharset(charset));
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public String body() throws HttpRequestException {
        return this.body(this.charset());
    }

    public HttpRequest body(AtomicReference<String> output) throws HttpRequestException {
        output.set(this.body());
        return this;
    }

    public HttpRequest body(AtomicReference<String> output, String charset) throws HttpRequestException {
        output.set(this.body(charset));
        return this;
    }

    public boolean isBodyEmpty() throws HttpRequestException {
        return this.contentLength() == 0;
    }

    public byte[] bytes() throws HttpRequestException {
        ByteArrayOutputStream output = this.byteStream();
        try {
            this.copy(this.buffer(), output);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return output.toByteArray();
    }

    public BufferedInputStream buffer() throws HttpRequestException {
        return new BufferedInputStream(this.stream(), this.bufferSize);
    }

    public InputStream stream() throws HttpRequestException {
        InputStream stream;
        if (this.code() < 400) {
            try {
                stream = this.getConnection().getInputStream();
            }
            catch (IOException e) {
                throw new HttpRequestException(e);
            }
        }
        stream = this.getConnection().getErrorStream();
        if (stream == null) {
            try {
                stream = this.getConnection().getInputStream();
            }
            catch (IOException e) {
                if (this.contentLength() > 0) {
                    throw new HttpRequestException(e);
                }
                stream = new ByteArrayInputStream(new byte[0]);
            }
        }
        if (!this.uncompress || !"gzip".equals(this.contentEncoding())) {
            return stream;
        }
        try {
            return new GZIPInputStream(stream);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public InputStreamReader reader(String charset) throws HttpRequestException {
        try {
            return new InputStreamReader(this.stream(), HttpRequest.getValidCharset(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpRequestException(e);
        }
    }

    public InputStreamReader reader() throws HttpRequestException {
        return this.reader(this.charset());
    }

    public BufferedReader bufferedReader(String charset) throws HttpRequestException {
        return new BufferedReader(this.reader(charset), this.bufferSize);
    }

    public BufferedReader bufferedReader() throws HttpRequestException {
        return this.bufferedReader(this.charset());
    }

    public HttpRequest receive(File file) throws HttpRequestException {
        BufferedOutputStream output;
        try {
            output = new BufferedOutputStream(new FileOutputStream(file), this.bufferSize);
        }
        catch (FileNotFoundException e) {
            throw new HttpRequestException(e);
        }
        return (HttpRequest)new CloseOperation<HttpRequest>((Closeable)output, this.ignoreCloseExceptions){

            @Override
            protected HttpRequest run() throws HttpRequestException, IOException {
                return HttpRequest.this.receive(output);
            }
        }.call();
    }

    public HttpRequest receive(OutputStream output) throws HttpRequestException {
        try {
            return this.copy(this.buffer(), output);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public HttpRequest receive(PrintStream output) throws HttpRequestException {
        return this.receive((OutputStream)output);
    }

    public HttpRequest receive(final Appendable appendable) throws HttpRequestException {
        final BufferedReader reader = this.bufferedReader();
        return (HttpRequest)new CloseOperation<HttpRequest>((Closeable)reader, this.ignoreCloseExceptions){

            @Override
            public HttpRequest run() throws IOException {
                int read;
                CharBuffer buffer = CharBuffer.allocate(HttpRequest.this.bufferSize);
                while ((read = reader.read(buffer)) != -1) {
                    buffer.rewind();
                    appendable.append(buffer, 0, read);
                    buffer.rewind();
                }
                return HttpRequest.this;
            }
        }.call();
    }

    public HttpRequest receive(final Writer writer) throws HttpRequestException {
        final BufferedReader reader = this.bufferedReader();
        return (HttpRequest)new CloseOperation<HttpRequest>((Closeable)reader, this.ignoreCloseExceptions){

            @Override
            public HttpRequest run() throws IOException {
                return HttpRequest.this.copy(reader, writer);
            }
        }.call();
    }

    public HttpRequest readTimeout(int timeout) {
        this.getConnection().setReadTimeout(timeout);
        return this;
    }

    public HttpRequest connectTimeout(int timeout) {
        this.getConnection().setConnectTimeout(timeout);
        return this;
    }

    public HttpRequest header(String name, String value) {
        this.getConnection().setRequestProperty(name, value);
        return this;
    }

    public HttpRequest cookie(String name, String value) {
        Assert.notEmpty(name, "Cookie name must not be empty", new Object[0]);
        Assert.notNull(value);
        this.cookies.put(name, value);
        this.executeCookie(this.getConnection());
        return this;
    }

    public HttpRequest cookies(Map<String, String> cookies) {
        if (null != cookies) {
            this.cookies.putAll(cookies);
            this.executeCookie(this.getConnection());
        }
        return this;
    }

    private void executeCookie(HttpURLConnection connection) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> cookie : this.cookies.entrySet()) {
            if (!first) {
                sb.append("; ");
            } else {
                first = false;
            }
            sb.append(cookie.getKey()).append('=').append(cookie.getValue());
        }
        String cookies = sb.toString();
        connection.setRequestProperty("Cookie", cookies);
    }

    public HttpRequest header(String name, Number value) {
        return this.header(name, value != null ? value.toString() : null);
    }

    public HttpRequest headers(Map<String, String> headers) {
        if (!headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                this.header(header);
            }
        }
        return this;
    }

    public HttpRequest header(Map.Entry<String, String> header) {
        return this.header(header.getKey(), header.getValue());
    }

    public String header(String name) throws HttpRequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderField(name);
    }

    public Map<String, List<String>> headers() throws HttpRequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFields();
    }

    public String cookie(String name) {
        Assert.notEmpty(name, "Cookie name must not be empty", new Object[0]);
        return this.cookies().get(name);
    }

    public Map<String, String> cookies() {
        this.closeOutputQuietly();
        this.cookies.clear();
        Map<String, List<String>> resHeaders = this.getConnection().getHeaderFields();
        this.processResponseHeaders(resHeaders);
        return this.cookies;
    }

    void processResponseHeaders(Map<String, List<String>> resHeaders) {
        for (Map.Entry<String, List<String>> entry : resHeaders.entrySet()) {
            String name = entry.getKey();
            if (name == null) continue;
            List<String> values = entry.getValue();
            if (!name.equalsIgnoreCase("Set-Cookie")) continue;
            for (String value : values) {
                if (value == null) continue;
                TokenQueue cd = new TokenQueue(value);
                String cookieName = cd.chompTo("=").trim();
                String cookieVal = cd.consumeTo(";").trim();
                if (cookieName.length() <= 0) continue;
                this.cookie(cookieName, cookieVal);
            }
        }
    }

    public long dateHeader(String name) throws HttpRequestException {
        return this.dateHeader(name, -1L);
    }

    public long dateHeader(String name, long defaultValue) throws HttpRequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFieldDate(name, defaultValue);
    }

    public int intHeader(String name) throws HttpRequestException {
        return this.intHeader(name, -1);
    }

    public int intHeader(String name, int defaultValue) throws HttpRequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFieldInt(name, defaultValue);
    }

    public String[] headers(String name) {
        Map<String, List<String>> headers = this.headers();
        if (headers == null || headers.isEmpty()) {
            return EMPTY_STRINGS;
        }
        List<String> values = headers.get(name);
        if (values != null && !values.isEmpty()) {
            return values.toArray(new String[values.size()]);
        }
        return EMPTY_STRINGS;
    }

    public String parameter(String headerName, String paramName) {
        return this.getParam(this.header(headerName), paramName);
    }

    public Map<String, String> parameters(String headerName) {
        return this.getParams(this.header(headerName));
    }

    protected Map<String, String> getParams(String header) {
        if (header == null || header.length() == 0) {
            return Collections.emptyMap();
        }
        int headerLength = header.length();
        int start = header.indexOf(59) + 1;
        if (start == 0 || start == headerLength) {
            return Collections.emptyMap();
        }
        int end = header.indexOf(59, start);
        if (end == -1) {
            end = headerLength;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        while (start < end) {
            String value;
            int length;
            String name;
            int nameEnd = header.indexOf(61, start);
            if (nameEnd != -1 && nameEnd < end && (name = header.substring(start, nameEnd).trim()).length() > 0 && (length = (value = header.substring(nameEnd + 1, end).trim()).length()) != 0) {
                if (length > 2 && '\"' == value.charAt(0) && '\"' == value.charAt(length - 1)) {
                    params.put(name, value.substring(1, length - 1));
                } else {
                    params.put(name, value);
                }
            }
            if ((end = header.indexOf(59, start = end + 1)) != -1) continue;
            end = headerLength;
        }
        return params;
    }

    protected String getParam(String value, String paramName) {
        if (value == null || value.length() == 0) {
            return null;
        }
        int length = value.length();
        int start = value.indexOf(59) + 1;
        if (start == 0 || start == length) {
            return null;
        }
        int end = value.indexOf(59, start);
        if (end == -1) {
            end = length;
        }
        while (start < end) {
            String paramValue;
            int valueLength;
            int nameEnd = value.indexOf(61, start);
            if (nameEnd != -1 && nameEnd < end && paramName.equals(value.substring(start, nameEnd).trim()) && (valueLength = (paramValue = value.substring(nameEnd + 1, end).trim()).length()) != 0) {
                if (valueLength > 2 && '\"' == paramValue.charAt(0) && '\"' == paramValue.charAt(valueLength - 1)) {
                    return paramValue.substring(1, valueLength - 1);
                }
                return paramValue;
            }
            start = end + 1;
            if ((end = value.indexOf(59, start)) != -1) continue;
            end = length;
        }
        return null;
    }

    public String charset() {
        return this.parameter("Content-Type", "charset");
    }

    public HttpRequest userAgent(String userAgent) {
        return this.header("User-Agent", userAgent);
    }

    public HttpRequest referer(String referer) {
        return this.header("Referer", referer);
    }

    public HttpRequest useCaches(boolean useCaches) {
        this.getConnection().setUseCaches(useCaches);
        return this;
    }

    public HttpRequest acceptEncoding(String acceptEncoding) {
        return this.header("Accept-Encoding", acceptEncoding);
    }

    public HttpRequest acceptGzipEncoding() {
        return this.acceptEncoding("gzip");
    }

    public HttpRequest acceptCharset(String acceptCharset) {
        return this.header("Accept-Charset", acceptCharset);
    }

    public String contentEncoding() {
        return this.header("Content-Encoding");
    }

    public String server() {
        return this.header("Server");
    }

    public long date() {
        return this.dateHeader("Date");
    }

    public String cacheControl() {
        return this.header("Cache-Control");
    }

    public String eTag() {
        return this.header("ETag");
    }

    public long expires() {
        return this.dateHeader("Expires");
    }

    public long lastModified() {
        return this.dateHeader("Last-Modified");
    }

    public String location() {
        return this.header("Location");
    }

    public HttpRequest authorization(String authorization) {
        return this.header("Authorization", authorization);
    }

    public HttpRequest proxyAuthorization(String proxyAuthorization) {
        return this.header("Proxy-Authorization", proxyAuthorization);
    }

    public HttpRequest basic(String name, String password) {
        return this.authorization("Basic " + Base64.encode(name + ':' + password));
    }

    public HttpRequest proxyBasic(String name, String password) {
        return this.proxyAuthorization("Basic " + Base64.encode(name + ':' + password));
    }

    public HttpRequest ifModifiedSince(long ifModifiedSince) {
        this.getConnection().setIfModifiedSince(ifModifiedSince);
        return this;
    }

    public HttpRequest ifNoneMatch(String ifNoneMatch) {
        return this.header("If-None-Match", ifNoneMatch);
    }

    public HttpRequest contentType(String contentType) {
        return this.contentType(contentType, null);
    }

    public HttpRequest contentType(String contentType, String charset) {
        if (charset != null && charset.length() > 0) {
            String separator = "; charset=";
            return this.header("Content-Type", contentType + "; charset=" + charset);
        }
        return this.header("Content-Type", contentType);
    }

    public String contentType() {
        return this.header("Content-Type");
    }

    public int contentLength() {
        return this.intHeader("Content-Length");
    }

    public HttpRequest contentLength(String contentLength) {
        return this.contentLength(Integer.parseInt(contentLength));
    }

    public HttpRequest contentLength(int contentLength) {
        this.getConnection().setFixedLengthStreamingMode(contentLength);
        return this;
    }

    public HttpRequest accept(String accept) {
        return this.header("Accept", accept);
    }

    public HttpRequest acceptJson() {
        return this.accept("application/json");
    }

    protected HttpRequest copy(final InputStream input, final OutputStream output) throws IOException {
        return (HttpRequest)new CloseOperation<HttpRequest>((Closeable)input, this.ignoreCloseExceptions){

            @Override
            public HttpRequest run() throws IOException {
                int read;
                byte[] buffer = new byte[HttpRequest.this.bufferSize];
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                    HttpRequest.this.totalWritten = HttpRequest.this.totalWritten + (long)read;
                    HttpRequest.this.progress.onUpload(HttpRequest.this.totalWritten, HttpRequest.this.totalSize);
                }
                return HttpRequest.this;
            }
        }.call();
    }

    protected HttpRequest copy(final Reader input, final Writer output) throws IOException {
        return (HttpRequest)new CloseOperation<HttpRequest>((Closeable)input, this.ignoreCloseExceptions){

            @Override
            public HttpRequest run() throws IOException {
                int read;
                char[] buffer = new char[HttpRequest.this.bufferSize];
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                    HttpRequest.this.totalWritten = HttpRequest.this.totalWritten + (long)read;
                    HttpRequest.this.progress.onUpload(HttpRequest.this.totalWritten, -1L);
                }
                return HttpRequest.this;
            }
        }.call();
    }

    public HttpRequest progress(UploadProgress callback) {
        this.progress = callback == null ? UploadProgress.DEFAULT : callback;
        return this;
    }

    private HttpRequest incrementTotalSize(long size) {
        if (this.totalSize == -1L) {
            this.totalSize = 0L;
        }
        this.totalSize += size;
        return this;
    }

    protected HttpRequest closeOutput() throws IOException {
        this.progress(null);
        if (this.output == null) {
            return this;
        }
        if (this.multipart) {
            this.output.write("\r\n--00content0boundary00--\r\n");
        }
        if (this.ignoreCloseExceptions) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {}
        } else {
            this.output.close();
        }
        this.output = null;
        return this;
    }

    protected HttpRequest closeOutputQuietly() throws HttpRequestException {
        try {
            return this.closeOutput();
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    protected HttpRequest openOutput() throws IOException {
        if (this.output != null) {
            return this;
        }
        this.getConnection().setDoOutput(true);
        String charset = this.getParam(this.getConnection().getRequestProperty("Content-Type"), "charset");
        this.output = new RequestOutputStream(this.getConnection().getOutputStream(), charset, this.bufferSize);
        return this;
    }

    protected HttpRequest startPart() throws IOException {
        if (!this.multipart) {
            this.multipart = true;
            this.contentType(CONTENT_TYPE_MULTIPART).openOutput();
            this.output.write("--00content0boundary00\r\n");
        } else {
            this.output.write("\r\n--00content0boundary00\r\n");
        }
        return this;
    }

    protected HttpRequest writePartHeader(String name, String filename) throws IOException {
        return this.writePartHeader(name, filename, null);
    }

    protected HttpRequest writePartHeader(String name, String filename, String contentType) throws IOException {
        StringBuilder partBuffer = new StringBuilder();
        partBuffer.append("form-data; name=\"").append(name);
        if (filename != null) {
            partBuffer.append("\"; filename=\"").append(filename);
        }
        partBuffer.append('\"');
        this.partHeader("Content-Disposition", partBuffer.toString());
        if (contentType != null) {
            this.partHeader("Content-Type", contentType);
        }
        return this.send(CRLF);
    }

    public HttpRequest part(String name, String part) {
        return this.part(name, null, part);
    }

    public HttpRequest part(String name, String filename, String part) throws HttpRequestException {
        return this.part(name, filename, null, part);
    }

    public HttpRequest part(String name, String filename, String contentType, String part) throws HttpRequestException {
        try {
            this.startPart();
            this.writePartHeader(name, filename, contentType);
            this.output.write(part);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this;
    }

    public HttpRequest part(String name, Number part) throws HttpRequestException {
        return this.part(name, null, part);
    }

    public HttpRequest part(String name, String filename, Number part) throws HttpRequestException {
        return this.part(name, filename, part != null ? part.toString() : null);
    }

    public HttpRequest part(String name, File part) throws HttpRequestException {
        return this.part(name, null, part);
    }

    public HttpRequest part(String name, String filename, File part) throws HttpRequestException {
        return this.part(name, filename, null, part);
    }

    public HttpRequest part(String name, String filename, String contentType, File part) throws HttpRequestException {
        BufferedInputStream stream;
        try {
            stream = new BufferedInputStream(new FileInputStream(part));
            this.incrementTotalSize(part.length());
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this.part(name, filename, contentType, stream);
    }

    public HttpRequest part(String name, InputStream part) throws HttpRequestException {
        return this.part(name, null, null, part);
    }

    public HttpRequest part(String name, String filename, String contentType, InputStream part) throws HttpRequestException {
        try {
            this.startPart();
            this.writePartHeader(name, filename, contentType);
            this.copy(part, this.output);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this;
    }

    public HttpRequest partHeader(String name, String value) throws HttpRequestException {
        return this.send(name).send(": ").send(value).send(CRLF);
    }

    public HttpRequest send(File input) throws HttpRequestException {
        BufferedInputStream stream;
        try {
            stream = new BufferedInputStream(new FileInputStream(input));
            this.incrementTotalSize(input.length());
        }
        catch (FileNotFoundException e) {
            throw new HttpRequestException(e);
        }
        return this.send(stream);
    }

    public HttpRequest send(byte[] input) throws HttpRequestException {
        if (input != null) {
            this.incrementTotalSize(input.length);
        }
        return this.send(new ByteArrayInputStream(input));
    }

    public HttpRequest send(InputStream input) throws HttpRequestException {
        try {
            this.openOutput();
            this.copy(input, this.output);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this;
    }

    public HttpRequest send(final Reader input) throws HttpRequestException {
        try {
            this.openOutput();
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        final OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.output, this.output.encoder.charset());
        return (HttpRequest)new FlushOperation<HttpRequest>((Flushable)writer){

            @Override
            protected HttpRequest run() throws IOException {
                return HttpRequest.this.copy(input, writer);
            }
        }.call();
    }

    public HttpRequest send(String value) throws HttpRequestException {
        try {
            this.openOutput();
            this.output.write(value.toString());
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this;
    }

    public OutputStreamWriter writer() throws HttpRequestException {
        try {
            this.openOutput();
            return new OutputStreamWriter((OutputStream)this.output, this.output.encoder.charset());
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public HttpRequest form(Map<?, ?> values) throws HttpRequestException {
        return this.form(values, "UTF-8");
    }

    public HttpRequest form(Map.Entry<?, ?> entry) throws HttpRequestException {
        return this.form(entry, "UTF-8");
    }

    public HttpRequest form(Map.Entry<?, ?> entry, String charset) throws HttpRequestException {
        return this.form(entry.getKey(), entry.getValue(), charset);
    }

    public HttpRequest form(Object name, Object value) throws HttpRequestException {
        return this.form(name, value, "UTF-8");
    }

    public HttpRequest form(Object name, Object value, String charset) throws HttpRequestException {
        boolean first;
        boolean bl = first = !this.form;
        if (first) {
            this.contentType("application/x-www-form-urlencoded", charset);
            this.form = true;
        }
        charset = HttpRequest.getValidCharset(charset);
        try {
            this.openOutput();
            if (!first) {
                this.output.write(38);
            }
            this.output.write(URLEncoder.encode(name.toString(), charset));
            this.output.write(61);
            if (value != null) {
                this.output.write(URLEncoder.encode(value.toString(), charset));
            }
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this;
    }

    public HttpRequest form(Map<?, ?> values, String charset) throws HttpRequestException {
        if (!values.isEmpty()) {
            for (Map.Entry<?, ?> entry : values.entrySet()) {
                this.form(entry, charset);
            }
        }
        return this;
    }

    public HttpRequest trustAllCerts() throws HttpRequestException {
        HttpURLConnection connection = this.getConnection();
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(HttpRequest.getTrustedFactory());
        }
        return this;
    }

    public HttpRequest trustAllHosts() {
        HttpURLConnection connection = this.getConnection();
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setHostnameVerifier(HttpRequest.getTrustedVerifier());
        }
        return this;
    }

    public URL url() {
        return this.getConnection().getURL();
    }

    public String method() {
        return this.getConnection().getRequestMethod();
    }

    public HttpRequest useProxy(String proxyHost, int proxyPort) {
        if (this.connection != null) {
            throw new IllegalStateException("The connection has already been created. This method must be called before reading or writing to the request.");
        }
        this.httpProxyHost = proxyHost;
        this.httpProxyPort = proxyPort;
        return this;
    }

    public HttpRequest followRedirects(boolean followRedirects) {
        this.getConnection().setInstanceFollowRedirects(followRedirects);
        return this;
    }

    static {
        CONNECTION_FACTORY = ConnectionFactory.DEFAULT;
    }

    protected static abstract class FlushOperation<V>
    extends Operation<V> {
        private final Flushable flushable;

        protected FlushOperation(Flushable flushable) {
            this.flushable = flushable;
        }

        @Override
        protected void done() throws IOException {
            this.flushable.flush();
        }
    }

    protected static abstract class CloseOperation<V>
    extends Operation<V> {
        private final Closeable closeable;
        private final boolean ignoreCloseExceptions;

        protected CloseOperation(Closeable closeable, boolean ignoreCloseExceptions) {
            this.closeable = closeable;
            this.ignoreCloseExceptions = ignoreCloseExceptions;
        }

        @Override
        protected void done() throws IOException {
            if (this.closeable instanceof Flushable) {
                ((Flushable)((Object)this.closeable)).flush();
            }
            if (this.ignoreCloseExceptions) {
                try {
                    this.closeable.close();
                }
                catch (IOException iOException) {}
            } else {
                this.closeable.close();
            }
        }
    }

    protected static abstract class Operation<V>
    implements Callable<V> {
        protected Operation() {
        }

        protected abstract V run() throws HttpRequestException, IOException;

        protected abstract void done() throws IOException;

        @Override
        public V call() throws HttpRequestException {
            boolean thrown = false;
            try {
                V v = this.run();
                return v;
            }
            catch (HttpRequestException e) {
                thrown = true;
                throw e;
            }
            catch (IOException e) {
                thrown = true;
                throw new HttpRequestException(e);
            }
            finally {
                block10: {
                    try {
                        this.done();
                    }
                    catch (IOException e) {
                        if (thrown) break block10;
                        throw new HttpRequestException(e);
                    }
                }
            }
        }
    }
}

