/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.config.adapter;

import blade.kit.config.Config;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public abstract class ConfigAdapter
implements Config {
    protected Map<String, String> configMap = new HashMap<String, String>();

    @Override
    public String getString(String key) {
        String object = this.configMap.get(key);
        if (null != object) {
            return object.toString();
        }
        return null;
    }

    @Override
    public Integer getInt(String key) {
        String value = this.getString(key);
        if (null != value) {
            return Integer.parseInt(value);
        }
        return null;
    }

    @Override
    public Long getLong(String key) {
        String value = this.getString(key);
        if (null != value) {
            return Long.parseLong(value);
        }
        return null;
    }

    @Override
    public Boolean getBoolean(String key) {
        String value = this.getString(key);
        if (null != value) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    @Override
    public Double getDouble(String key) {
        String value = this.getString(key);
        if (null != value) {
            return Double.parseDouble(value);
        }
        return null;
    }

    @Override
    public <T> T get(Class<T> t) {
        try {
            Object tobj = Proxy.newProxyInstance(t.getClassLoader(), new Class[]{t}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    String method_name = method.getName();
                    Class<?> returnClazz = method.getReturnType();
                    if (returnClazz == String.class) {
                        return ConfigAdapter.this.getString(method_name);
                    }
                    if (returnClazz == Integer.class || returnClazz == Integer.TYPE) {
                        return ConfigAdapter.this.getInt(method_name);
                    }
                    if (returnClazz == Long.class || returnClazz == Long.TYPE) {
                        return ConfigAdapter.this.getLong(method_name);
                    }
                    if (returnClazz == Double.class || returnClazz == Double.TYPE) {
                        return ConfigAdapter.this.getDouble(method_name);
                    }
                    if (returnClazz == Boolean.class || returnClazz == Boolean.TYPE) {
                        return ConfigAdapter.this.getBoolean(method_name);
                    }
                    return null;
                }
            });
            return (T)tobj;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract Config read(String var1);
}

