/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class TimwKit {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimwKit.class);
    private ArrayList<Number> numList = new ArrayList();

    public synchronized void add(Number num) {
        this.numList.add(num);
    }

    public void clear() {
        this.numList.clear();
    }

    public int size() {
        return this.numList.size();
    }

    public List<Number> numbers() {
        return this.numList;
    }

    public Number current() {
        return this.numList.get(this.numList.size() - 1);
    }

    public Number avg() {
        if (this.numList.size() == 0) {
            return 0;
        }
        Float sum = Float.valueOf(0.0f);
        int size = this.numList.size();
        for (int i = 0; i < size; ++i) {
            sum = Float.valueOf(sum.floatValue() + this.numList.get(i).floatValue());
        }
        return Float.valueOf(sum.floatValue() / (float)this.numList.size());
    }

    public String print() {
        String str = "Execute count = " + this.size() + ", elapsed time: " + this.numList + " ms.";
        LOGGER.debug(str);
        return str;
    }

    public String printAvg() {
        Number number = this.avg();
        BigDecimal b = new BigDecimal(number.doubleValue());
        double avg = b.setScale(3, 4).doubleValue();
        String str = "average time cost: " + avg + " ms";
        LOGGER.debug(str);
        return str;
    }
}

