/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import blade.kit.StringKit;
import blade.kit.mail.EmailHandle;
import blade.kit.mail.MailTemplate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MailKit {
    public static final String SMTP_QQ = "smtp.qq.com";
    public static final String SMTP_163 = "smtp.163.com";
    public static final String SMTP_126 = "smtp.126.com";
    public static final String SMTP_SINA = "smtp.sina.com";
    public static final String SMTP_GMAIL = "smtp.gmail.com";
    private static String CFG_SMTP = "smtp.qq.com";
    private static String SEND_USER = "";
    private static String SEND_PASSWORD = "";

    public static void config(String smtp, String user, String password) {
        if (StringKit.isNotBlank(smtp)) {
            CFG_SMTP = smtp;
        }
        if (StringKit.isNotBlank(user)) {
            SEND_USER = user;
        }
        if (StringKit.isNotBlank(password)) {
            SEND_PASSWORD = password;
        }
    }

    public static boolean send(MailTemplate mailTemplate, String subject) {
        if (null != mailTemplate && StringKit.isNotBlank(subject)) {
            return MailKit.sendProcess(CFG_SMTP, SEND_USER, SEND_PASSWORD, mailTemplate.getToMail(), mailTemplate.getCcMail(), subject, mailTemplate.toString(), mailTemplate.getFileList());
        }
        return false;
    }

    public static boolean send(String toMail, String subject, String content) {
        return MailKit.sendProcess(CFG_SMTP, SEND_USER, SEND_PASSWORD, toMail, null, subject, content, null);
    }

    public static boolean send(String toMail, String subject, String content, String ... files) {
        return MailKit.sendProcess(CFG_SMTP, SEND_USER, SEND_PASSWORD, toMail, null, subject, content, Arrays.asList(files));
    }

    public static boolean send(String toMail, String subject, String content, List<String> files) {
        return MailKit.sendProcess(CFG_SMTP, SEND_USER, SEND_PASSWORD, toMail, null, subject, content, files);
    }

    public static boolean sendAndCc(String toMail, String ccMail, String subject, String content) {
        return MailKit.sendProcess(CFG_SMTP, SEND_USER, SEND_PASSWORD, toMail, ccMail, subject, content, null);
    }

    public static boolean sendAndCc(String toMail, String ccMail, String subject, String content, String ... files) {
        return MailKit.sendProcess(CFG_SMTP, SEND_USER, SEND_PASSWORD, toMail, ccMail, subject, content, Arrays.asList(files));
    }

    public static boolean sendAndCc(String toMail, String ccMail, String subject, String content, List<String> files) {
        return MailKit.sendProcess(CFG_SMTP, SEND_USER, SEND_PASSWORD, toMail, ccMail, subject, content, files);
    }

    public static boolean sendProcess(String smtp, String fromAddress, String fromPass, String toMailList, String ccAdress, String subject, String content, List<String> fileList) {
        try {
            EmailHandle emailHandle = new EmailHandle(smtp);
            emailHandle.setFrom(fromAddress);
            emailHandle.setNeedAuth(true);
            emailHandle.setSubject(subject);
            emailHandle.setBody(content);
            emailHandle.setToList(toMailList);
            if (StringKit.isNotEmpty(ccAdress)) {
                emailHandle.setCopyToList(ccAdress);
            }
            emailHandle.setFrom(fromAddress);
            emailHandle.setNamePass(fromAddress, fromPass);
            if (null != fileList && fileList.size() > 0) {
                for (String file : fileList) {
                    emailHandle.addFileAffix(file);
                }
            }
            return emailHandle.sendEmail();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void asynSend(MailTemplate mailTemplate, String subject) {
        if (null != mailTemplate && StringKit.isNotBlank(subject)) {
            MailKit.asynSend(CFG_SMTP, SEND_USER, SEND_PASSWORD, mailTemplate.getToMail(), mailTemplate.getCcMail(), subject, mailTemplate.toString(), mailTemplate.getFileList());
        }
    }

    public static void asynSend(String toMail, String subject, String content) {
        MailKit.asynSend(CFG_SMTP, SEND_USER, SEND_PASSWORD, toMail, null, subject, content, null);
    }

    public static void asynSendAndCc(String toMail, String ccMail, String subject, String content) {
        MailKit.asynSend(CFG_SMTP, SEND_USER, SEND_PASSWORD, toMail, ccMail, subject, content, null);
    }

    public static void asynSend(String toMail, String subject, String content, String ... files) {
        MailKit.asynSend(CFG_SMTP, SEND_USER, SEND_PASSWORD, toMail, null, subject, content, Arrays.asList(files));
    }

    public static void asynSend(String toMail, String subject, String content, List<String> files) {
        MailKit.asynSend(CFG_SMTP, SEND_USER, SEND_PASSWORD, toMail, null, subject, content, files);
    }

    public static void asynSendAndCc(String toMail, String ccMail, String subject, String content, String ... files) {
        MailKit.asynSend(CFG_SMTP, SEND_USER, SEND_PASSWORD, toMail, ccMail, subject, content, Arrays.asList(files));
    }

    public static void asynSendAndCc(String toMail, String ccMail, String subject, String content, List<String> files) {
        MailKit.asynSend(CFG_SMTP, SEND_USER, SEND_PASSWORD, toMail, ccMail, subject, content, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean asynSend(final String smtp, final String fromAddress, final String fromPass, final String toAddress, final String ccAdress, final String subject, final String content, final List<String> fileList) {
        Boolean flag = Boolean.FALSE;
        FutureTask<Boolean> futureTask = null;
        ExecutorService excutorService = Executors.newCachedThreadPool();
        futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                EmailHandle emailHandle = new EmailHandle(smtp);
                emailHandle.setFrom(fromAddress);
                emailHandle.setNeedAuth(true);
                emailHandle.setSubject(subject);
                emailHandle.setBody(content);
                emailHandle.setToList(toAddress);
                if (StringKit.isNotEmpty(ccAdress)) {
                    emailHandle.setCopyToList(ccAdress);
                }
                emailHandle.setFrom(fromAddress);
                emailHandle.setNamePass(fromAddress, fromPass);
                if (null != fileList && fileList.size() > 0) {
                    for (String file : fileList) {
                        emailHandle.addFileAffix(file);
                    }
                }
                return emailHandle.sendEmail();
            }
        });
        excutorService.submit(futureTask);
        try {
            flag = futureTask.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            futureTask.cancel(true);
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            futureTask.cancel(true);
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            futureTask.cancel(true);
            e.printStackTrace();
        }
        finally {
            excutorService.shutdown();
        }
        return flag;
    }
}

