package blade.kit.http;

/**
 * 头信息常量
 *
 * @author	<a href="mailto:biezhi.me@gmail.com" target="_blank">biezhi</a>
 * @since	1.0
 */
public class Header {

	public static final String CHARSET_UTF8 = "UTF-8";
	
	/**
	 * 表单类型头信息
	 */
	public static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";

	/**
	 * json类型头信息
	 */
	public static final String CONTENT_TYPE_JSON = "application/json";

	/**
	 * gzip压缩
	 */
	public static final String ENCODING_GZIP = "gzip";

	/**
	 * Accept
	 */
	public static final String HEADER_ACCEPT = "Accept";

	/**
	 * Accept-Charset
	 */
	public static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";

	/**
	 * Accept-Encoding
	 */
	public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";

	/**
	 * Authorization
	 */
	public static final String HEADER_AUTHORIZATION = "Authorization";

	/**
	 * 'Cache-Control' header name
	 */
	public static final String HEADER_CACHE_CONTROL = "Cache-Control";

	/**
	 * 'Content-Encoding' header name
	 */
	public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";

	/**
	 * 'Content-Length' header name
	 */
	public static final String HEADER_CONTENT_LENGTH = "Content-Length";

	/**
	 * 'Content-Type' header name
	 */
	public static final String HEADER_CONTENT_TYPE = "Content-Type";
	
	/**
	 * 'Cookie' header name
	 */
	public static final String HEADER_COOKIE = "Cookie";
	
	/**
	 * 'Set-Cookie' header name
	 */
	public static final String HEADER_SET_COOKIE = "Set-Cookie";

	/**
	 * 'Date' header name
	 */
	public static final String HEADER_DATE = "Date";

	/**
	 * 'ETag' header name
	 */
	public static final String HEADER_ETAG = "ETag";

	/**
	 * 'Expires' header name
	 */
	public static final String HEADER_EXPIRES = "Expires";

	/**
	 * 'If-None-Match' header name
	 */
	public static final String HEADER_IF_NONE_MATCH = "If-None-Match";

	/**
	 * 'Last-Modified' header name
	 */
	public static final String HEADER_LAST_MODIFIED = "Last-Modified";

	/**
	 * 'Location' header name
	 */
	public static final String HEADER_LOCATION = "Location";

	/**
	 * 'Proxy-Authorization' header name
	 */
	public static final String HEADER_PROXY_AUTHORIZATION = "Proxy-Authorization";

	/**
	 * 'Referer' header name
	 */
	public static final String HEADER_REFERER = "Referer";

	/**
	 * 'Server' header name
	 */
	public static final String HEADER_SERVER = "Server";

	/**
	 * 'User-Agent' header name
	 */
	public static final String HEADER_USER_AGENT = "User-Agent";

	/**
	 * 'charset' header value parameter
	 */
	public static final String PARAM_CHARSET = "charset";

}
