/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc.ds;

import com.blade.jdbc.ds.ConnectionWrapper;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class ConnectionXAResource
implements XAResource {
    private final ConnectionWrapper connection;
    private Xid xid;

    ConnectionXAResource(ConnectionWrapper connection) {
        this.connection = connection;
    }

    public String toString() {
        return "ConnectionXAResource{" + this.connection.dataSource.getName() + ':' + this.xid + '}';
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.xid != null) {
            throw new XAException(-8);
        }
        this.xid = xid;
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (this.xid != xid) {
            throw new XAException(-5);
        }
        this.xid = null;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (this.xid != xid) {
            throw new XAException(-5);
        }
        this.xid = null;
    }

    @Override
    public int prepare(Xid xid) {
        return 0;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.xid != xid) {
            throw new XAException(-5);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw ConnectionXAResource.XAException(e);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (this.xid != xid) {
            throw new XAException(-5);
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw ConnectionXAResource.XAException(e);
        }
    }

    @Override
    public boolean isSameRM(XAResource xaResource) {
        return xaResource == this;
    }

    @Override
    public Xid[] recover(int flag) {
        Xid[] xidArray;
        if (this.xid == null) {
            xidArray = new Xid[]{};
        } else {
            Xid[] xidArray2 = new Xid[1];
            xidArray = xidArray2;
            xidArray2[0] = this.xid;
        }
        return xidArray;
    }

    @Override
    public int getTransactionTimeout() {
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) {
        return false;
    }

    private static XAException XAException(SQLException e) {
        XAException wrapper = new XAException(101);
        wrapper.initCause(e);
        return wrapper;
    }
}

