/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc.ds;

import com.blade.jdbc.ds.BasicDataSourceImpl;
import com.blade.jdbc.ds.StatementWrapper;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

class ConnectionWrapper
implements Connection {
    final Connection delegate;
    final BasicDataSourceImpl dataSource;
    long lastAccessTime;
    boolean invalidate;

    ConnectionWrapper(Connection delegate, BasicDataSourceImpl dataSource, long accessTime) {
        this.delegate = delegate;
        this.dataSource = dataSource;
        this.lastAccessTime = accessTime;
    }

    void closeUnderlyingConnection() {
        try {
            this.delegate.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkValid();
        try {
            return this.delegate.nativeSQL(sql);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkValid();
        try {
            this.delegate.setAutoCommit(autoCommit);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.getAutoCommit();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkValid();
        try {
            this.delegate.commit();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkValid();
        try {
            this.delegate.rollback();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void close() throws SQLException {
        this.dataSource.releaseConnection(this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.isClosed();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.getMetaData();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkValid();
        try {
            this.delegate.setReadOnly(readOnly);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.isReadOnly();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkValid();
        try {
            this.delegate.setCatalog(catalog);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.getCatalog();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkValid();
        try {
            this.delegate.setTransactionIsolation(level);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.getTransactionIsolation();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.getWarnings();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkValid();
        try {
            this.delegate.clearWarnings();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.getTypeMap();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkValid();
        try {
            this.delegate.setTypeMap(map);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkValid();
        try {
            this.delegate.setHoldability(holdability);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.getHoldability();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.setSavepoint();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkValid();
        try {
            return this.delegate.setSavepoint(name);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkValid();
        try {
            this.delegate.rollback(savepoint);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkValid();
        try {
            this.delegate.releaseSavepoint(savepoint);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.createClob();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.createBlob();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.createNClob();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.createSQLXML();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkValid();
        try {
            return this.delegate.isValid(timeout);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.delegate.setClientInfo(name, value);
        }
        catch (Throwable e) {
            throw this.handleClientInfoException(e);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.delegate.setClientInfo(properties);
        }
        catch (Throwable e) {
            throw this.handleClientInfoException(e);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkValid();
        try {
            return this.delegate.getClientInfo(name);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkValid();
        try {
            return this.delegate.getClientInfo();
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkValid();
        try {
            return this.delegate.createArrayOf(typeName, elements);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkValid();
        try {
            return this.delegate.createStruct(typeName, attributes);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLException("JDK 7 feature unavailable");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException("JDK 7 feature unavailable");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException("JDK 7 feature unavailable");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLException("JDK 7 feature unavailable");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLException("JDK 7 feature unavailable");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this.delegate.unwrap(iface);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this.delegate.isWrapperFor(iface);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    SQLException handleException(Throwable e) {
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            this.invalidate |= ConnectionWrapper.isFatalException(se);
            return se;
        }
        this.invalidate = true;
        return new SQLException(e);
    }

    private SQLClientInfoException handleClientInfoException(Throwable e) {
        this.invalidate = true;
        if (e instanceof SQLClientInfoException) {
            return (SQLClientInfoException)e;
        }
        throw new IllegalStateException(e);
    }

    private void checkValid() throws SQLException {
        if (this.invalidate) {
            throw new SQLException("Connection to " + this.dataSource + " has been invalidated");
        }
    }

    private static boolean isFatalException(SQLException e) {
        if (e.getErrorCode() == 2627 || e.getErrorCode() == 2601) {
            return false;
        }
        return e.getMessage() == null || !e.getMessage().contains("Violation of PRIMARY KEY constraint");
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkValid();
        try {
            return new StatementWrapper(this.delegate.createStatement(), this);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkValid();
        try {
            return new StatementWrapper(this.delegate.prepareStatement(sql), this);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkValid();
        try {
            return new StatementWrapper(this.delegate.prepareCall(sql), this);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValid();
        try {
            return new StatementWrapper(this.delegate.createStatement(resultSetType, resultSetConcurrency), this);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValid();
        try {
            return new StatementWrapper(this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency), this);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValid();
        try {
            return new StatementWrapper(this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency), this);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkValid();
        try {
            return new StatementWrapper(this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkValid();
        try {
            return new StatementWrapper(this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkValid();
        try {
            return new StatementWrapper(this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkValid();
        try {
            return new StatementWrapper(this.delegate.prepareStatement(sql, autoGeneratedKeys), this);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkValid();
        try {
            return new StatementWrapper(this.delegate.prepareStatement(sql, columnIndexes), this);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkValid();
        try {
            return new StatementWrapper(this.delegate.prepareStatement(sql, columnNames), this);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }
}

