/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc.ds;

import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import com.blade.jdbc.ds.BasicDataSource;
import com.blade.jdbc.ds.ConnectionWrapper;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import javax.sql.DataSource;

public class BasicDataSourceImpl
implements DataSource,
BasicDataSource {
    private static final Logger log = LoggerFactory.getLogger(BasicDataSourceImpl.class);
    private final LinkedList<ConnectionWrapper> pool = new LinkedList();
    private int loginTimeout = 10;
    private PrintWriter logWriter;
    private final String name;
    private final Driver driver;
    private final String url;
    private final String user;
    private final String password;
    private final long keepAlive;
    private final long borrowTimeout;
    private final int lockTimeout;
    private final int poolSize;
    private long checkIdleConnectionsTime;
    private int activeCount;
    private int waitingThreads;
    private boolean closed;

    public BasicDataSourceImpl(String name, String driver, String url, String user, String pass) {
        try {
            this.name = name;
            this.driver = (Driver)Class.forName(driver).newInstance();
            this.url = url;
            this.user = user;
            this.password = pass;
            this.keepAlive = 1800000L;
            this.borrowTimeout = 3000L;
            this.lockTimeout = -1;
            this.poolSize = 10;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid DataSource descriptor for " + name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LinkedList<ConnectionWrapper> linkedList = this.pool;
        synchronized (linkedList) {
            for (ConnectionWrapper connection : this.pool) {
                connection.closeUnderlyingConnection();
            }
            this.activeCount = 0;
            this.closed = true;
            this.pool.clear();
            this.pool.notifyAll();
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "DataSourceImpl{" + this.name + '}';
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.borrowConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Impossible to unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionWrapper borrowConnection() throws SQLException {
        long accessTime;
        block11: {
            accessTime = System.currentTimeMillis();
            long waited = 0L;
            if (accessTime > this.checkIdleConnectionsTime) {
                this.checkIdleConnectionsTime = accessTime + this.keepAlive / 10L;
                this.closeIdleConnections(accessTime - this.keepAlive);
            }
            LinkedList<ConnectionWrapper> linkedList = this.pool;
            synchronized (linkedList) {
                while (!this.closed) {
                    ConnectionWrapper connection = this.pool.pollFirst();
                    if (connection != null) {
                        connection.lastAccessTime = accessTime;
                        return connection;
                    }
                    if (this.activeCount < this.poolSize) {
                        ++this.activeCount;
                        break block11;
                    }
                    this.waitForFreeConnection(this.borrowTimeout - waited);
                    waited = System.currentTimeMillis() - accessTime;
                }
                throw new SQLException("DataSource is closed");
            }
        }
        ConnectionWrapper connection = null;
        try {
            ConnectionWrapper connectionWrapper = connection = new ConnectionWrapper(this.getRawConnection(), this, accessTime);
            return connectionWrapper;
        }
        finally {
            if (connection == null) {
                this.decreaseCount();
            }
        }
    }

    private Connection getRawConnection() throws SQLException {
        Connection connection;
        Properties props = new Properties();
        if (this.user != null) {
            props.put("user", this.user);
        }
        if (this.password != null) {
            props.put("password", this.password);
        }
        if ((connection = this.driver.connect(this.url, props)) == null) {
            throw new SQLException("Unsupported connection string: " + this.url);
        }
        if (this.lockTimeout >= 0) {
            this.executeRawSQL(connection, "SET LOCK_TIMEOUT " + this.lockTimeout);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRawSQL(Connection connection, String sql) {
        try {
            Statement stmt = connection.createStatement();
            try {
                stmt.executeUpdate(sql);
            }
            finally {
                stmt.close();
            }
        }
        catch (Throwable e) {
            log.error("Cannot execute " + sql + " on " + this.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIdleConnections(long closeTime) {
        ArrayList<ConnectionWrapper> idleConnections = new ArrayList<ConnectionWrapper>();
        LinkedList<ConnectionWrapper> linkedList = this.pool;
        synchronized (linkedList) {
            Iterator iterator = this.pool.iterator();
            while (iterator.hasNext()) {
                ConnectionWrapper connection = (ConnectionWrapper)iterator.next();
                if (connection.lastAccessTime >= closeTime) continue;
                idleConnections.add(connection);
                iterator.remove();
                this.decreaseCount();
            }
        }
        if (!idleConnections.isEmpty()) {
            log.debug("Closing " + idleConnections.size() + " idle connections on " + this.toString());
            for (ConnectionWrapper connection : idleConnections) {
                connection.closeUnderlyingConnection();
            }
        }
    }

    private void waitForFreeConnection(long waitTime) throws SQLException {
        if (waitTime <= 0L) {
            throw new SQLException("DataSource timed out waiting for a free connection");
        }
        ++this.waitingThreads;
        try {
            this.pool.wait(waitTime);
        }
        catch (InterruptedException e) {
            throw new SQLException("Interrupted while waiting for a free connection");
        }
        --this.waitingThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseCount() {
        LinkedList<ConnectionWrapper> linkedList = this.pool;
        synchronized (linkedList) {
            if (!this.closed) {
                --this.activeCount;
                if (this.waitingThreads > 0) {
                    this.pool.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection(ConnectionWrapper connection) {
        if (connection.invalidate) {
            this.decreaseCount();
        } else {
            LinkedList<ConnectionWrapper> linkedList = this.pool;
            synchronized (linkedList) {
                if (!this.closed) {
                    this.pool.addFirst(connection);
                    if (this.waitingThreads > 0) {
                        this.pool.notify();
                    }
                    return;
                }
            }
        }
        connection.closeUnderlyingConnection();
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public int activeCount() {
        return this.activeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIdleConnections() {
        LinkedList<ConnectionWrapper> linkedList = this.pool;
        synchronized (linkedList) {
            return this.pool.size();
        }
    }

    @Override
    public int getMaxConnections() {
        return this.poolSize;
    }

    @Override
    public long getBorrowTimeout() {
        return this.borrowTimeout;
    }

    @Override
    public long getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

