/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc.cache.memory;

import com.blade.jdbc.cache.MemoryCache;
import com.blade.jdbc.cache.memory.CacheObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache
extends MemoryCache {
    public LRUCache(int cacheSize) {
        super(cacheSize);
        this._mCache = new LinkedHashMap<String, CacheObject<String, Object>>(cacheSize + 1, 1.0f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, CacheObject<String, Object>> eldest) {
                return LRUCache.this.removeEldestEntry(eldest);
            }
        };
    }

    private boolean removeEldestEntry(Map.Entry<String, CacheObject<String, Object>> eldest) {
        if (this.cacheSize == 0) {
            return false;
        }
        return this.size() > this.cacheSize;
    }

    @Override
    protected int eliminateCache() {
        if (!this.isNeedClearExpiredObject()) {
            return 0;
        }
        Iterator iterator = this._mCache.values().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            CacheObject cacheObject = (CacheObject)iterator.next();
            if (!cacheObject.isExpired()) continue;
            iterator.remove();
            ++count;
        }
        return count;
    }
}

