/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc.cache.memory;

import com.blade.jdbc.cache.MemoryCache;
import com.blade.jdbc.cache.memory.CacheObject;
import java.util.Iterator;

public class LFUCache
extends MemoryCache {
    public LFUCache() {
        this(1000);
    }

    public LFUCache(int cacheSize) {
        super(cacheSize);
    }

    @Override
    protected int eliminateCache() {
        CacheObject cacheObject;
        Iterator iterator = this._mCache.values().iterator();
        int count = 0;
        long minAccessCount = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            cacheObject = (CacheObject)iterator.next();
            if (cacheObject.isExpired()) {
                iterator.remove();
                ++count;
                continue;
            }
            minAccessCount = Math.min(cacheObject.getAccessCount(), minAccessCount);
        }
        if (count > 0) {
            return count;
        }
        if (minAccessCount != Long.MAX_VALUE) {
            iterator = this._mCache.values().iterator();
            while (iterator.hasNext()) {
                cacheObject = (CacheObject)iterator.next();
                cacheObject.setAccessCount(cacheObject.getAccessCount() - minAccessCount);
                if (cacheObject.getAccessCount() > 0L) continue;
                iterator.remove();
                ++count;
            }
        }
        return count;
    }
}

