/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc.cache;

import com.blade.jdbc.cache.Cache;
import com.blade.jdbc.cache.memory.CacheObject;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class MemoryCache
implements Cache {
    protected Map<String, CacheObject<String, Object>> _mCache;
    protected Map<String, Map<?, CacheObject<String, Object>>> _hCache;
    protected final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.cacheLock.readLock();
    protected final Lock writeLock = this.cacheLock.writeLock();
    protected int cacheSize;
    protected long defaultExpire = 0L;
    protected boolean existCustomExpire;

    protected abstract int eliminateCache();

    public MemoryCache() {
        this(1000);
    }

    public MemoryCache(int cacheSize) {
        this.cacheSize = cacheSize;
        this._mCache = Collections.synchronizedMap(new HashMap());
        this._hCache = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void set(String key, byte[] value) {
        this.set_(key, value);
    }

    @Override
    public void set(String key, Serializable value) {
        this.set_(key, value);
    }

    @Override
    public void set(String key, String value) {
        this.set_(key, value);
    }

    @Override
    public void set(String key, byte[] value, long expire) {
        this.set_(key, value, expire);
    }

    @Override
    public void set(String key, Serializable value, long expire) {
        this.set_(key, value, expire);
    }

    @Override
    public void set(String key, String value, long expire) {
        this.set_(key, value, expire);
    }

    public void set_(String key, Object obj) {
        this.set_(key, obj, this.defaultExpire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_(String key, Object value, long expire) {
        this.writeLock.lock();
        try {
            CacheObject<String, Object> co = new CacheObject<String, Object>(key, value, expire);
            if (expire != 0L) {
                this.existCustomExpire = true;
            }
            if (this.isFull()) {
                this.eliminate();
            }
            this._mCache.put(key, co);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void hset(String key, String field, Serializable value) {
        this.hset(key, field, value, this.defaultExpire);
    }

    @Override
    public void hset(String key, String field, Serializable value, long expire) {
        this.hset_(key, field, value, expire);
    }

    @Override
    public void hset(String key, String field, Object value) {
        this.hset(key, field, value, this.defaultExpire);
    }

    @Override
    public void hset(String key, String field, Object value, long expire) {
        this.hset_(key, field, value, expire);
    }

    public <F> void hset_(String key, F field, Object obj) {
        this.hset_(key, field, obj, this.defaultExpire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <F> void hset_(String key, F field, Object value, long expire) {
        this.writeLock.lock();
        try {
            Map<?, CacheObject<String, Object>> coMap;
            CacheObject<String, Object> co = new CacheObject<String, Object>(key, value, expire);
            if (expire != 0L) {
                this.existCustomExpire = true;
            }
            if (this.isFull()) {
                this.eliminate();
            }
            if (null == (coMap = this._hCache.get(key))) {
                coMap = new HashMap();
            }
            coMap.put(field, co);
            this._hCache.put(key, coMap);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        this.readLock.lock();
        try {
            CacheObject<String, Object> co = this._mCache.get(key);
            if (co == null) {
                Object var3_3 = null;
                return var3_3;
            }
            if (co.isExpired()) {
                this._mCache.remove(key);
                Object var3_4 = null;
                return var3_4;
            }
            Object object = co.getValue();
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getString(String key) {
        return (String)this.get(key);
    }

    @Override
    public byte[] getBytes(String key) {
        return (byte[])this.get(key);
    }

    @Override
    public <T extends Serializable> T getObject(String key) {
        Object object = this.get(key);
        if (null != object) {
            return (T)((Serializable)object);
        }
        return null;
    }

    @Override
    public <V> V hget(String key, String field) {
        Object object = this.hget_(key, field);
        if (null != object) {
            return (V)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <F> Object hget_(String key, F field) {
        this.readLock.lock();
        try {
            Map<?, CacheObject<String, Object>> coMap = this._hCache.get(key);
            if (null == coMap) {
                Object var4_4 = null;
                return var4_4;
            }
            CacheObject<String, Object> co = coMap.get(field);
            if (null == co) {
                Object var5_6 = null;
                return var5_6;
            }
            if (co.isExpired()) {
                coMap.remove(field);
                Object var5_7 = null;
                return var5_7;
            }
            Object object = co.getValue();
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean del(String key) {
        this.writeLock.lock();
        try {
            this._mCache.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
        return true;
    }

    @Override
    public boolean hdel(String key) {
        this.writeLock.lock();
        try {
            this._hCache.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
        return true;
    }

    @Override
    public boolean hdel(String key, String field) {
        return this.hdel_(key, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <F> boolean hdel_(String key, F field) {
        this.writeLock.lock();
        try {
            Map<?, CacheObject<String, Object>> coMap = this._hCache.get(key);
            if (null != coMap) {
                coMap.remove(field);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return true;
    }

    @Override
    public void clean() {
        this._mCache = Collections.synchronizedMap(new HashMap());
        this._hCache = Collections.synchronizedMap(new HashMap());
    }

    public Set<String> keys() {
        return this._mCache.keySet();
    }

    public <F> Set<F> flieds(String key) {
        Map<?, CacheObject<String, Object>> coMap = this._hCache.get(key);
        if (null == coMap) {
            return null;
        }
        return coMap.keySet();
    }

    public int elementsInCache() {
        return this._mCache.size() + this._hCache.size();
    }

    public int size() {
        return this._mCache.size() + this._hCache.size();
    }

    protected boolean isNeedClearExpiredObject() {
        return this.defaultExpire > 0L || this.existCustomExpire;
    }

    public final int eliminate() {
        this.writeLock.lock();
        try {
            int n = this.eliminateCache();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isFull() {
        if (this.cacheSize == 0) {
            return false;
        }
        return this._mCache.size() + this._hCache.size() >= this.cacheSize;
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this._mCache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Cache cacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public Cache expire(long expire) {
        this.defaultExpire = expire;
        return this;
    }
}

