/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc;

import blade.kit.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QueryParam {
    private List<Object> argList = new ArrayList<Object>();
    private StringBuffer sqlB = new StringBuffer();

    private QueryParam() {
    }

    public static QueryParam me() {
        return new QueryParam();
    }

    public QueryParam eq(String name, Object value) {
        Assert.notEmpty((CharSequence)name);
        Assert.notNull((Object)value);
        this.sqlB.append("and ").append(name).append(" = ? ");
        this.argList.add(value);
        return this;
    }

    public QueryParam notEq(String name, Object value) {
        Assert.notEmpty((CharSequence)name);
        Assert.notNull((Object)value);
        this.sqlB.append("and ").append(name).append(" <> ? ");
        this.argList.add(value);
        return this;
    }

    public QueryParam like(String name, Object value) {
        Assert.notEmpty((CharSequence)name);
        Assert.notNull((Object)value);
        this.sqlB.append("and ").append(name).append(" like ? ");
        this.argList.add(value);
        return this;
    }

    public QueryParam notLike(String name, Object value) {
        Assert.notEmpty((CharSequence)name);
        Assert.notNull((Object)value);
        this.sqlB.append("and ").append(name).append(" not like ? ");
        this.argList.add(value);
        return this;
    }

    public QueryParam gt(String name, Object value) {
        Assert.notEmpty((CharSequence)name);
        Assert.notNull((Object)value);
        this.sqlB.append("and ").append(name).append(" > ? ");
        this.argList.add(value);
        return this;
    }

    public QueryParam gtEt(String name, Object value) {
        Assert.notEmpty((CharSequence)name);
        Assert.notNull((Object)value);
        this.sqlB.append("and ").append(name).append(" >= ? ");
        this.argList.add(value);
        return this;
    }

    public QueryParam lt(String name, Object value) {
        Assert.notEmpty((CharSequence)name);
        Assert.notNull((Object)value);
        this.sqlB.append("and ").append(name).append(" < ? ");
        this.argList.add(value);
        return this;
    }

    public QueryParam ltEt(String name, Object value) {
        Assert.notEmpty((CharSequence)name);
        Assert.notNull((Object)value);
        this.sqlB.append("and ").append(name).append(" <= ? ");
        this.argList.add(value);
        return this;
    }

    public QueryParam between(String name, Object val1, Object val2) {
        Assert.notEmpty((CharSequence)name);
        Assert.notNull((Object)val1);
        Assert.notNull((Object)val2);
        this.sqlB.append("and ").append(name).append(" between ? and ? ");
        this.argList.add(val1);
        this.argList.add(val2);
        return this;
    }

    public QueryParam or() {
        this.sqlB.append(" or ");
        return this;
    }

    public QueryParam in(String name, Object ... values) {
        Assert.notEmpty((CharSequence)name);
        Assert.notEmpty((Object[])values);
        this.sqlB.append("and ").append(name).append(" in ( ? ) ");
        this.argList.add(values);
        return this;
    }

    public QueryParam notIn(String name, Object ... values) {
        Assert.notEmpty((CharSequence)name);
        Assert.notEmpty((Object[])values);
        this.sqlB.append("and ").append(name).append(" not in ( ? ) ");
        this.argList.add(values);
        return this;
    }

    public QueryParam orderby(String orderby) {
        Assert.notEmpty((CharSequence)orderby);
        this.sqlB.append("order by " + orderby + " ");
        return this;
    }

    public QueryParam add(String sql) {
        Assert.notEmpty((CharSequence)sql);
        this.sqlB.append(sql);
        return this;
    }

    public QueryParam add(String sql, Object ... args) {
        Assert.notEmpty((CharSequence)sql);
        Assert.notEmpty((Object[])args);
        this.sqlB.append(sql);
        this.argList.addAll(Arrays.asList(args));
        return this;
    }

    public void page(int page, int count) {
        this.sqlB.append("limit ?,? ");
        this.argList.add(page);
        this.argList.add(count);
    }

    public String asSql() {
        String sqlbString = this.sqlB.toString();
        if (sqlbString.startsWith("and")) {
            sqlbString = sqlbString.replaceFirst("and", "where");
        }
        return sqlbString;
    }

    public Object[] args() {
        if (null != this.argList && this.argList.size() > 0) {
            return this.argList.toArray();
        }
        return null;
    }
}

