/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc;

import java.util.ArrayList;
import java.util.List;

public class Page<M> {
    private int page = 1;
    private int pageSize = 10;
    private int totalPage = 1;
    private long totalCount = 0L;
    private int prev_page = 1;
    private int next_page = 1;
    private int home_page = 1;
    private int last_page = 1;
    private String url = "";
    private int navNum = 1;
    private List<M> results = new ArrayList<M>();

    public Page(long totalCount, int page, int pageSize) {
        this.page = page;
        this.pageSize = pageSize;
        this.totalCount = totalCount;
        this.totalPage = (int)((this.totalCount + (long)this.pageSize - 1L) / (long)pageSize);
        this.home_page = 1;
        this.last_page = this.totalPage;
        this.prev_page = Math.max(this.page - 1, this.home_page);
        this.next_page = Math.min(this.page + 1, this.last_page);
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public int getPrev_page() {
        return this.prev_page;
    }

    public int getNext_page() {
        return this.next_page;
    }

    public int getHome_page() {
        return this.home_page;
    }

    public int getLast_page() {
        return this.last_page;
    }

    public List<M> getResults() {
        return this.results;
    }

    public void setResults(List<M> results) {
        this.results = results;
    }

    public long getNavNum() {
        return this.navNum;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public void setPrev_page(int prev_page) {
        this.prev_page = prev_page;
    }

    public void setNext_page(int next_page) {
        this.next_page = next_page;
    }

    public void setHome_page(int home_page) {
        this.home_page = home_page;
    }

    public void setLast_page(Integer last_page) {
        this.last_page = last_page;
    }

    public void setNavNum(Integer navNum) {
        this.navNum = navNum;
    }
}

