/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc;

import com.blade.jdbc.DB;
import com.blade.jdbc.exception.CallException;
import org.sql2o.Connection;
import org.sql2o.Sql2oException;

public abstract class DBJob<T> {
    protected Connection connection;

    public abstract T execute();

    public T call() {
        return this.call(false);
    }

    public synchronized T call(boolean dml) {
        try {
            this.connection = DB.sql2o.beginTransaction();
            T t = this.execute();
            if (dml) {
                this.connection.commit();
            }
            T t2 = t;
            return t2;
        }
        catch (Sql2oException e) {
            if (dml) {
                this.connection.rollback();
            }
            throw new CallException(e.getMessage());
        }
        catch (Exception e) {
            if (dml) {
                this.connection.rollback();
            }
            throw new CallException(e);
        }
        finally {
            if (null != this.connection) {
                this.connection.close();
            }
        }
    }
}

