/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc;

import blade.kit.Assert;
import com.blade.jdbc.annotation.Table;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ARKit {
    static final Set<String> WHEREPOS = new HashSet<String>(9);
    private static final List<Class<?>> BASICTYPES;

    static int indexOf(CharSequence cs, CharSequence searchChar, int start) {
        return cs.toString().indexOf(searchChar.toString(), start);
    }

    public static boolean isBasicType(Class<?> type) {
        if (null == type) {
            return false;
        }
        return BASICTYPES.contains(type);
    }

    public static String getTable(String sql) {
        Pattern pattern = Pattern.compile("from(\\s+)(\\w+)(\\s*)");
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            return matcher.group(2);
        }
        pattern = Pattern.compile("update(\\s+)(\\w+)(\\s*)");
        matcher = pattern.matcher(sql);
        if (matcher.find()) {
            return matcher.group(2);
        }
        pattern = Pattern.compile("insert(\\s+)into(\\s+)(\\w+)(\\s*)");
        matcher = pattern.matcher(sql);
        if (matcher.find()) {
            return matcher.group(3);
        }
        return null;
    }

    public static int countMatches(CharSequence str, CharSequence sub) {
        if (null == str || null == sub) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = ARKit.indexOf(str, sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static boolean hasFrom(String sql) {
        Pattern pattern = Pattern.compile("(select * from \\S+)", 2);
        Matcher matcher = pattern.matcher(sql);
        return matcher.find();
    }

    public static String[] getField(String str) {
        Pattern pattern;
        Matcher matcher;
        String[] arr = new String[2];
        if (null != str && (matcher = (pattern = Pattern.compile("(\\S+) (=|like|>|>=|<|<=|in|between|not in) \\?", 2)).matcher(str)).find()) {
            arr[0] = matcher.group(1);
            arr[1] = matcher.group(2);
            return arr;
        }
        return arr;
    }

    public static <T> String tableName(Class<T> type) {
        Table table = type.getAnnotation(Table.class);
        Assert.notNull((Object)table, (String)"The POJO @Table is null.");
        return table.value();
    }

    public static <T> String pkName(Class<T> type) {
        Table table = type.getAnnotation(Table.class);
        Assert.notNull((Object)table, (String)"The POJO @Table is null.");
        return table.PK();
    }

    public static List<String> getFields(Class<?> type) {
        if (null != type) {
            Field[] fields;
            ArrayList<String> fieldList = new ArrayList<String>();
            for (Field field : fields = type.getDeclaredFields()) {
                if (!Modifier.isPrivate(field.getModifiers()) || field.getName().equals("serialVersionUID")) continue;
                fieldList.add(field.getName());
            }
            return fieldList;
        }
        return null;
    }

    public static <T> List<String> getFields(Object t) {
        try {
            if (null != t) {
                Field[] fields;
                Class<?> type = t.getClass();
                ArrayList<String> fieldList = new ArrayList<String>();
                for (Field field : fields = type.getDeclaredFields()) {
                    field.setAccessible(true);
                    if (!Modifier.isPrivate(field.getModifiers()) || field.getName().equals("serialVersionUID") || null == field.get(t)) continue;
                    fieldList.add(field.getName());
                }
                return fieldList;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String cleanCountSql(String sql) {
        String countSql = sql;
        int pos = sql.indexOf("order by");
        if (pos != -1) {
            countSql = sql.substring(0, pos);
        }
        if ((pos = countSql.indexOf("limit")) != -1) {
            countSql = countSql.substring(0, pos);
        }
        return countSql;
    }

    public static void main(String[] args) {
        System.out.println(ARKit.getTable("select count(1) from u_ua where b = 2"));
    }

    static {
        WHEREPOS.add(">");
        WHEREPOS.add(">=");
        WHEREPOS.add("<");
        WHEREPOS.add("<=");
        WHEREPOS.add("=");
        WHEREPOS.add("<>");
        WHEREPOS.add("in");
        WHEREPOS.add("like");
        WHEREPOS.add("between");
        BASICTYPES = new ArrayList<Class>(Arrays.asList(Long.class, Integer.class, String.class, Double.class, Float.class, Date.class, Boolean.class, Byte.class, Short.class));
    }
}

