/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc;

import blade.kit.EncrypKit;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import com.blade.jdbc.AR;
import com.blade.jdbc.ARKit;
import com.blade.jdbc.DB;
import com.blade.jdbc.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sql2o.Connection;
import org.sql2o.Query;

public class ARC {
    private static final Logger LOGGER = LoggerFactory.getLogger(ARC.class);
    private Connection connection;
    private Object[] args;
    private Object[] whereArgs;
    private String executeSql;
    private boolean isCache;

    public ARC(Connection connection, String sql, boolean cache) {
        this.connection = connection;
        this.executeSql = sql;
        this.isCache = cache;
    }

    public ARC(Connection connection, String sql, boolean cache, Object ... args) {
        int pos;
        this.connection = connection;
        this.executeSql = sql;
        this.isCache = cache;
        this.args = args;
        ArrayList<Object> whereList = new ArrayList<Object>();
        int len = args.length;
        for (int i = 0; i < len && (pos = this.executeSql.indexOf("?")) != -1; ++i) {
            int lastSpace;
            String prefix = this.executeSql.substring(0, pos).trim();
            String postion = prefix.substring(lastSpace = prefix.lastIndexOf(32)).trim();
            if (ARKit.WHEREPOS.contains(postion)) {
                whereList.add(args[i]);
            }
            this.executeSql = this.executeSql.replaceFirst("\\?", ":p" + (i + 1));
        }
        this.whereArgs = whereList.toArray();
    }

    private Query buildQuery(String sql) {
        Query query = this.connection.createQuery(sql);
        LOGGER.debug("==>  Preparing: {}", new Object[]{sql});
        if (null != this.args && this.args.length > 0) {
            query.withParams(this.args);
            LOGGER.debug("==>  Parameters: {}", new Object[]{Arrays.toString(this.args)});
        }
        return query;
    }

    private Query buildCountQuery(String sql) {
        String countSql = this.getCountSql(sql);
        Query query = this.connection.createQuery(countSql);
        LOGGER.debug("==>  Preparing: {}", new Object[]{countSql});
        if (null != this.args && this.args.length > 2 && sql.indexOf("where") != -1) {
            int len = this.args.length - 2;
            if (sql.indexOf("order by") != -1) {
                --len;
            }
            Object[] ar = new Object[len];
            System.arraycopy(this.args, 0, ar, 0, len);
            query.withParams(ar);
            LOGGER.debug("==>  Parameters: {}", new Object[]{Arrays.toString(ar)});
        }
        return query;
    }

    private <T> String getCacheKey(String sql, Class<T> type) {
        String tableName = "";
        tableName = null != type && type.getSuperclass().equals(Serializable.class) && !ARKit.isBasicType(type) ? ARKit.tableName(type) : ARKit.getTable(sql);
        return tableName;
    }

    private <T> String getCacheField(String sql) {
        if (null != this.args && this.args.length > 0) {
            sql = sql + Arrays.toString(this.args);
        }
        sql = sql.replaceAll("\\s+", "");
        return EncrypKit.md5((String)sql);
    }

    private <T> String getCountCacheField(String sql) {
        if (null != this.whereArgs && this.whereArgs.length > 0) {
            sql = sql + Arrays.toString(this.whereArgs);
        }
        sql = sql.replaceAll("\\s+", "");
        return EncrypKit.md5((String)sql);
    }

    private <T> void autoAdd(Class<T> type) {
        if (this.executeSql.indexOf("select") == -1 && !ARKit.isBasicType(type)) {
            String prfix = "select * from " + ARKit.tableName(type) + " ";
            this.executeSql = prfix + this.executeSql;
        }
    }

    public <T extends Serializable> List<T> list(Class<T> type) {
        return this.list(type, false);
    }

    public Map<String, Object> map() {
        Map result = (Map)this.buildQuery(this.executeSql).executeScalar(Map.class);
        long total = null != result ? 1L : 0L;
        LOGGER.debug("<==  Total: {}", new Object[]{total});
        this.close(false);
        return result;
    }

    public List<Map<String, Object>> listmap() {
        List result = this.buildQuery(this.executeSql).executeAndFetchTable().asList();
        long total = 0L;
        if (null != result) {
            total = result.size();
        }
        LOGGER.debug("<==  Total: {}", new Object[]{total});
        this.close(false);
        return result;
    }

    public <T extends Serializable> List<T> list(Class<T> type, boolean isPage) {
        if (!ARKit.isBasicType(type)) {
            this.autoAdd(type);
        }
        List result = null;
        int total = 0;
        try {
            if (this.isCache) {
                String cacheField;
                String cacheKey = this.getCacheKey(this.executeSql, type) + "_list";
                List list_cache = (List)DB.cache.hget(cacheKey, cacheField = this.getCacheField(this.executeSql));
                if (null != list_cache) {
                    if (list_cache.size() > 0) {
                        if (!ARKit.isBasicType(type)) {
                            result = new ArrayList(list_cache.size());
                            for (Serializable id : list_cache) {
                                T t = AR.findById(type, id);
                                if (null == t) continue;
                                result.add(t);
                            }
                        } else {
                            result = list_cache;
                        }
                    }
                } else {
                    Query query = null;
                    if (!ARKit.isBasicType(type)) {
                        String pkName = ARKit.pkName(type);
                        String fidSql = this.executeSql.replaceFirst("\\*", pkName);
                        query = this.buildQuery(fidSql);
                        List ids = query.executeScalarList(Long.class);
                        if (null != ids) {
                            total = ids.size();
                            LOGGER.debug("<==  Total: {}", new Object[]{total});
                            if (total > 0) {
                                result = new ArrayList(total);
                                for (Serializable id : ids) {
                                    T t = AR.findById(type, id);
                                    if (null == t) continue;
                                    result.add(t);
                                }
                                DB.cache.hset(cacheKey, cacheField, ids);
                            }
                        }
                    } else {
                        query = this.buildQuery(this.executeSql);
                        result = query.executeScalarList(type);
                        if (null != result) {
                            total = result.size();
                            LOGGER.debug("<==  Total: {}", new Object[]{total});
                            if (total > 0) {
                                DB.cache.hset(cacheKey, cacheField, result);
                            }
                        }
                    }
                }
            } else {
                Query query = this.buildQuery(this.executeSql);
                result = !ARKit.isBasicType(type) ? query.executeAndFetch(type) : query.executeScalarList(type);
                if (null != result) {
                    total = result.size();
                }
                LOGGER.debug("<==  Total: {}", new Object[]{total});
            }
            this.close(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public <T extends Serializable> Page<T> page(Class<T> type) {
        this.autoAdd(type);
        long rows = this.count(this.executeSql);
        int page = 1;
        int pageIndex = 0;
        int pageSize = 0;
        if (null != this.args && this.args.length > 1) {
            pageSize = (Integer)this.args[this.args.length - 1];
            page = (Integer)this.args[this.args.length - 2];
            pageIndex = (page - 1) * pageSize;
            this.args[this.args.length - 2] = pageIndex;
        }
        List<T> result = this.list(type, true);
        Page<T> pageResult = new Page<T>(rows, page, pageSize);
        try {
            pageResult.setResults(result);
            this.close(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageResult;
    }

    public <T extends Serializable> T first(Class<T> type) {
        if (!ARKit.isBasicType(type)) {
            this.autoAdd(type);
        }
        Serializable result = null;
        int total = 0;
        try {
            if (this.isCache) {
                String cacheField;
                String cacheKey = this.getCacheKey(this.executeSql, type) + "_detail";
                Serializable result_cache = (Serializable)DB.cache.hget(cacheKey, cacheField = this.getCacheField(this.executeSql));
                if (null != result_cache) {
                    result = result_cache;
                } else {
                    Query query = this.buildQuery(this.executeSql);
                    result = !ARKit.isBasicType(type) ? (Serializable)query.executeAndFetchFirst(type) : (Serializable)query.executeScalar(type);
                    if (null != result) {
                        DB.cache.hset(cacheKey, cacheField, result);
                    }
                    if (null != result) {
                        total = 1;
                    }
                    LOGGER.debug("<==  Total: {}", new Object[]{total});
                }
            } else {
                Query query = this.buildQuery(this.executeSql);
                result = !ARKit.isBasicType(type) ? (Serializable)query.executeAndFetchFirst(type) : (Serializable)query.executeScalar(type);
                if (null != result) {
                    total = 1;
                }
                LOGGER.debug("<==  Total: {}", new Object[]{total});
            }
            this.close(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)result;
    }

    public long count() {
        return this.count(this.executeSql);
    }

    public long count(String sql) {
        Long result = 0L;
        try {
            String countSql = ARKit.cleanCountSql(sql);
            if (this.isCache) {
                String cacheField;
                String cacheKey = this.getCacheKey(countSql, null) + "_count";
                Long result_cache = (Long)DB.cache.hget(cacheKey, cacheField = this.getCountCacheField(countSql));
                if (null != result_cache) {
                    result = result_cache;
                } else {
                    Query query = this.buildCountQuery(countSql);
                    result = (Long)query.executeAndFetchFirst(Long.class);
                    if (null != result) {
                        DB.cache.hset(cacheKey, cacheField, result);
                    }
                    LOGGER.debug("<==  Total: {}", new Object[]{result});
                }
            } else {
                Query query = this.buildCountQuery(countSql);
                result = (Long)query.executeAndFetchFirst(Long.class);
                LOGGER.debug("<==  Total: {}", new Object[]{result});
            }
            this.close(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getCountSql(String sql) {
        int pos = (sql = sql.replaceFirst("\\*", "count(1)")).indexOf("order by");
        if (pos != -1) {
            return sql.substring(0, pos);
        }
        pos = sql.indexOf("limit");
        if (pos != -1) {
            return sql.substring(0, pos);
        }
        return sql;
    }

    public ARC cache(boolean isCache) {
        this.isCache = isCache;
        return this;
    }

    public int executeUpdate() {
        return this.executeUpdate(false);
    }

    public int executeUpdate(boolean delCache) {
        Connection connection = this.next(delCache);
        if (null != connection) {
            connection.commit();
            return connection.getResult();
        }
        return 0;
    }

    public Connection next() {
        return this.next(false);
    }

    public Connection next(boolean delCache) {
        try {
            Query query = this.buildQuery(this.executeSql);
            Connection connection = query.executeUpdate();
            int result = connection.getResult();
            if (this.isCache && result > 0) {
                String table = ARKit.getTable(this.executeSql);
                if (this.executeSql.indexOf("insert") != -1) {
                    DB.cache.hdel(table + "_list");
                    DB.cache.hdel(table + "_count");
                    DB.cache.hdel(table + "_detail");
                    LOGGER.debug("update cache:{}", new Object[]{table});
                } else if (this.executeSql.indexOf("update") != -1) {
                    DB.cache.hdel(table + "_list");
                    DB.cache.hdel(table + "_detail");
                    if (delCache) {
                        DB.cache.hdel(table + "_count");
                    }
                    LOGGER.debug("update cache:{}", new Object[]{table});
                } else if (this.executeSql.indexOf("delete") != -1) {
                    DB.cache.hdel(table + "_list");
                    DB.cache.hdel(table + "_detail");
                    DB.cache.hdel(table + "_count");
                    LOGGER.debug("update cache:{}", new Object[]{table});
                }
            }
            LOGGER.debug("<==  Total: {}", new Object[]{result});
            return connection;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.connection;
        }
    }

    public Object key() {
        try {
            Query query = this.buildQuery(this.executeSql);
            Object result = query.executeUpdate().getKey();
            if (this.isCache && null != result) {
                String table = ARKit.getTable(this.executeSql);
                if (this.executeSql.indexOf("insert") != -1) {
                    DB.cache.hdel(table + "_list");
                    DB.cache.hdel(table + "_count");
                    DB.cache.hdel(table + "_detail");
                    LOGGER.debug("update cache:{}", new Object[]{table});
                }
            }
            this.close(true);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void close(boolean isCommit) {
        if (null != this.connection) {
            if (isCommit) {
                this.connection.commit();
            }
            this.connection.close();
        }
    }
}

