/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc;

import com.blade.jdbc.ARC;
import com.blade.jdbc.ARKit;
import com.blade.jdbc.DB;
import com.blade.jdbc.QueryParam;
import java.io.Serializable;
import org.sql2o.Connection;

public final class AR {
    private static boolean isCache = null != DB.cache;

    private AR() {
    }

    public static ARC executeSQL(String sql) {
        Connection connection = DB.sql2o.beginTransaction();
        ARC brc = new ARC(connection, sql.toLowerCase(), isCache);
        return brc;
    }

    public static ARC executeSQL(String sql, Object ... args) {
        Connection connection = DB.sql2o.beginTransaction();
        ARC brc = new ARC(connection, sql.toLowerCase(), isCache, args);
        return brc;
    }

    public static ARC executeSQL(Connection connection, String sql) {
        ARC brc = new ARC(connection, sql.toLowerCase(), isCache);
        return brc;
    }

    public static ARC executeSQL(Connection connection, String sql, Object ... args) {
        ARC brc = new ARC(connection, sql.toLowerCase(), isCache, args);
        return brc;
    }

    public static ARC find(String sql) {
        return AR.executeSQL(DB.sql2o.open(), sql);
    }

    public static ARC find(String sql, Object ... args) {
        return AR.executeSQL(DB.sql2o.open(), sql, args);
    }

    public static ARC find(QueryParam queryParam) {
        return AR.executeSQL(DB.sql2o.open(), queryParam.asSql(), queryParam.args());
    }

    public static Object[] in(Object ... args) {
        return args;
    }

    public static <T extends Serializable> T findById(Class<T> type, Serializable pk) {
        String sql = "select * from " + ARKit.tableName(type) + " where " + ARKit.pkName(type) + " = ?";
        return AR.find(sql, pk).first(type);
    }

    public static ARC update(String sql) {
        return AR.executeSQL(DB.sql2o.beginTransaction(), sql);
    }

    public static ARC update(String sql, Object ... args) {
        return AR.executeSQL(DB.sql2o.beginTransaction(), sql, args);
    }

    public static void cleanCache() {
        if (null != DB.cache) {
            DB.cache.clean();
        }
    }

    public static <T> T getType(Object object) {
        if (null != object) {
            return (T)object;
        }
        return null;
    }

    public static Long getLong(Object object) {
        if (null != object) {
            return Long.valueOf(object.toString());
        }
        return null;
    }

    public static String getString(Object object) {
        if (null != object) {
            return object.toString();
        }
        return null;
    }

    public static Double getDouble(Object object) {
        if (null != object) {
            return Double.valueOf(object.toString());
        }
        return null;
    }

    public static Float getFloat(Object object) {
        if (null != object) {
            return Float.valueOf(object.toString());
        }
        return null;
    }

    public static Boolean getBoolean(Object object) {
        if (null != object) {
            return Boolean.valueOf(object.toString());
        }
        return null;
    }

    public static Byte getByte(Object object) {
        if (null != object) {
            return Byte.valueOf(object.toString());
        }
        return null;
    }

    public static Short getShort(Object object) {
        if (null != object) {
            return Short.valueOf(object.toString());
        }
        return null;
    }
}

