/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server;

import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import com.blade.web.DispatcherServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    private int port = 9000;
    private org.eclipse.jetty.server.Server server;
    private ServletContextHandler context;

    public Server(int port, boolean async) {
        this.port = port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void start(String contextPath) throws Exception {
        this.server = new org.eclipse.jetty.server.Server(this.port);
        this.server.setStopAtShutdown(true);
        this.context = new ServletContextHandler(1);
        this.context.setContextPath(contextPath);
        this.context.setResourceBase(Thread.currentThread().getContextClassLoader().getResource("").getPath());
        ServletHolder servletHolder = new ServletHolder(DispatcherServlet.class);
        servletHolder.setAsyncSupported(false);
        servletHolder.setInitOrder(1);
        this.context.addServlet(servletHolder, "/");
        this.server.setHandler((Handler)this.context);
        this.server.start();
        LOGGER.info("Blade Server Listen on http://127.0.0.1:{}", new Object[]{this.port});
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public void stop() throws Exception {
        this.context.stop();
        this.server.stop();
    }
}

