/*
 * Decompiled with CFR 0.152.
 */
package com.blade.route.loader;

import com.blade.Blade;
import com.blade.ioc.Ioc;
import com.blade.route.RouteException;
import com.blade.route.loader.ControllerLoader;

public class ClassPathControllerLoader
implements ControllerLoader {
    private String basePackage;
    private ClassLoader classLoader = ClassPathControllerLoader.class.getClassLoader();
    private Ioc ioc = Blade.me().ioc();

    public ClassPathControllerLoader() {
        this("");
    }

    public ClassPathControllerLoader(String basePackage) {
        this.basePackage = basePackage;
        if (this.basePackage != null && !"".equals(this.basePackage) && !this.basePackage.endsWith(".")) {
            this.basePackage = this.basePackage + ".";
        }
    }

    @Override
    public Object load(String controllerName) throws RouteException {
        String className = this.basePackage + controllerName;
        try {
            Class<?> controllerClass = this.classLoader.loadClass(className);
            Object controller = this.ioc.getBean(controllerClass);
            if (null == controller) {
                this.ioc.addBean(controllerClass);
                controller = this.ioc.getBean(controllerClass);
            }
            return controller;
        }
        catch (Exception e) {
            throw new RouteException(e);
        }
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

