/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.schedule;

import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.ResultSetHandler;
import com.frameworkset.common.poolman.util.SQLUtil;
import java.io.File;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.elasticsearch.client.ESDataImportException;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.JDBCRestClientUtil;
import org.frameworkset.elasticsearch.client.TaskFailedException;
import org.frameworkset.elasticsearch.client.schedule.CallInterceptor;
import org.frameworkset.elasticsearch.client.schedule.SQLInfo;
import org.frameworkset.elasticsearch.client.schedule.Status;
import org.frameworkset.elasticsearch.client.schedule.TaskContext;
import org.frameworkset.util.tokenizer.TextGrammarParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleService {
    private static Logger logger = LoggerFactory.getLogger(ScheduleService.class);
    private volatile Status currentStatus;
    private volatile Status firstStatus;
    private volatile boolean insertedCheck = false;
    private Lock insertedCheckLock = new ReentrantLock();
    private ESJDBC esjdbc;
    private String updateSQL;
    private String insertSQL;
    private String selectSQL;
    private String existSQL;
    private int lastValueType = 0;
    private int id = 1;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private Date initLastDate = null;
    private String dbname;
    private String statusTableName;
    private String statusStorePath;
    private String lastValueClumnName;
    private boolean increamentImport = true;
    private SQLInfo sqlInfo;
    private Timer timer;

    public void setIncreamentImport(boolean increamentImport) {
        this.increamentImport = increamentImport;
    }

    public String getLastValueClumnName() {
        return this.lastValueClumnName;
    }

    public SQLInfo getSqlInfo() {
        return this.sqlInfo;
    }

    public String getLastValueVarName() {
        return this.sqlInfo != null ? this.sqlInfo.getLastValueVarName() : null;
    }

    public void addStatus(Status currentStatus) throws Exception {
        SQLExecutor.insertWithDBName((String)this.dbname, (String)this.insertSQL, (Object[])new Object[]{currentStatus.getId(), currentStatus.getTime(), currentStatus.getLastValue(), this.lastValueType});
    }

    public void updateStatus(Status currentStatus) throws Exception {
        SQLExecutor.updateWithDBName((String)this.dbname, (String)this.updateSQL, (Object[])new Object[]{currentStatus.getTime(), currentStatus.getLastValue(), this.lastValueType, currentStatus.getId()});
    }

    private void initLastValueStatus(boolean update) throws Exception {
        Status currentStatus = new Status();
        currentStatus.setId(this.id);
        currentStatus.setTime(new Date().getTime());
        if (this.lastValueType == 1) {
            currentStatus.setLastValue(this.initLastDate.getTime());
        } else if (this.esjdbc.getConfigLastValue() != null) {
            currentStatus.setLastValue(this.esjdbc.getConfigLastValue());
        } else {
            currentStatus.setLastValue(0);
        }
        currentStatus.setLastValueType(this.lastValueType);
        if (!update) {
            this.addStatus(currentStatus);
        } else {
            this.updateStatus(currentStatus);
        }
        this.currentStatus = currentStatus;
        this.firstStatus = (Status)currentStatus.clone();
        this.insertedCheck = true;
        logger.info("init LastValue Status: " + currentStatus.toString());
    }

    private void scheduleImportData(final int batchSize) throws Exception {
        if (!this.esjdbc.assertCondition()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Task Assert Execute Condition Failed, Ignore");
            }
            return;
        }
        ResultSetHandler resultSetHandler = new ResultSetHandler(){

            public void handleResult(ResultSet resultSet, StatementInfo statementInfo) throws Exception {
                ScheduleService.this.esjdbc.setResultSet(resultSet);
                ScheduleService.this.esjdbc.setMetaData(statementInfo.getMeta());
                JDBCRestClientUtil jdbcRestClientUtil = new JDBCRestClientUtil();
                jdbcRestClientUtil.addDocuments(ScheduleService.this.esjdbc.getIndex(), ScheduleService.this.esjdbc.getIndexType(), ScheduleService.this.esjdbc, ScheduleService.this.esjdbc.getRefreshOption(), batchSize);
            }
        };
        if (this.sqlInfo.getParamSize() == 0) {
            SQLExecutor.queryWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, (String)this.esjdbc.getDbName(), (String)this.esjdbc.getSql(), (Object[])new Object[0]);
        } else if (!this.isIncreamentImport()) {
            this.esjdbc.setForceStop();
        } else {
            SQLExecutor.queryBeanWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, (String)this.esjdbc.getDbName(), (String)this.esjdbc.getSql(), (Object)this.getParamValue());
        }
    }

    private void preCall(TaskContext taskContext) {
        List<CallInterceptor> callInterceptors = this.esjdbc.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        for (CallInterceptor callInterceptor : callInterceptors) {
            try {
                callInterceptor.preCall(taskContext);
            }
            catch (Exception e) {
                logger.error("preCall failed:", (Throwable)e);
            }
        }
    }

    private void afterCall(TaskContext taskContext) {
        List<CallInterceptor> callInterceptors = this.esjdbc.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        CallInterceptor callInterceptor = null;
        for (int j = callInterceptors.size() - 1; j >= 0; --j) {
            callInterceptor = callInterceptors.get(j);
            try {
                callInterceptor.afterCall(taskContext);
                continue;
            }
            catch (Exception e) {
                logger.error("afterCall failed:", (Throwable)e);
            }
        }
    }

    private void throwException(TaskContext taskContext, Exception e) {
        List<CallInterceptor> callInterceptors = this.esjdbc.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        CallInterceptor callInterceptor = null;
        for (int j = callInterceptors.size() - 1; j >= 0; --j) {
            callInterceptor = callInterceptors.get(j);
            try {
                callInterceptor.throwException(taskContext, e);
                continue;
            }
            catch (Exception e1) {
                logger.error("afterCall failed:", (Throwable)e1);
            }
        }
    }

    public void timeSchedule() throws Exception {
        this.timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                TaskContext taskContext = new TaskContext(ScheduleService.this.esjdbc);
                try {
                    ScheduleService.this.preCall(taskContext);
                    ScheduleService.this.scheduleImportData(ScheduleService.this.esjdbc.getScheduleBatchSize());
                    ScheduleService.this.afterCall(taskContext);
                }
                catch (Exception e) {
                    ScheduleService.this.throwException(taskContext, e);
                    logger.error("scheduleImportData failed:", (Throwable)e);
                }
            }
        };
        Date scheduleDate = this.esjdbc.getScheduleConfig().getScheduleDate();
        Long delay = this.esjdbc.getScheduleConfig().getDeyLay();
        if (scheduleDate != null) {
            if (this.esjdbc.getScheduleConfig().getFixedRate() != null && this.esjdbc.getScheduleConfig().getFixedRate().booleanValue()) {
                this.timer.scheduleAtFixedRate(timerTask, scheduleDate, (long)this.esjdbc.getScheduleConfig().getPeriod());
            } else if (this.esjdbc.getScheduleConfig().getPeriod() != null) {
                this.timer.schedule(timerTask, scheduleDate, (long)this.esjdbc.getScheduleConfig().getPeriod());
            } else {
                this.timer.schedule(timerTask, scheduleDate);
            }
        } else {
            if (delay == null) {
                delay = 1000L;
            }
            if (this.esjdbc.getScheduleConfig().getFixedRate() != null && this.esjdbc.getScheduleConfig().getFixedRate().booleanValue()) {
                this.timer.scheduleAtFixedRate(timerTask, delay, (long)this.esjdbc.getScheduleConfig().getPeriod());
            } else if (this.esjdbc.getScheduleConfig().getPeriod() != null) {
                this.timer.schedule(timerTask, delay, (long)this.esjdbc.getScheduleConfig().getPeriod());
            } else {
                this.timer.schedule(timerTask, delay);
            }
        }
    }

    public void storeStatus() {
        try {
            this.updateStatus(this.currentStatus);
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }

    private void initStatusStore() {
        if (this.isIncreamentImport()) {
            this.statusTableName = this.esjdbc.getLastValueStoreTableName();
            if (this.statusTableName == null) {
                this.statusTableName = "increament_tab";
            }
            this.statusStorePath = this.esjdbc.getLastValueStorePath() == null || this.esjdbc.getLastValueStorePath().equals("") ? "StatusStoreDB" : this.esjdbc.getLastValueStorePath();
        }
    }

    private void initDatasource() {
        if (this.isIncreamentImport()) {
            this.dbname = this.esjdbc.getDbName() + "_config";
            String dbJNDIName = this.esjdbc.getDbName() + "_config";
            try {
                File dbpath = new File(this.statusStorePath);
                logger.info("initDatasource dbpath:" + dbpath.getCanonicalPath());
                SQLUtil.startPool((String)this.dbname, (String)"org.sqlite.JDBC", (String)("jdbc:sqlite://" + dbpath.getCanonicalPath()), (String)"root", (String)"root", null, null, (String)"select 1", (String)dbJNDIName, (int)10, (int)10, (int)20, (boolean)true, (boolean)false, null, (boolean)false, (boolean)false);
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
            this.lastValueType = this.esjdbc.getDateLastValueColumn() != null ? 1 : (this.esjdbc.getNumberLastValueColumn() != null ? 0 : (this.esjdbc.getLastValueType() != null ? this.esjdbc.getLastValueType() : 0));
            this.existSQL = "select 1 from " + this.statusTableName;
            this.selectSQL = "select id,lasttime,lastvalue,lastvaluetype from " + this.statusTableName + " where id=?";
            this.updateSQL = "update " + this.statusTableName + " set lasttime = ?,lastvalue = ? ,lastvaluetype= ? where id=?";
            this.insertSQL = "insert into " + this.statusTableName + " (id,lasttime,lastvalue,lastvaluetype) values(?,?,?,?)";
        }
    }

    public void updateStatus(long time, Object currentValue) {
        this.currentStatus.setTime(time);
        this.currentStatus.setLastValue(currentValue);
    }

    private void initTableAndStatus() {
        if (this.isIncreamentImport()) {
            try {
                this.initLastDate = this.dateFormat.parse("1970-01-01");
                SQLExecutor.queryObjectWithDBName(Integer.TYPE, (String)this.dbname, (String)this.existSQL, (Object[])new Object[0]);
            }
            catch (Exception e) {
                String tsql = "create table " + this.statusTableName + " (ID number(2),lasttime number(10),lastvalue number(10),lastvaluetype number(1),PRIMARY KEY (ID))";
                logger.info(this.statusTableName + " table \u4e0d\u5b58\u5728\uff0c" + this.statusTableName + "\uff1a" + tsql + "\u3002");
                try {
                    SQLExecutor.updateWithDBName((String)this.dbname, (String)tsql, (Object[])new Object[0]);
                    logger.info("\u521b\u5efa" + this.statusTableName + "\u8868\u6210\u529f\uff1a" + tsql + "\u3002");
                }
                catch (Exception e1) {
                    logger.info("\u521b\u5efa" + this.statusTableName + "\u8868\u5931\u8d25\uff1a" + tsql + "\u3002", (Throwable)e1);
                    throw new ESDataImportException(e1);
                }
            }
            try {
                this.currentStatus = (Status)SQLExecutor.queryObjectWithDBName(Status.class, (String)this.dbname, (String)this.selectSQL, (Object[])new Object[]{this.id});
                if (this.currentStatus == null) {
                    this.initLastValueStatus(false);
                }
                if (this.esjdbc.isFromFirst()) {
                    this.initLastValueStatus(true);
                }
                this.firstStatus = (Status)this.currentStatus.clone();
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        } else {
            try {
                Status currentStatus = new Status();
                currentStatus.setId(this.id);
                currentStatus.setTime(new Date().getTime());
                this.firstStatus = (Status)currentStatus.clone();
                this.currentStatus = currentStatus;
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        }
    }

    public void init(ESJDBC esjdbc) {
        this.esjdbc = esjdbc;
        this.initSQLInfo();
        this.initLastValueClumnName();
        if (this.sqlInfo != null && this.sqlInfo.getParamSize() > 0 && !this.isIncreamentImport()) {
            throw new TaskFailedException("\u975e\u589e\u91cf\u5bfc\u5165sql\u8bed\u53e5\u4e2d\u4e0d\u80fd\u8bbe\u7f6e\u53c2\u6570\u53d8\u91cf\uff1a" + esjdbc.getSql());
        }
        this.initStatusStore();
        this.initDatasource();
        this.initTableAndStatus();
        this.esjdbc.setScheduleService(this);
    }

    public void initLastValueClumnName() {
        if (this.lastValueClumnName != null) {
            return;
        }
        if (this.esjdbc.getDateLastValueColumn() != null) {
            this.lastValueClumnName = this.esjdbc.getDateLastValueColumn();
        } else if (this.esjdbc.getNumberLastValueColumn() != null) {
            this.lastValueClumnName = this.esjdbc.getNumberLastValueColumn();
        } else if (this.getLastValueVarName() != null) {
            if (logger.isInfoEnabled()) {
                logger.info("NumberLastValueColumn and DateLastValueColumn not setted,use LastValueVarName[" + this.getLastValueVarName() + "] in sql[ " + this.esjdbc.getSql() + "]");
            }
            this.lastValueClumnName = this.getLastValueVarName();
        }
        if (this.lastValueClumnName == null) {
            this.setIncreamentImport(false);
        }
    }

    private void initSQLInfo() {
        String originSQL = this.esjdbc.getSql();
        List tokens = TextGrammarParser.parser((String)originSQL, (String)"#[", (String)"]");
        SQLInfo _sqlInfo = new SQLInfo();
        int paramSize = 0;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            TextGrammarParser.GrammarToken token = (TextGrammarParser.GrammarToken)tokens.get(i);
            if (token.texttoken()) {
                builder.append(token.getText());
                continue;
            }
            builder.append("?");
            if (paramSize == 0) {
                _sqlInfo.setLastValueVarName(token.getText());
            }
            ++paramSize;
        }
        _sqlInfo.setParamSize(paramSize);
        _sqlInfo.setSql(builder.toString());
        this.sqlInfo = _sqlInfo;
    }

    public SQLInfo getLastValueSQL() {
        return this.sqlInfo;
    }

    public Map getParamValue() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.lastValueType == 0) {
            params.put(this.sqlInfo.getLastValueVarName(), this.currentStatus.getLastValue());
        } else if (this.currentStatus.getLastValue() instanceof Date) {
            params.put(this.sqlInfo.getLastValueVarName(), this.currentStatus.getLastValue());
        } else {
            params.put(this.sqlInfo.getLastValueVarName(), new Date((Long)this.currentStatus.getLastValue()));
        }
        if (logger.isInfoEnabled()) {
            logger.info("Current values: " + params);
        }
        return params;
    }

    public void stop() {
        this.timer.cancel();
        try {
            SQLUtil.stopPool((String)this.dbname);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public void flushLastValue(Object lastValue) {
        this.currentStatus.setTime(System.currentTimeMillis());
        this.currentStatus.setLastValue(lastValue);
        if (this.isIncreamentImport()) {
            this.storeStatus();
        }
    }

    public Status getFirstStatus() {
        return this.firstStatus;
    }

    public void setFirstStatus(Status firstStatus) {
        this.firstStatus = firstStatus;
    }

    public boolean isIncreamentImport() {
        return this.increamentImport;
    }
}

