/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.ErrorWrapper;
import org.frameworkset.elasticsearch.client.ImportCount;
import org.frameworkset.elasticsearch.client.TaskFailedException;
import org.frameworkset.elasticsearch.handler.ESVoidResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCall
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(TaskCall.class);
    private String refreshOption;
    private ClientInterface clientInterface;
    private String datas;
    private ErrorWrapper errorWrapper;
    private int taskNo;
    private ImportCount totalCount;
    private boolean printTaskLog;
    private int currentSize;

    public TaskCall(String refreshOption, String datas, ErrorWrapper errorWrapper, int taskNo, ImportCount totalCount, int currentSize, boolean printTaskLog) {
        this.refreshOption = refreshOption;
        this.clientInterface = errorWrapper.getClientInterface();
        this.datas = datas;
        this.errorWrapper = errorWrapper;
        this.taskNo = taskNo;
        this.currentSize = currentSize;
        this.totalCount = totalCount;
        this.printTaskLog = printTaskLog;
    }

    public static String call(String refreshOption, ClientInterface clientInterface, String datas, ESJDBC esjdbc) {
        if (esjdbc.isDebugResponse()) {
            String data = null;
            if (refreshOption == null) {
                data = clientInterface.executeHttp("_bulk", datas, "post");
                logger.info(data);
            } else {
                data = clientInterface.executeHttp("_bulk?" + refreshOption, datas, "post");
                logger.info(data);
            }
            return data;
        }
        if (esjdbc.isDiscardBulkResponse()) {
            ESVoidResponseHandler esVoidResponseHandler = new ESVoidResponseHandler();
            if (refreshOption == null) {
                clientInterface.executeHttp("_bulk", datas, "post", (ResponseHandler)esVoidResponseHandler);
            } else {
                clientInterface.executeHttp("_bulk?" + refreshOption, datas, "post", (ResponseHandler)esVoidResponseHandler);
            }
            if (esVoidResponseHandler.getElasticSearchException() != null) {
                throw esVoidResponseHandler.getElasticSearchException();
            }
            return null;
        }
        String data = null;
        data = refreshOption == null ? clientInterface.executeHttp("_bulk", datas, "post") : clientInterface.executeHttp("_bulk?" + refreshOption, datas, "post");
        return data;
    }

    @Override
    public void run() {
        long totalSize;
        StringBuilder info;
        long start;
        block9: {
            if (!this.errorWrapper.assertCondition()) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Task[" + this.taskNo + "] Assert Execute Condition Failed, Ignore");
                }
                return;
            }
            start = System.currentTimeMillis();
            info = null;
            if (this.printTaskLog) {
                info = new StringBuilder();
            }
            totalSize = 0L;
            try {
                if (this.printTaskLog) {
                    info.append("Task[").append(this.taskNo).append("] starting ......");
                    logger.info(info.toString());
                }
                TaskCall.call(this.refreshOption, this.clientInterface, this.datas, this.errorWrapper.getESJDBC());
                totalSize = this.totalCount.increamentTotalCount(this.currentSize);
            }
            catch (Exception e) {
                this.errorWrapper.setError(e);
                if (this.printTaskLog) {
                    long end = System.currentTimeMillis();
                    info.setLength(0);
                    info.append("Task[").append(this.taskNo).append("] failed,take ").append(end - start).append("\u6beb\u79d2");
                    logger.info(info.toString());
                }
                if (!this.errorWrapper.getESJDBC().isContinueOnError()) {
                    throw new TaskFailedException("Task[" + this.taskNo + "] Execute Failed", e);
                }
                if (!logger.isErrorEnabled()) break block9;
                logger.error("Task[" + this.taskNo + "] Execute Failed,but continue On Error!", (Throwable)e);
            }
        }
        if (this.printTaskLog) {
            long end = System.currentTimeMillis();
            info.setLength(0);
            info.append("Task[").append(this.taskNo).append("] finish,import data ").append(this.currentSize).append("\u6761,Total import data ").append(totalSize).append("\u6761,Take ").append(end - start).append("\u6beb\u79d2");
            logger.debug(info.toString());
        }
    }
}

