/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.common.poolman.handle.ValueExchange;
import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.util.SimpleStringUtil;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.Context;
import org.frameworkset.elasticsearch.client.ContextImpl;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.ErrorWrapper;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.client.ImportCount;
import org.frameworkset.elasticsearch.client.TaskCall;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;
import org.frameworkset.elasticsearch.template.ESUtil;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCRestClientUtil
extends ErrorWrapper {
    private static Logger logger = LoggerFactory.getLogger(JDBCRestClientUtil.class);
    private ClientInterface clientInterface;
    private ESJDBC jdbcResultSet;
    public static final Class[] basePrimaryTypes = new Class[]{Integer.TYPE, Long.TYPE, Boolean.TYPE, Float.TYPE, Short.TYPE, Double.TYPE, Character.TYPE, Byte.TYPE, BigInteger.class, BigDecimal.class};

    public JDBCRestClientUtil() {
        this.clientInterface = ElasticSearchHelper.getRestClientUtil();
    }

    public JDBCRestClientUtil(String esCluster) {
        this.clientInterface = ElasticSearchHelper.getRestClientUtil((String)esCluster);
    }

    private String parallelBatchExecute(String indexName, String indexType, int batchsize, String refreshOption) {
        int count = 0;
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        String ret = null;
        ExecutorService service = this.jdbcResultSet.buildThreadPool();
        ArrayList<Future> tasks = new ArrayList<Future>();
        int taskNo = 0;
        ImportCount totalCount = new ImportCount();
        Throwable exception = null;
        Object lastValue = null;
        try {
            String datas;
            while (this.jdbcResultSet.next()) {
                if (!this.assertCondition()) {
                    throw this.error;
                }
                lastValue = this.jdbcResultSet.getLastValue();
                JDBCRestClientUtil.evalBuilk((Writer)writer, indexName, indexType, this.jdbcResultSet, "index");
                if (++count != batchsize) continue;
                writer.flush();
                datas = builder.toString();
                builder.setLength(0);
                writer.close();
                writer = new BBossStringWriter(builder);
                count = 0;
                tasks.add(service.submit(new TaskCall(refreshOption, datas, this, taskNo, totalCount, batchsize, this.jdbcResultSet.isPrintTaskLog())));
                ++taskNo;
            }
            if (count > 0) {
                if (this.error != null && !this.jdbcResultSet.isContinueOnError()) {
                    throw this.error;
                }
                writer.flush();
                datas = builder.toString();
                tasks.add(service.submit(new TaskCall(refreshOption, datas, this, taskNo, totalCount, count, this.jdbcResultSet.isPrintTaskLog())));
                ++taskNo;
                if (this.isPrintTaskLog()) {
                    logger.info("submit tasks:" + taskNo);
                }
            } else if (this.isPrintTaskLog()) {
                logger.info("submit tasks:" + taskNo);
            }
        }
        catch (SQLException e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            this.waitTasksComplete(this.jdbcResultSet, tasks, service, (Exception)exception, lastValue, totalCount);
            try {
                writer.close();
            }
            catch (Exception exception2) {}
        }
        return ret;
    }

    private String batchExecute(String indexName, String indexType, int batchsize, String refreshOption) {
        int count = 0;
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        String ret = null;
        int taskNo = 0;
        Throwable exception = null;
        Object lastValue = null;
        long start = System.currentTimeMillis();
        long istart = 0L;
        long end = 0L;
        long totalCount = 0L;
        try {
            String datas;
            istart = start;
            while (this.jdbcResultSet.next()) {
                lastValue = this.jdbcResultSet.getLastValue();
                JDBCRestClientUtil.evalBuilk((Writer)writer, indexName, indexType, this.jdbcResultSet, "index");
                if (++count != batchsize) continue;
                writer.flush();
                datas = builder.toString();
                builder.setLength(0);
                writer.close();
                writer = new BBossStringWriter(builder);
                count = 0;
                ++taskNo;
                ret = TaskCall.call(refreshOption, this.clientInterface, datas, this.jdbcResultSet);
                this.jdbcResultSet.flushLastValue(lastValue);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    logger.info("Task[" + taskNo + "] complete,take " + (end - istart) + "\u6beb\u79d2" + ",import " + batchsize + "\u6761\u8bb0\u5f55");
                    istart = end;
                }
                totalCount += (long)batchsize;
            }
            if (count > 0) {
                writer.flush();
                datas = builder.toString();
                ++taskNo;
                ret = TaskCall.call(refreshOption, this.clientInterface, datas, this.jdbcResultSet);
                this.jdbcResultSet.flushLastValue(lastValue);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    logger.info("Task[" + taskNo + "] complete,take " + (end - istart) + "\u6beb\u79d2" + ",import " + count + "\u6761\u8bb0\u5f55");
                }
                totalCount += (long)count;
            }
            if (this.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                logger.info("Execute Tasks:" + taskNo + ",All Take " + (end - start) + "\u6beb\u79d2" + ",Import total records:" + totalCount + "\u6761\u8bb0\u5f55");
            }
        }
        catch (SQLException e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (exception != null && !this.getESJDBC().isContinueOnError()) {
                this.getESJDBC().stop();
            }
            try {
                writer.close();
            }
            catch (Exception exception2) {}
        }
        return ret;
    }

    private String serialExecute(String indexName, String indexType, ESJDBC jdbcResultSet, String refreshOption, int batchsize) {
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        Object lastValue = null;
        Exception exception = null;
        long start = System.currentTimeMillis();
        long totalCount = 0L;
        try {
            while (jdbcResultSet.next()) {
                try {
                    lastValue = jdbcResultSet.getLastValue();
                    JDBCRestClientUtil.evalBuilk((Writer)writer, indexName, indexType, jdbcResultSet, "index");
                    ++totalCount;
                }
                catch (Exception e) {
                    throw new ElasticSearchException((Throwable)e);
                }
            }
            writer.flush();
            String ret = TaskCall.call(refreshOption, this.clientInterface, builder.toString(), jdbcResultSet);
            jdbcResultSet.flushLastValue(lastValue);
            if (this.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                logger.info("All Take " + (end - start) + "\u6beb\u79d2" + ",Import total records:" + totalCount + "\u6761\u8bb0\u5f55");
            }
            String string = ret;
            return string;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (exception != null && !this.getESJDBC().isContinueOnError()) {
                this.getESJDBC().stop();
            }
        }
    }

    public String addDocuments(String indexName, String indexType, ESJDBC jdbcResultSet, String refreshOption, int batchsize) throws ElasticSearchException {
        if (jdbcResultSet == null || jdbcResultSet.getResultSet() == null) {
            return null;
        }
        this.jdbcResultSet = jdbcResultSet;
        if (this.isPrintTaskLog()) {
            logger.info("AddDocuments to IndexName[" + indexName + "] IndexType[" + indexType + "] start.");
        }
        if (batchsize <= 0) {
            return this.serialExecute(indexName, indexType, jdbcResultSet, refreshOption, batchsize);
        }
        if (jdbcResultSet.getThreadCount() > 0 && jdbcResultSet.isParallel()) {
            return this.parallelBatchExecute(indexName, indexType, batchsize, refreshOption);
        }
        return this.batchExecute(indexName, indexType, batchsize, refreshOption);
    }

    private void jobComplete(ExecutorService service, Exception exception, Object lastValue) {
        if (this.jdbcResultSet.getScheduleService() == null) {
            service.shutdown();
        } else if (this.assertCondition(exception)) {
            this.jdbcResultSet.flushLastValue(lastValue);
        } else {
            service.shutdown();
            this.getESJDBC().stop();
        }
    }

    private boolean isPrintTaskLog() {
        return this.getESJDBC().isPrintTaskLog() && logger.isInfoEnabled();
    }

    private void waitTasksComplete(ESJDBC jdbcResultSet, final List<Future> tasks, final ExecutorService service, Exception exception, Object lastValue, final ImportCount totalCount) {
        if (!jdbcResultSet.isAsyn() || jdbcResultSet.getScheduleService() != null) {
            int count = 0;
            for (Future future : tasks) {
                try {
                    future.get();
                    ++count;
                }
                catch (ExecutionException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    if (e.getCause() != null) {
                        logger.error("", e.getCause());
                        continue;
                    }
                    logger.error("", (Throwable)e);
                }
                catch (Exception e) {
                    if (exception == null) {
                        exception = e;
                    }
                    logger.error("", (Throwable)e);
                }
            }
            if (this.isPrintTaskLog()) {
                logger.info("Complete tasks:" + count + ",Total import data " + totalCount.getTotalCount() + "\u6761");
            }
            this.jobComplete(service, exception, lastValue);
        } else {
            Thread completeThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int count = 0;
                    for (Future future : tasks) {
                        try {
                            future.get();
                            ++count;
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() != null) {
                                logger.error("", e.getCause());
                                continue;
                            }
                            logger.error("", (Throwable)e);
                        }
                        catch (Exception e) {
                            logger.error("", (Throwable)e);
                        }
                    }
                    if (JDBCRestClientUtil.this.isPrintTaskLog()) {
                        logger.info("Complete tasks:" + count + ",Total import data " + totalCount.getTotalCount() + "\u6761");
                    }
                    JDBCRestClientUtil.this.jobComplete(service, null, null);
                }
            });
            completeThread.start();
        }
    }

    private Object handleDate(ResultSet row, int i) {
        Comparable<Integer> value;
        block6: {
            value = null;
            try {
                try {
                    value = row.getTimestamp(i + 1);
                    if (value != null) {
                        value = ((Timestamp)value).getTime();
                        break block6;
                    }
                    value = 0;
                }
                catch (Exception e) {
                    value = row.getDate(i + 1);
                    if (value != null) {
                        value = ((Date)value).getTime();
                        break block6;
                    }
                    value = 0;
                }
            }
            catch (Exception e) {
                value = 0;
            }
        }
        return value;
    }

    private static Object getEsId(ESJDBC jdbcResultSet) throws Exception {
        if (jdbcResultSet.getEsIdField() != null) {
            return jdbcResultSet.getValue(jdbcResultSet.getEsIdField());
        }
        return null;
    }

    private static Object getEsParentId(ESJDBC jdbcResultSet) throws Exception {
        if (jdbcResultSet.getEsParentIdField() != null) {
            return jdbcResultSet.getValue(jdbcResultSet.getEsParentIdField());
        }
        return jdbcResultSet.getEsParentIdValue();
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, ESJDBC jdbcResultSet, String action) throws Exception {
        Object id = JDBCRestClientUtil.getEsId(jdbcResultSet);
        Object parentId = JDBCRestClientUtil.getEsParentId(jdbcResultSet);
        Object routing = jdbcResultSet.getValue(jdbcResultSet.getRoutingField());
        if (routing == null) {
            routing = jdbcResultSet.getRoutingValue();
        }
        Integer esRetryOnConflict = jdbcResultSet.getEsRetryOnConflict();
        JDBCRestClientUtil.buildMeta(writer, indexType, indexName, jdbcResultSet, action, id, parentId, routing, esRetryOnConflict);
    }

    private static Object getVersion(ESJDBC esjdbc) throws Exception {
        Object version = esjdbc.getEsVersionField() != null ? esjdbc.getValue(esjdbc.getEsVersionField()) : esjdbc.getEsVersionValue();
        return version;
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, ESJDBC esjdbc, String action, Object id, Object parentId, Object routing, Object esRetryOnConflict) throws Exception {
        if (id != null) {
            String versionType;
            Object version;
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            writer.write(indexName);
            writer.write("\", \"_type\" : \"");
            writer.write(indexType);
            writer.write("\", \"_id\" : ");
            BuildTool.buildId((Object)id, (Writer)writer, (boolean)true);
            if (parentId != null) {
                writer.write(", \"parent\" : ");
                BuildTool.buildId((Object)parentId, (Writer)writer, (boolean)true);
            }
            if (routing != null) {
                writer.write(", \"_routing\" : ");
                BuildTool.buildId((Object)routing, (Writer)writer, (boolean)true);
            }
            if (esRetryOnConflict != null) {
                writer.write(",\"_retry_on_conflict\":");
                writer.write(String.valueOf(esRetryOnConflict));
            }
            if ((version = JDBCRestClientUtil.getVersion(esjdbc)) != null) {
                writer.write(",\"_version\":");
                writer.write(String.valueOf(version));
            }
            if ((versionType = esjdbc.getEsVersionType()) != null) {
                writer.write(",\"_version_type\":\"");
                writer.write(String.valueOf(versionType));
                writer.write("\"");
            }
            writer.write(" } }\n");
        } else {
            String versionType;
            Object version;
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            writer.write(indexName);
            writer.write("\", \"_type\" : \"");
            writer.write(indexType);
            if (parentId != null) {
                writer.write(", \"parent\" : ");
                BuildTool.buildId((Object)parentId, (Writer)writer, (boolean)true);
            }
            if (routing != null) {
                writer.write(", \"_routing\" : ");
                BuildTool.buildId((Object)routing, (Writer)writer, (boolean)true);
            }
            if (esRetryOnConflict != null) {
                writer.write(",\"_retry_on_conflict\":");
                writer.write(String.valueOf(esRetryOnConflict));
            }
            if ((version = JDBCRestClientUtil.getVersion(esjdbc)) != null) {
                writer.write(",\"_version\":");
                writer.write(String.valueOf(version));
            }
            if ((versionType = esjdbc.getEsVersionType()) != null) {
                writer.write(",\"_version_type\":\"");
                writer.write(String.valueOf(versionType));
                writer.write("\"");
            }
            writer.write("\" } }\n");
        }
    }

    public static void evalBuilk(Writer writer, String indexName, String indexType, ESJDBC jdbcResultSet, String action) throws Exception {
        if (jdbcResultSet != null) {
            ContextImpl context = new ContextImpl(jdbcResultSet);
            jdbcResultSet.refactorData(context);
            JDBCRestClientUtil.buildMeta(writer, indexType, indexName, jdbcResultSet, action);
            if (!action.equals("update")) {
                JDBCRestClientUtil.serialResult(writer, jdbcResultSet, context);
            } else {
                writer.write("{\"doc\":");
                JDBCRestClientUtil.serialResult(writer, jdbcResultSet, context);
                if (jdbcResultSet.getEsDocAsUpsert() != null) {
                    writer.write(",\"doc_as_upsert\":");
                    writer.write(String.valueOf(jdbcResultSet.getEsDocAsUpsert()));
                }
                if (jdbcResultSet.getEsReturnSource() != null) {
                    writer.write(",\"_source\":");
                    writer.write(String.valueOf(jdbcResultSet.getEsReturnSource()));
                }
                writer.write("}\n");
            }
        }
    }

    private static void serialResult(Writer writer, ESJDBC esjdbc, Context context) throws Exception {
        PoolManResultSetMetaData metaData = esjdbc.getMetaData();
        int counts = metaData.getColumnCount();
        writer.write("{");
        Boolean useJavaName = esjdbc.getUseJavaName();
        if (useJavaName == null) {
            useJavaName = true;
        }
        Boolean useLowcase = esjdbc.getUseLowcase();
        if (useJavaName == null) {
            useJavaName = false;
        }
        if (useLowcase == null) {
            useLowcase = false;
        }
        boolean hasSeted = false;
        for (int i = 0; i < counts; ++i) {
            String colName = metaData.getColumnLabelByIndex(i);
            String javaName = null;
            FieldMeta fieldMeta = context.getMappingName(colName);
            if (fieldMeta != null) {
                if (fieldMeta.getIgnore() != null && fieldMeta.getIgnore().booleanValue()) continue;
                javaName = fieldMeta.getEsFieldName();
            } else if (useJavaName.booleanValue()) {
                javaName = metaData.getColumnJavaNameByIndex(i);
            } else {
                String string = javaName = useLowcase == false ? colName : metaData.getColumnLabelLowerByIndex(i);
            }
            if (javaName == null) {
                javaName = colName;
            }
            if (hasSeted) {
                writer.write(",");
            } else {
                hasSeted = true;
            }
            writer.write("\"");
            writer.write(javaName);
            writer.write("\":");
            Object value = esjdbc.getValue(i, colName);
            if (value != null) {
                CharEscapeUtil charEscapeUtil;
                String dataStr;
                if (value instanceof String) {
                    writer.write("\"");
                    CharEscapeUtil charEscapeUtil2 = new CharEscapeUtil(writer);
                    charEscapeUtil2.writeString((String)value, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof java.util.Date) {
                    DateFormateMeta dateFormateMeta;
                    DateFormat dateFormat = null;
                    if (fieldMeta != null && (dateFormateMeta = fieldMeta.getDateFormateMeta()) != null) {
                        dateFormat = dateFormateMeta.toDateFormat();
                    }
                    if (dateFormat == null) {
                        dateFormat = esjdbc.getFormat();
                    }
                    String dataStr2 = ESUtil.getDate((java.util.Date)((java.util.Date)value), (DateFormat)dateFormat);
                    writer.write("\"");
                    writer.write(dataStr2);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Clob) {
                    dataStr = ValueExchange.getStringFromClob((Clob)((Clob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Blob) {
                    dataStr = ValueExchange.getStringFromBlob((Blob)((Blob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                writer.write(String.valueOf(value));
                continue;
            }
            writer.write("null");
        }
        List<FieldMeta> fieldValueMetas = esjdbc.getFieldValues();
        hasSeted = JDBCRestClientUtil.appendFieldValues(writer, esjdbc, fieldValueMetas, hasSeted);
        fieldValueMetas = context.getFieldValues();
        JDBCRestClientUtil.appendFieldValues(writer, esjdbc, fieldValueMetas, hasSeted);
        writer.write("}\n");
    }

    private static boolean appendFieldValues(Writer writer, ESJDBC esjdbc, List<FieldMeta> fieldValueMetas, boolean hasSeted) throws IOException {
        if (fieldValueMetas != null && fieldValueMetas.size() > 0) {
            for (int i = 0; i < fieldValueMetas.size(); ++i) {
                FieldMeta fieldMeta = fieldValueMetas.get(i);
                String javaName = fieldMeta.getEsFieldName();
                Object value = fieldMeta.getValue();
                if (hasSeted) {
                    writer.write(",");
                } else {
                    hasSeted = true;
                }
                writer.write("\"");
                writer.write(javaName);
                writer.write("\":");
                if (value != null) {
                    if (value instanceof String) {
                        writer.write("\"");
                        CharEscapeUtil charEscapeUtil = new CharEscapeUtil(writer);
                        charEscapeUtil.writeString((String)value, true);
                        writer.write("\"");
                        continue;
                    }
                    if (value instanceof java.util.Date) {
                        DateFormateMeta dateFormateMeta;
                        DateFormat dateFormat = null;
                        if (fieldMeta != null && (dateFormateMeta = fieldMeta.getDateFormateMeta()) != null) {
                            dateFormat = dateFormateMeta.toDateFormat();
                        }
                        if (dateFormat == null) {
                            dateFormat = esjdbc.getFormat();
                        }
                        String dataStr = ESUtil.getDate((java.util.Date)((java.util.Date)value), (DateFormat)dateFormat);
                        writer.write("\"");
                        writer.write(dataStr);
                        writer.write("\"");
                        continue;
                    }
                    if (JDBCRestClientUtil.isBasePrimaryType(value.getClass())) {
                        writer.write(String.valueOf(value));
                        continue;
                    }
                    SimpleStringUtil.object2json((Object)value, (Writer)writer);
                    continue;
                }
                writer.write("null");
            }
        }
        return hasSeted;
    }

    public static boolean isBasePrimaryType(Class type) {
        if (!type.isArray()) {
            if (type.isEnum()) {
                return true;
            }
            for (Class primaryType : basePrimaryTypes) {
                if (!primaryType.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public ClientInterface getClientInterface() {
        return this.clientInterface;
    }

    @Override
    public ESJDBC getESJDBC() {
        return this.jdbcResultSet;
    }
}

