/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.frameworkset.elasticsearch.client.BlockedTaskRejectedExecutionHandler;
import org.frameworkset.elasticsearch.client.Context;
import org.frameworkset.elasticsearch.client.DBESThread;
import org.frameworkset.elasticsearch.client.DataRefactor;
import org.frameworkset.elasticsearch.client.ErrorWrapper;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.client.ImportBuilder;
import org.frameworkset.elasticsearch.client.schedule.CallInterceptor;
import org.frameworkset.elasticsearch.client.schedule.ImportIncreamentConfig;
import org.frameworkset.elasticsearch.client.schedule.ScheduleConfig;
import org.frameworkset.elasticsearch.client.schedule.ScheduleService;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.elasticsearch.util.ESJDBCResultSet;
import org.frameworkset.persitent.util.JDBCResultSet;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESJDBC
extends JDBCResultSet
implements ESJDBCResultSet {
    private static Logger logger = LoggerFactory.getLogger(ESJDBC.class);
    private ScheduleService scheduleService;
    private ErrorWrapper errorWrapper;
    private volatile boolean forceStop = false;
    private boolean printTaskLog = false;
    private List<CallInterceptor> callInterceptors;
    private ImportBuilder importBuilder;
    private boolean parallel;
    private int threadCount = 200;
    private int queue = Integer.MAX_VALUE;
    private String applicationPropertiesFile;
    private boolean usePool = false;
    private String esIdField;
    private String esParentIdField;
    private String esParentIdValue;
    private String routingField;
    private String routingValue;
    private Boolean esDocAsUpsert;
    private Integer esRetryOnConflict;
    private Boolean esReturnSource;
    private String esVersionField;
    private Object esVersionValue;
    private String esVersionType;
    private Boolean useJavaName;
    private Boolean useLowcase;
    private String dateFormat;
    private String locale;
    private String timeZone;
    private DateFormat format;
    private Map<String, FieldMeta> fieldMetaMap;
    private List<FieldMeta> fieldValues;
    private DataRefactor dataRefactor;
    private String sql;
    private String sqlFilepath;
    private Integer jdbcFetchSize;
    private String dbName;
    private String refreshOption;
    private int batchSize = 1000;
    private Integer scheduleBatchSize;
    private String index;
    private String dbDriver;
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private String validateSQL;
    private AtomicInteger rejectCounts = new AtomicInteger();
    private boolean asyn;
    private boolean continueOnError = true;
    private boolean discardBulkResponse = true;
    private boolean debugResponse;
    private boolean showSql;
    private ScheduleConfig scheduleConfig;
    private ImportIncreamentConfig importIncreamentConfig;
    private String indexType;

    public void setForceStop() {
        this.forceStop = true;
    }

    public ErrorWrapper getErrorWrapper() {
        return this.errorWrapper;
    }

    public void setErrorWrapper(ErrorWrapper errorWrapper) {
        this.errorWrapper = errorWrapper;
    }

    public boolean assertCondition() {
        if (this.forceStop) {
            return false;
        }
        if (this.errorWrapper != null) {
            return this.errorWrapper.assertCondition();
        }
        return true;
    }

    public boolean assertCondition(Exception e) {
        if (this.errorWrapper != null) {
            return this.errorWrapper.assertCondition(e);
        }
        return true;
    }

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public void setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
    }

    public Boolean getUseLowcase() {
        return this.useLowcase;
    }

    public void setUseLowcase(Boolean useLowcase) {
        this.useLowcase = useLowcase;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getValidateSQL() {
        return this.validateSQL;
    }

    public void setValidateSQL(String validateSQL) {
        this.validateSQL = validateSQL;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getRefreshOption() {
        return this.refreshOption;
    }

    public void setRefreshOption(String refreshOption) {
        this.refreshOption = refreshOption;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public Integer getEsRetryOnConflict() {
        return this.esRetryOnConflict;
    }

    public void setEsRetryOnConflict(Integer esRetryOnConflict) {
        this.esRetryOnConflict = esRetryOnConflict;
    }

    public Boolean getEsDocAsUpsert() {
        return this.esDocAsUpsert;
    }

    public void setEsDocAsUpsert(Boolean esDocAsUpsert) {
        this.esDocAsUpsert = esDocAsUpsert;
    }

    public String getRoutingValue() {
        return this.routingValue;
    }

    public void setRoutingValue(String routingValue) {
        this.routingValue = routingValue;
    }

    public String getRoutingField() {
        return this.routingField;
    }

    public void setRoutingField(String routingField) {
        this.routingField = routingField;
    }

    public String getEsParentIdField() {
        return this.esParentIdField;
    }

    public void setEsParentIdField(String esParentIdField) {
        this.esParentIdField = esParentIdField;
    }

    public String getEsIdField() {
        return this.esIdField;
    }

    public void setEsIdField(String esIdField) {
        this.esIdField = esIdField;
    }

    public Boolean getEsReturnSource() {
        return this.esReturnSource;
    }

    public void setEsReturnSource(Boolean esReturnSource) {
        this.esReturnSource = esReturnSource;
    }

    public String getEsVersionField() {
        return this.esVersionField;
    }

    public void setEsVersionField(String esVersionField) {
        this.esVersionField = esVersionField;
    }

    public String getEsVersionType() {
        return this.esVersionType;
    }

    public void setEsVersionType(String esVersionType) {
        this.esVersionType = esVersionType;
    }

    public Boolean getUseJavaName() {
        return this.useJavaName;
    }

    public void setUseJavaName(Boolean useJavaName) {
        this.useJavaName = useJavaName;
    }

    public DateFormateMeta getDateFormateMeta() {
        return DateFormateMeta.buildDateFormateMeta((String)this.dateFormat, (String)this.locale, (String)this.timeZone);
    }

    public DateFormat getFormat() {
        if (this.format == null) {
            DateFormateMeta dateFormateMeta = this.getDateFormateMeta();
            if (dateFormateMeta == null) {
                dateFormateMeta = SerialUtil.getDateFormateMeta();
            }
            this.format = dateFormateMeta.toDateFormat();
        }
        return this.format;
    }

    public void setFormat(DateFormat format) {
        this.format = format;
    }

    public Map<String, FieldMeta> getFieldMetaMap() {
        return this.fieldMetaMap;
    }

    public void destroy() {
        this.format = null;
    }

    public void setFieldMetaMap(Map<String, FieldMeta> fieldMetaMap) {
        this.fieldMetaMap = fieldMetaMap;
    }

    public FieldMeta getMappingName(String colName) {
        if (this.fieldMetaMap != null) {
            return this.fieldMetaMap.get(colName);
        }
        return null;
    }

    public boolean isUsePool() {
        return this.usePool;
    }

    public void setUsePool(boolean usePool) {
        this.usePool = usePool;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public ExecutorService buildThreadPool() {
        ThreadPoolExecutor blockedExecutor = new ThreadPoolExecutor(this.getThreadCount(), this.getThreadCount(), 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.getQueue()), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new DBESThread(r);
            }
        }, new BlockedTaskRejectedExecutionHandler(this.rejectCounts));
        return blockedExecutor;
    }

    public int getQueue() {
        return this.queue;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }

    public boolean isAsyn() {
        return this.asyn;
    }

    public void setAsyn(boolean asyn) {
        this.asyn = asyn;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public List<FieldMeta> getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValues(List<FieldMeta> fieldValues) {
        this.fieldValues = fieldValues;
    }

    public DataRefactor getDataRefactor() {
        return this.dataRefactor;
    }

    public void setDataRefactor(DataRefactor dataRefactor) {
        this.dataRefactor = dataRefactor;
    }

    public Object getValue(int i, String colName) throws Exception {
        Object value = this.resultSet.getObject(i + 1);
        return value;
    }

    public Object getValue(String colName) throws Exception {
        if (colName == null) {
            return null;
        }
        Object value = this.resultSet.getObject(colName);
        return value;
    }

    public void refactorData(Context context) throws Exception {
        if (this.dataRefactor != null) {
            this.dataRefactor.refactor(context);
        }
    }

    public ImportBuilder getImportBuilder() {
        return this.importBuilder;
    }

    public void setImportBuilder(ImportBuilder importBuilder) {
        this.importBuilder = importBuilder;
    }

    public ESJDBC addFieldValue(String fieldName, Object value) {
        this.importBuilder.addFieldValue(fieldName, value);
        return this;
    }

    public ESJDBC addFieldValue(String fieldName, String dateFormat, Object value) {
        this.importBuilder.addFieldValue(fieldName, dateFormat, value);
        return this;
    }

    public ESJDBC addFieldValue(String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        this.importBuilder.addFieldValue(fieldName, dateFormat, value, locale, timeZone);
        return this;
    }

    public ESJDBC addFieldMapping(String dbColumnName, String esFieldName) {
        this.importBuilder.addFieldMapping(dbColumnName, esFieldName);
        return this;
    }

    public ESJDBC addIgnoreFieldMapping(String dbColumnName) {
        this.importBuilder.addIgnoreFieldMapping(dbColumnName);
        return this;
    }

    public ESJDBC addFieldMapping(String dbColumnName, String esFieldName, String dateFormat) {
        this.importBuilder.addFieldMapping(dbColumnName, esFieldName, dateFormat);
        return this;
    }

    public ESJDBC addFieldMapping(String dbColumnName, String esFieldName, String dateFormat, String locale, String timeZone) {
        this.importBuilder.addFieldMapping(dbColumnName, esFieldName, dateFormat, locale, timeZone);
        return this;
    }

    public String getEsParentIdValue() {
        return this.esParentIdValue;
    }

    public void setEsParentIdValue(String esParentIdValue) {
        this.esParentIdValue = esParentIdValue;
    }

    public Object getEsVersionValue() {
        return this.esVersionValue;
    }

    public void setEsVersionValue(Object esVersionValue) {
        this.esVersionValue = esVersionValue;
    }

    public boolean isDiscardBulkResponse() {
        return this.discardBulkResponse;
    }

    public void setDiscardBulkResponse(boolean discardBulkResponse) {
        this.discardBulkResponse = discardBulkResponse;
    }

    public boolean isDebugResponse() {
        return this.debugResponse;
    }

    public void setDebugResponse(boolean debugResponse) {
        this.debugResponse = debugResponse;
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public void setScheduleConfig(ScheduleConfig scheduleConfig) {
        this.scheduleConfig = scheduleConfig;
    }

    public ImportIncreamentConfig getImportIncreamentConfig() {
        return this.importIncreamentConfig;
    }

    public String getLastValueStoreTableName() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueStoreTableName() : null;
    }

    public String getLastValueStorePath() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueStorePath() : null;
    }

    public String getDateLastValueColumn() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getDateLastValueColumn() : null;
    }

    public String getNumberLastValueColumn() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getNumberLastValueColumn() : null;
    }

    public Integer getLastValueType() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueType() : null;
    }

    public void setImportIncreamentConfig(ImportIncreamentConfig importIncreamentConfig) {
        this.importIncreamentConfig = importIncreamentConfig;
    }

    public boolean isFromFirst() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.isFromFirst() : false;
    }

    public Long getConfigLastValue() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValue() : null;
    }

    public String getSqlFilepath() {
        return this.sqlFilepath;
    }

    public void setSqlFilepath(String sqlFilepath) {
        this.sqlFilepath = sqlFilepath;
    }

    public Integer getJdbcFetchSize() {
        return this.jdbcFetchSize;
    }

    public void setJdbcFetchSize(Integer jdbcFetchSize) {
        this.jdbcFetchSize = jdbcFetchSize;
    }

    public ScheduleService getScheduleService() {
        return this.scheduleService;
    }

    public void setScheduleService(ScheduleService scheduleService) {
        this.scheduleService = scheduleService;
    }

    public Integer getScheduleBatchSize() {
        return this.scheduleBatchSize;
    }

    public void setScheduleBatchSize(Integer scheduleBatchSize) {
        this.scheduleBatchSize = scheduleBatchSize;
    }

    public Object getLastValue() throws Exception {
        if (this.scheduleService != null) {
            if (this.scheduleService.getLastValueClumnName() == null) {
                return null;
            }
            return this.getValue(this.scheduleService.getLastValueClumnName());
        }
        return null;
    }

    public void flushLastValue(Object lastValue) {
        if (this.scheduleService != null && lastValue != null) {
            this.scheduleService.flushLastValue(lastValue);
        }
    }

    public void stop() {
        if (this.scheduleService != null) {
            this.scheduleService.stop();
        }
    }

    public List<CallInterceptor> getCallInterceptors() {
        return this.callInterceptors;
    }

    public void setCallInterceptors(List<CallInterceptor> callInterceptors) {
        this.callInterceptors = callInterceptors;
    }

    public boolean isPrintTaskLog() {
        return this.printTaskLog;
    }

    public void setPrintTaskLog(boolean printTaskLog) {
        this.printTaskLog = printTaskLog;
    }
}

