/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Map;
import javax.crypto.Cipher;
import mybatis.mate.O00000oO.O00000o0;
import mybatis.mate.O00000oO.O00000oO;
import mybatis.mate.O00000oO.O0000Oo0;
import mybatis.mate.encrypt.RSA$1;

public class RSA {
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static Map<String, Key> genKeyPair() throws NoSuchAlgorithmException {
        KeyPair keyPair = RSA.getKeyPair(1024);
        return new RSA$1(2, keyPair);
    }

    public static KeyPair getKeyPair(int n) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(n, new SecureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    public static String sign(byte[] byArray, String string) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(RSA.privateKey(string));
        signature.update(byArray);
        return O00000oO.O000000o(signature.sign());
    }

    public static boolean verify(byte[] byArray, String string, String string2) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(RSA.publicKey(string));
        signature.update(byArray);
        return signature.verify(O00000oO.O0000oO(string2));
    }

    private static byte[] cipherDecryptData(byte[] byArray, Key key) throws Exception {
        return RSA.cipherData(byArray, key, 2, 128);
    }

    private static byte[] cipherEncryptData(byte[] byArray, Key key) throws Exception {
        return RSA.cipherData(byArray, key, 1, 117);
    }

    private static byte[] cipherData(byte[] byArray, Key key, int n, int n2) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(n, key);
        int n3 = byArray.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n4 = 0;
        int n5 = 0;
        while (n3 - n4 > 0) {
            byte[] byArray2 = n3 - n4 > n2 ? cipher.doFinal(byArray, n4, n2) : cipher.doFinal(byArray, n4, n3 - n4);
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            n4 = ++n5 * n2;
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray3;
    }

    public static String encryptByPublicKey(String string, String string2) throws Exception {
        return RSA.encryptByKey(string, RSA.publicKey(string2));
    }

    public static String encryptByPrivateKey(String string, String string2) throws Exception {
        return RSA.encryptByKey(string, RSA.privateKey(string2));
    }

    private static String encryptByKey(String string, Key key) throws Exception {
        return O00000oO.O000000o(RSA.cipherEncryptData(string.getBytes(StandardCharsets.UTF_8), key));
    }

    public static String decryptByPrivateKey(String string, String string2) throws Exception {
        return RSA.decryptByKey(string, RSA.privateKey(string2));
    }

    public static String decryptByPublicKey(String string, String string2) throws Exception {
        return RSA.decryptByKey(string, RSA.publicKey(string2));
    }

    private static String decryptByKey(String string, Key key) throws Exception {
        return new String(RSA.cipherDecryptData(O00000oO.O0000oO(string), key));
    }

    public static String getPrivateKey(Map<String, Key> map) {
        return O00000oO.O000000o(map.get(PRIVATE_KEY).getEncoded());
    }

    public static String getBase64PrivateKey(Map<String, Key> map) {
        String string = Base64.getMimeEncoder().encodeToString(map.get(PRIVATE_KEY).getEncoded());
        return "-----BEGIN PRIVATE KEY-----\n" + string + "\n-----END PRIVATE KEY-----";
    }

    public static String getPublicKey(Map<String, Key> map) {
        return O00000oO.O000000o(map.get(PUBLIC_KEY).getEncoded());
    }

    public static String getBase64PublicKey(Map<String, Key> map) {
        String string = Base64.getMimeEncoder().encodeToString(map.get(PUBLIC_KEY).getEncoded());
        return "-----BEGIN PUBLIC KEY-----\n" + string + "\n-----END PUBLIC KEY-----";
    }

    public static PrivateKey privateKey(String string) throws InvalidKeySpecException {
        return RSA.privateKeyFromPKCS8(O00000oO.O0000oO(string));
    }

    public static PublicKey publicKey(String string) throws InvalidKeySpecException {
        return RSA.publicKeyFrom(O00000oO.O0000oO(string));
    }

    public static PrivateKey privateKeyFromPKCS8(byte[] byArray) throws InvalidKeySpecException {
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }

    public static PrivateKey privateKeyFromPKCS1(byte[] byArray) throws InvalidKeySpecException {
        try {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = RSA.newRSAPrivateCrtKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }

    public static PublicKey publicKeyFrom(byte[] byArray) throws InvalidKeySpecException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }

    private static RSAPrivateCrtKeySpec newRSAPrivateCrtKeySpec(byte[] byArray) throws IOException {
        O0000Oo0 o0000Oo0 = new O0000Oo0(byArray);
        O00000o0 o00000o0 = o0000Oo0.O000OO0o();
        if (o00000o0.O000O00o() != 16) {
            throw new IllegalArgumentException("Invalid DER: not a sequence");
        }
        O0000Oo0 o0000Oo02 = o00000o0.O000O0o0();
        o0000Oo02.O000OO0o();
        return new RSAPrivateCrtKeySpec(RSA.readInteger(o0000Oo02), RSA.readInteger(o0000Oo02), RSA.readInteger(o0000Oo02), RSA.readInteger(o0000Oo02), RSA.readInteger(o0000Oo02), RSA.readInteger(o0000Oo02), RSA.readInteger(o0000Oo02), RSA.readInteger(o0000Oo02));
    }

    private static BigInteger readInteger(O0000Oo0 o0000Oo0) throws IOException {
        return o0000Oo0.O000OO0o().O000O0o();
    }
}

