/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.ddl;

import java.util.function.Function;
import mybatis.mate.O00000oO.O0000oo0;
import mybatis.mate.ddl.IDdlGenerator;

public class PostgresDdlGenerator
implements IDdlGenerator {
    public static IDdlGenerator newInstance() {
        return new PostgresDdlGenerator();
    }

    @Override
    public boolean existTable(String string, Function<String, Boolean> function) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT COUNT(1) AS NUM from INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME=? AND TABLE_TYPE='BASE TABLE'");
        if (O0000oo0.O000000o(new CharSequence[]{this.getSchema()})) {
            stringBuffer.append(" AND TABLE_SCHEMA='").append(this.getSchema()).append("'");
        }
        return function.apply(stringBuffer.toString());
    }

    @Override
    public String createDdlHistory() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getSchemaAndTable();
        stringBuffer.append("CREATE TABLE IF NOT EXISTS ").append(string).append(" (");
        stringBuffer.append("\"script\" varchar(500) NOT NULL,");
        stringBuffer.append("\"type\" varchar(30) NOT NULL,");
        stringBuffer.append("\"version\" varchar(30) NOT NULL");
        stringBuffer.append(");");
        stringBuffer.append("COMMENT ON COLUMN ").append(string).append(".\"script\" IS '\u811a\u672c';");
        stringBuffer.append("COMMENT ON COLUMN ").append(string).append(".\"type\" IS '\u7c7b\u578b';");
        stringBuffer.append("COMMENT ON COLUMN ").append(string).append(".\"version\" IS '\u7248\u672c';");
        stringBuffer.append("COMMENT ON TABLE ").append(string).append(" IS 'DDL \u7248\u672c';");
        stringBuffer.append("ALTER TABLE ").append(string).append(" ADD CONSTRAINT \"ddl_history_pkey\" PRIMARY KEY (\"script\");");
        return stringBuffer.toString();
    }

    @Override
    public String selectDdlHistory() {
        return "SELECT 1 FROM " + this.getSchemaAndTable() + " WHERE script=? AND type=?";
    }

    @Override
    public String insertDdlHistory() {
        return "INSERT INTO " + this.getSchemaAndTable() + "(script,type,version) VALUES (?,?,?)";
    }

    protected String getSchemaAndTable() {
        return "\"public\".\"ddl_history\"";
    }

    protected String getSchema() {
        return "public";
    }
}

