/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.autoconfigure;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import mybatis.mate.O00000oO.O0000oo0;
import mybatis.mate.config.CertProperties;
import mybatis.mate.config.DataSourceProperty;
import mybatis.mate.config.ShardingProperties;
import mybatis.mate.provider.HikariDataSourceProvider;
import mybatis.mate.provider.IDataSourceProvider;
import mybatis.mate.sharding.IShardingProcessor;
import mybatis.mate.sharding.O000000o;
import mybatis.mate.sharding.O00000o;
import mybatis.mate.sharding.O00000oo;
import mybatis.mate.sharding.ShardingDatasource;
import mybatis.mate.strategy.IShardingStrategy;
import org.apache.ibatis.transaction.TransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.XADataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;

@Lazy
@Configuration(proxyBeanMethods=false)
@AutoConfigureOrder(value=-2147483643)
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class, XADataSourceAutoConfiguration.class})
@ConditionalOnProperty(prefix="mybatis-mate.sharding", name={"primary"})
public class O00000o0 {
    private static final Logger log = LoggerFactory.getLogger(O00000o0.class);
    @Resource
    private ShardingProperties shardingProperties;
    @Resource
    private CertProperties certProperties;
    private IShardingStrategy shardingStrategy;

    @Autowired(required=false)
    public void setShardingStrategy(IShardingStrategy iShardingStrategy) {
        this.shardingStrategy = iShardingStrategy;
    }

    @Bean
    @ConditionalOnMissingBean
    public IDataSourceProvider dataSourceProvider() {
        return new HikariDataSourceProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public IShardingProcessor shardingProcessor() {
        return new O000000o();
    }

    @Primary
    @Bean(name={"dataSource"})
    @ConditionalOnMissingBean
    public ShardingDatasource shardingDatasource(IDataSourceProvider iDataSourceProvider) {
        Map<String, List<DataSourceProperty>> map = this.shardingProperties.getDatasource();
        mybatis.mate.O000000o.O000000o.O000000o(O0000oo0.O000000o(map), "datasource can't be empty!");
        mybatis.mate.O000000o.O000000o.O000000o(O0000oo0.O00000Oo((CharSequence)this.shardingProperties.getPrimary()), "primary datasource can't be empty!");
        HashMap<String, DataSource> hashMap = new HashMap<String, DataSource>(16);
        map.forEach((string, list) -> list.forEach(dataSourceProperty -> {
            mybatis.mate.O000000o.O000000o.O000000o(O0000oo0.O00000Oo((CharSequence)dataSourceProperty.getKey()), "datasource key can't be empty!");
            String string2 = string + dataSourceProperty.getKey();
            mybatis.mate.O000000o.O000000o.O000000o(null != hashMap.get(string2), "datasource key repetition is not allowed!");
            try {
                hashMap.put(string2, iDataSourceProvider.createDataSource((String)string, (DataSourceProperty)dataSourceProperty));
            }
            catch (SQLException sQLException) {
                mybatis.mate.O000000o.O000000o.O000000o(sQLException);
            }
        }));
        if (null != this.shardingStrategy) {
            this.shardingProperties.setShardingStrategy(this.shardingStrategy);
        }
        O00000o.O000000o(this.shardingProperties);
        return new ShardingDatasource(iDataSourceProvider, hashMap);
    }

    @Bean
    @ConditionalOnMissingBean
    public TransactionFactory transactionFactory() {
        O0000oo0.O000000o(this.certProperties.getGrant(), this.certProperties.getLicense(), bl -> mybatis.mate.O000000o.O000000o.O000000o(bl));
        return new O00000oo();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="mybatis-mate.sharding", name={"health"}, havingValue="true")
    public mybatis.mate.sharding.O00000o0 shardingHealthIndicator(ShardingDatasource shardingDatasource) {
        log.debug("Datasource Health check started.");
        return new mybatis.mate.sharding.O00000o0(shardingDatasource);
    }
}

