/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5DigestCalculatingInputStream
extends FilterInputStream {
    private MessageDigest digest = MessageDigest.getInstance("MD5");
    private long digestRemain;

    public MD5DigestCalculatingInputStream(InputStream in, long len) throws NoSuchAlgorithmException {
        super(in);
        this.digestRemain = len;
    }

    public byte[] getMd5Digest() {
        return this.digest.digest();
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        this.in.reset();
    }

    @Override
    public int read() throws IOException {
        if (this.digestRemain <= 0L) {
            return -1;
        }
        int ch = this.in.read();
        if (ch != -1) {
            this.digest.update((byte)ch);
            this.digestRemain -= (long)ch;
        }
        return ch;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long curReadMax = Math.min(this.digestRemain, (long)len);
        if (curReadMax <= 0L) {
            return -1;
        }
        int result = this.in.read(b, off, (int)curReadMax);
        if (result != -1) {
            this.digest.update(b, off, result);
            this.digestRemain -= (long)result;
        }
        return result;
    }
}

