/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.ses;

import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.ses.SesClientConfiguration;
import com.baidubce.services.ses.SesClientSupport;
import com.baidubce.services.ses.model.DeleteVerifiedDomainRequest;
import com.baidubce.services.ses.model.DeleteVerifiedEmailRequest;
import com.baidubce.services.ses.model.EnableDKIMRequest;
import com.baidubce.services.ses.model.GetFailedReasonResponse;
import com.baidubce.services.ses.model.GetFeedbackResponse;
import com.baidubce.services.ses.model.GetQuotaResponse;
import com.baidubce.services.ses.model.GetVerifiedDomainRequest;
import com.baidubce.services.ses.model.GetVerifiedDomainResponse;
import com.baidubce.services.ses.model.GetVerifiedEmailRequest;
import com.baidubce.services.ses.model.GetVerifiedEmailResponse;
import com.baidubce.services.ses.model.IsInRecipientBlacklistRequest;
import com.baidubce.services.ses.model.IsInRecipientBlacklistResponse;
import com.baidubce.services.ses.model.ListRecipientBlacklistResponse;
import com.baidubce.services.ses.model.ListVerifiedDomainResponse;
import com.baidubce.services.ses.model.ListVerifiedEmailResponse;
import com.baidubce.services.ses.model.SendEmailRequest;
import com.baidubce.services.ses.model.SendEmailResponse;
import com.baidubce.services.ses.model.SesRequest;
import com.baidubce.services.ses.model.SesResponse;
import com.baidubce.services.ses.model.SetFeedbackRequest;
import com.baidubce.services.ses.model.SetQuotaRequest;
import com.baidubce.services.ses.model.VerifyDKIMRequest;
import com.baidubce.services.ses.model.VerifyDKIMResponse;
import com.baidubce.services.ses.model.VerifyDomainRequest;
import com.baidubce.services.ses.model.VerifyDomainResponse;
import com.baidubce.services.ses.model.VerifyEmailRequest;
import com.baidubce.util.JsonUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SesClient
extends SesClientSupport {
    public SesClient() {
        this(new SesClientConfiguration());
    }

    public SesClient(SesClientConfiguration config) {
        super(config, SES_HANDLERS);
    }

    public void verifyEmail(String emailAddress) {
        this.assertStringNotNullOrEmpty(emailAddress, "object emailAddress should not be null or empty");
        this.verifyEmail(new VerifyEmailRequest().withEmailAddress(emailAddress));
    }

    public void verifyEmail(VerifyEmailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getEmailAddress(), "object emailAddress should not be null or empty");
        InternalRequest internalRequest = this.createRequest("verifiedEmail", request, HttpMethodName.PUT, request.getEmailAddress());
        this.invokeHttpClient(internalRequest, SesResponse.class);
    }

    public ListVerifiedEmailResponse listVerifiedEmail() {
        return this.listVerifiedEmail(new SesRequest());
    }

    public ListVerifiedEmailResponse listVerifiedEmail(SesRequest request) {
        InternalRequest internalRequest = this.createRequest("verifiedEmail", request, HttpMethodName.GET, new String[0]);
        return this.invokeHttpClient(internalRequest, ListVerifiedEmailResponse.class);
    }

    public GetVerifiedEmailResponse getVerifiedEmail(String emailAddress) {
        return this.getVerifiedEmail(new GetVerifiedEmailRequest().withEmailAddress(emailAddress));
    }

    public GetVerifiedEmailResponse getVerifiedEmail(GetVerifiedEmailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getEmailAddress(), "object emailAddress should not be null or empty");
        this.checkIsEmail(request.getEmailAddress());
        InternalRequest internalRequest = this.createRequest("verifiedEmail", request, HttpMethodName.GET, request.getEmailAddress());
        return this.invokeHttpClient(internalRequest, GetVerifiedEmailResponse.class);
    }

    public void deleteVerifiedEmail(String emailAddress) {
        this.deleteVerifiedEmail(new DeleteVerifiedEmailRequest().withEmailAddress(emailAddress));
    }

    public void deleteVerifiedEmail(DeleteVerifiedEmailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getEmailAddress(), "object emailAddress should not be null or empty");
        this.checkIsEmail(request.getEmailAddress());
        InternalRequest internalRequest = this.createRequest("verifiedEmail", request, HttpMethodName.DELETE, request.getEmailAddress());
        this.invokeHttpClient(internalRequest, SesResponse.class);
    }

    public VerifyDomainResponse verifyDomain(String domainName) {
        return this.verifyDomain(new VerifyDomainRequest().withDomainName(domainName));
    }

    public VerifyDomainResponse verifyDomain(VerifyDomainRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getDomainName(), "object domainName should not be null or empty");
        InternalRequest internalRequest = this.createRequest("verifiedDomain", request, HttpMethodName.PUT, request.getDomainName());
        return this.invokeHttpClient(internalRequest, VerifyDomainResponse.class);
    }

    public VerifyDKIMResponse verifyDKIM(String domainName) {
        return this.verifyDKIM(new VerifyDKIMRequest().withDomainName(domainName));
    }

    public VerifyDKIMResponse verifyDKIM(VerifyDKIMRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getDomainName(), "object domainName should not be null or empty");
        InternalRequest internalRequest = this.createRequest("verifiedDomain", request, HttpMethodName.PUT, request.getDomainName());
        internalRequest.addParameter("dkim", "true");
        return this.invokeHttpClient(internalRequest, VerifyDKIMResponse.class);
    }

    public void disableDKIM(String domainName) {
        this.disableDKIM(new EnableDKIMRequest().withDomainName(domainName));
    }

    public void disableDKIM(EnableDKIMRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getDomainName(), "object domainName should not be null or empty");
        InternalRequest internalRequest = this.createRequest("verifiedDomain", request, HttpMethodName.PUT, request.getDomainName());
        internalRequest.addParameter("enable", "disableDkim");
        this.invokeHttpClient(internalRequest, SesResponse.class);
    }

    public void enableDKIM(String domainName) {
        this.enableDKIM(new EnableDKIMRequest().withDomainName(domainName));
    }

    public void enableDKIM(EnableDKIMRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getDomainName(), "object domainName should not be null or empty");
        InternalRequest internalRequest = this.createRequest("verifiedDomain", request, HttpMethodName.PUT, request.getDomainName());
        internalRequest.addParameter("enable", "enableDkim");
        this.invokeHttpClient(internalRequest, SesResponse.class);
    }

    public ListVerifiedDomainResponse listVerifiedDomain() {
        return this.listVerifiedDomain(new SesRequest());
    }

    public ListVerifiedDomainResponse listVerifiedDomain(SesRequest request) {
        InternalRequest internalRequest = this.createRequest("verifiedDomain", request, HttpMethodName.GET, new String[0]);
        return this.invokeHttpClient(internalRequest, ListVerifiedDomainResponse.class);
    }

    public GetVerifiedDomainResponse getVerifiedDomain(String domainName) {
        return this.getVerifiedDomain(new GetVerifiedDomainRequest().withDomainName(domainName));
    }

    public GetVerifiedDomainResponse getVerifiedDomain(GetVerifiedDomainRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getDomainName(), "object domainName should not be null or empty");
        InternalRequest internalRequest = this.createRequest("verifiedDomain", request, HttpMethodName.GET, request.getDomainName());
        return this.invokeHttpClient(internalRequest, GetVerifiedDomainResponse.class);
    }

    public void deleteVerifiedDomain(String domainName) {
        this.deleteVerifiedDomain(new DeleteVerifiedDomainRequest().withDomainName(domainName));
    }

    public void deleteVerifiedDomain(DeleteVerifiedDomainRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getDomainName(), "object domainName should not be null or empty");
        InternalRequest internalRequest = this.createRequest("verifiedDomain", request, HttpMethodName.DELETE, request.getDomainName());
        this.invokeHttpClient(internalRequest, SesResponse.class);
    }

    public SendEmailResponse sendEmail(String from, String[] toAddr, String subject, String body, File ... attachmentFiles) {
        return this.sendEmail(from, "", toAddr, subject, body, attachmentFiles);
    }

    public SendEmailResponse sendEmail(String from, String displayName, String[] toAddr, String subject, String body, File ... attachmentFiles) {
        SendEmailRequest request = this.buildSendEmailRequest(from, from, from, toAddr, new String[]{""}, new String[]{""}, subject, body, 1, 1);
        request = this.fillDisplayName(request, displayName);
        request = this.fillAttachment(request, attachmentFiles);
        return this.sendEmail(request);
    }

    public SendEmailResponse sendEmail(String from, String displayName, String[] toAddr, String[] ccAddr, String[] bccAddr, String subject, String body, File ... attachmentFiles) {
        SendEmailRequest request = this.buildSendEmailRequest(from, from, from, toAddr, ccAddr, bccAddr, subject, body, 1, 1);
        request = this.fillDisplayName(request, displayName);
        request = this.fillAttachment(request, attachmentFiles);
        return this.sendEmail(request);
    }

    public SendEmailResponse sendEmail(String from, String displayName, String returnPath, String replyTo, String[] toAddr, String[] ccAddr, String[] bccAddr, String subject, String body, int priority, int charset, File ... attachmentFiles) {
        SendEmailRequest request = this.buildSendEmailRequest(from, returnPath, replyTo, toAddr, ccAddr, bccAddr, subject, body, priority, charset);
        request = this.fillDisplayName(request, displayName);
        request = this.fillAttachment(request, attachmentFiles);
        return this.sendEmail(request);
    }

    public SendEmailResponse sendEmail(SendEmailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        Preconditions.checkNotNull((Object)request.getMail(), (Object)"object mail of request should not be null.");
        Preconditions.checkNotNull((Object)request.getMail().getSource(), (Object)"object source of request should not be null.");
        this.assertStringNotNullOrEmpty(request.getMail().getSource().getFrom(), "from should not be null or empty.");
        this.checkIsEmail(request.getMail().getSource().getFrom());
        Preconditions.checkNotNull((Object)request.getMail().getSubject(), (Object)"object subject of request should not be null.");
        this.assertStringNotNullOrEmpty(request.getMail().getSubject().getData(), "subject should not be null or empty.");
        if (request.getMail().getSubject().getCharset() != null && !Arrays.asList(0, 1, 2, 3, 4).contains(request.getMail().getSubject().getCharset())) {
            throw new IllegalArgumentException("illegal charset.");
        }
        Preconditions.checkNotNull((Object)request.getMail().getMessage(), (Object)"object message of request should not be null.");
        Preconditions.checkNotNull((Object)request.getMail().getMessage().getHtml(), (Object)"object html of request should not be null.");
        this.assertStringNotNullOrEmpty(request.getMail().getMessage().getHtml().getData(), "body should not be null or empty.");
        if (request.getMail().getMessage().getHtml().getCharset() != null && !Arrays.asList(0, 1, 2, 3, 4).contains(request.getMail().getMessage().getHtml().getCharset())) {
            throw new IllegalArgumentException("illegal charset.");
        }
        if (request.getMail().getPriority() != null && (request.getMail().getPriority() <= -1 || request.getMail().getPriority() >= 100)) {
            throw new IllegalArgumentException("illegal priority.");
        }
        Preconditions.checkNotNull((Object)request.getMail().getDestination(), (Object)"object destination of request should not be null.");
        this.assertListNotNullOrEmpty(request.getMail().getDestination().getToAddr(), "toAddr should not be null or empty.");
        for (SendEmailRequest.Mail.Destination.Addr toAddr : request.getMail().getDestination().getToAddr()) {
            Preconditions.checkNotNull((Object)toAddr, (Object)"object toAddr of request should not be null.");
            this.checkIsEmail(toAddr.getAddr());
        }
        InternalRequest internalRequest = this.createRequest("email", request, HttpMethodName.POST, new String[0]);
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        return this.invokeHttpClient(internalRequest, SendEmailResponse.class);
    }

    public void setFeedback(SetFeedbackRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        if (request.getEmail() != null && request.getEmail().trim().length() > 0) {
            this.checkIsEmail(request.getEmail());
        }
        if (request.getType() == null) {
            request.setType(1);
        }
        if (!Arrays.asList(1, 2, 3).contains(request.getType())) {
            throw new IllegalArgumentException("illegal type.");
        }
        InternalRequest internalRequest = this.createRequest("feedback", request, HttpMethodName.PUT, new String[0]);
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        this.invokeHttpClient(internalRequest, SesResponse.class);
    }

    public GetFeedbackResponse getFeedback() {
        return this.getFeedback(new SesRequest());
    }

    public GetFeedbackResponse getFeedback(SesRequest request) {
        InternalRequest internalRequest = this.createRequest("feedback", request, HttpMethodName.GET, new String[0]);
        return this.invokeHttpClient(internalRequest, GetFeedbackResponse.class);
    }

    public GetQuotaResponse getQuota() {
        return this.getQuota(new SesRequest());
    }

    public GetQuotaResponse getQuota(SesRequest request) {
        InternalRequest internalRequest = this.createRequest("quota", request, HttpMethodName.GET, new String[0]);
        return this.invokeHttpClient(internalRequest, GetQuotaResponse.class);
    }

    public void setQuota(SetQuotaRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.checkIsInteger(request.getMaxPerDay());
        this.checkIsInteger(request.getMaxPerSecond());
        InternalRequest internalRequest = this.createRequest("quota", request, HttpMethodName.PUT, new String[0]);
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        this.invokeHttpClient(internalRequest, SesResponse.class);
    }

    public ListRecipientBlacklistResponse listRecipientBlacklist() {
        return this.listRecipientBlacklist(new SesRequest());
    }

    public ListRecipientBlacklistResponse listRecipientBlacklist(SesRequest request) {
        InternalRequest internalRequest = this.createRequest("recipientBlacklist", request, HttpMethodName.GET, new String[0]);
        return this.invokeHttpClient(internalRequest, ListRecipientBlacklistResponse.class);
    }

    public IsInRecipientBlacklistResponse isInRecipientBlacklist(String emailAddress) {
        return this.isInRecipientBlacklist(new IsInRecipientBlacklistRequest().withEmailAddress(emailAddress));
    }

    public IsInRecipientBlacklistResponse isInRecipientBlacklist(IsInRecipientBlacklistRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getEmailAddress(), "object emailAddress should not be null or empty");
        InternalRequest internalRequest = this.createRequest("recipientBlacklist", request, HttpMethodName.GET, request.getEmailAddress());
        return this.invokeHttpClient(internalRequest, IsInRecipientBlacklistResponse.class);
    }

    public GetFailedReasonResponse getFailedReason() {
        return this.getFailedReason(new SesRequest());
    }

    public GetFailedReasonResponse getFailedReason(SesRequest request) {
        InternalRequest internalRequest = this.createRequest("failedReason", request, HttpMethodName.GET, new String[0]);
        return this.invokeHttpClient(internalRequest, GetFailedReasonResponse.class);
    }

    private SendEmailRequest fillAttachment(SendEmailRequest request, File ... attachmentFiles) {
        if (attachmentFiles != null && attachmentFiles.length > 0) {
            for (File file : attachmentFiles) {
                try {
                    FileInputStream in = new FileInputStream(file);
                    String filedata = "";
                    try {
                        filedata = this.getBASE64EncoderStrFromInputStream(in);
                    }
                    catch (IOException e) {
                        this.logger.error("fetch attachment filedata failure.", (Throwable)e);
                        throw new BceClientException("fetch attachment filedata failure.", e);
                    }
                    request = this.fillAttachment(request, file.getName(), filedata);
                }
                catch (FileNotFoundException e) {
                    this.logger.error("attachment not found.", (Throwable)e);
                    throw new BceClientException("attachment not found.", e);
                }
            }
        }
        return request;
    }

    private SendEmailRequest fillAttachment(SendEmailRequest request, String filename, String filedata) {
        SendEmailRequest.Mail mail = request.getMail();
        SendEmailRequest.Mail.Attachment attachment = new SendEmailRequest.Mail.Attachment();
        attachment.setFiledata(new SendEmailRequest.Mail.Attachment.FileData().withData(filedata));
        attachment.setFilename(filename);
        List<SendEmailRequest.Mail.Attachment> attachments = mail.getAttachments();
        if (attachments == null) {
            attachments = new ArrayList<SendEmailRequest.Mail.Attachment>();
        }
        attachments.add(attachment);
        mail.setAttachments(attachments);
        return request;
    }

    private SendEmailRequest buildSendEmailRequest(String from, String returnPath, String replyTo, String[] toAddr, String[] ccAddr, String[] bccAddr, String subject, String body, int priority, int charset) {
        SendEmailRequest.Mail.Source source = new SendEmailRequest.Mail.Source(from, returnPath, replyTo);
        SendEmailRequest.Mail.Destination destination = new SendEmailRequest.Mail.Destination(SendEmailRequest.Mail.Destination.Addr.asAddrList(toAddr), SendEmailRequest.Mail.Destination.Addr.asAddrList(ccAddr), SendEmailRequest.Mail.Destination.Addr.asAddrList(bccAddr));
        SendEmailRequest.Mail.Message message = new SendEmailRequest.Mail.Message().withHtml(new SendEmailRequest.Mail.Subject().withData(body).withCharset(charset));
        SendEmailRequest.Mail mail = new SendEmailRequest.Mail(source, destination, new SendEmailRequest.Mail.Subject().withData(subject).withCharset(charset), priority, message);
        SendEmailRequest request = new SendEmailRequest();
        request.setMail(mail);
        return request;
    }

    private SendEmailRequest fillDisplayName(SendEmailRequest request, String displayName) {
        if (request != null && request.getMail() != null && request.getMail().getSource() != null) {
            request.getMail().getSource().setDisplayName(displayName);
        }
        return request;
    }
}

