/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.moladb.model.AttributeValue;
import com.baidubce.services.moladb.model.Key;
import com.baidubce.util.JsonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryRequest
extends AbstractBceRequest {
    private boolean consistentRead = false;
    private String tableName;
    private int limit = 0;
    private List<String> attributesToGet;
    private Key exclusiveStartKey;
    private String keyConditionExpression;
    private Map<String, AttributeValue> expressionAttributeValues;
    private String order = "Asc";

    public QueryRequest() {
    }

    public QueryRequest(String tableName) {
        this.tableName = tableName;
    }

    public String getKeyConditionExpression() {
        return this.keyConditionExpression;
    }

    public void setKeyConditionExpression(String expression) {
        this.keyConditionExpression = expression;
    }

    public QueryRequest withKeyConditionExpression(String expression) {
        this.setKeyConditionExpression(expression);
        return this;
    }

    public Map<String, AttributeValue> getExpressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public void setExpressionAttributeValues(Map<String, AttributeValue> attributes) {
        this.expressionAttributeValues = attributes;
    }

    public QueryRequest withExpressionAttributeValues(Map<String, AttributeValue> attributes) {
        this.setExpressionAttributeValues(attributes);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public QueryRequest withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setConsistentRead(boolean consistent) {
        this.consistentRead = consistent;
    }

    public QueryRequest withConsistentRead(boolean consistent) {
        this.setConsistentRead(consistent);
        return this;
    }

    public boolean isConsistentRead() {
        return this.consistentRead;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public QueryRequest withOrder(String order) {
        this.setOrder(order);
        return this;
    }

    public String getOrder() {
        return this.order;
    }

    public QueryRequest orderByDesc() {
        this.order = "Desc";
        return this;
    }

    public QueryRequest orderByAsc() {
        this.order = "Asc";
        return this;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public QueryRequest withLimit(int limit) {
        this.setLimit(limit);
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public List<String> getAttributesToGet() {
        return this.attributesToGet;
    }

    public void setAttributesToGet(List<String> attributes) {
        this.attributesToGet = attributes;
    }

    public QueryRequest withAttributesToGet(List<String> attributes) {
        this.setAttributesToGet(attributes);
        return this;
    }

    public void setExclusiveStartKey(Key exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey;
    }

    public QueryRequest withExclusiveStartKey(Key exclusiveStartKey) {
        this.setExclusiveStartKey(exclusiveStartKey);
        return this;
    }

    public Key getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public String toString() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("tableName", this.tableName);
        if (!this.attributesToGet.isEmpty()) {
            jsonObj.put("attributesToGet", this.attributesToGet);
        }
        if (null != this.exclusiveStartKey) {
            jsonObj.put("exclusiveStartKey", this.exclusiveStartKey.toJsonObj());
        }
        if (this.consistentRead) {
            jsonObj.put("consistentRead", "true");
        }
        if (this.limit > 0) {
            jsonObj.put("limit", Integer.toString(this.limit));
        }
        jsonObj.put("keyConditionExpression", this.keyConditionExpression);
        jsonObj.put("expressionAttributeValues", this.attributeValueToJson(this.expressionAttributeValues));
        jsonObj.put("order", this.order);
        return JsonUtils.toJsonString(jsonObj);
    }

    @Override
    public QueryRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    private Map<String, Object> attributeValueToJson(Map<String, AttributeValue> attributes) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        for (Map.Entry<String, AttributeValue> entry : attributes.entrySet()) {
            obj.put(entry.getKey(), entry.getValue().toJsonObj());
        }
        return obj;
    }
}

