/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model;

import com.baidubce.services.moladb.model.Key;
import com.baidubce.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class KeysAndAttributes {
    private List<String> attributesToGet;
    private List<Key> keys;
    private boolean consistentRead = false;

    public KeysAndAttributes withKeys(List<Key> keys) {
        this.setKeys(keys);
        return this;
    }

    public void setKeys(List<Key> keys) {
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("Keys to get is empty");
        }
        this.keys = keys;
    }

    public void setConsistentRead(boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public KeysAndAttributes withConsistentRead(boolean consistentRead) {
        this.setConsistentRead(consistentRead);
        return this;
    }

    public KeysAndAttributes withAttributesToGet(List<String> attributes) {
        this.setAttributesToGet(attributes);
        return this;
    }

    public void setAttributesToGet(List<String> attributes) {
        this.attributesToGet = attributes;
    }

    protected Map<String, Object> toJsonObj() {
        HashMap<String, Object> rootObj = new HashMap<String, Object>();
        if (this.attributesToGet != null && !this.attributesToGet.isEmpty()) {
            rootObj.put("attributesToGet", this.attributesToGet);
        }
        if (this.consistentRead) {
            rootObj.put("consistentRead", "true");
        }
        ArrayList<Map<String, Object>> keyList = new ArrayList<Map<String, Object>>();
        Iterator<Key> iter = this.keys.iterator();
        while (iter.hasNext()) {
            keyList.add(iter.next().toJsonObj());
        }
        rootObj.put("keys", keyList);
        return rootObj;
    }

    public boolean isConsistentRead() {
        return this.consistentRead;
    }

    public List<String> getAttributesToGet() {
        return this.attributesToGet;
    }

    public List<Key> getKeys() {
        return this.keys;
    }

    public String toString() {
        return JsonUtils.toJsonString(this.toJsonObj());
    }
}

