/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotdmp.model.device.evs;

import com.baidubce.model.GenericAccountRequest;
import com.baidubce.services.iotdmp.model.device.evs.EvsDeviceGbConfig;
import com.baidubce.services.iotdmp.model.device.evs.EvsDeviceRecordingConfig;
import com.baidubce.services.iotdmp.model.device.evs.EvsDeviceThumbnailConfig;
import com.baidubce.services.iotdmp.model.device.evs.EvsSpaceType;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AddEvsDeviceRequest
extends GenericAccountRequest {
    private Long spaceId;
    private String deviceName;
    @NonNull
    private EvsSpaceType type;
    private String deviceStreamId;
    private String description;
    private EvsDeviceGbConfig gbConfig;
    private EvsDeviceRecordingConfig recording;
    private EvsDeviceThumbnailConfig thumbnail;

    public void setBucket(String bucket) {
        if (this.recording != null && !this.recording.getSameAsSpace().booleanValue() && this.recording.getEnabled().booleanValue()) {
            this.recording.setBucket(bucket);
        }
        if (this.thumbnail != null && !this.thumbnail.getSameAsSpace().booleanValue() && this.thumbnail.getEnabled().booleanValue()) {
            this.thumbnail.setBucket(bucket);
        }
    }

    public static AddEvsDeviceRequestBuilder builder() {
        return new AddEvsDeviceRequestBuilder();
    }

    public Long getSpaceId() {
        return this.spaceId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    @NonNull
    public EvsSpaceType getType() {
        return this.type;
    }

    public String getDeviceStreamId() {
        return this.deviceStreamId;
    }

    public String getDescription() {
        return this.description;
    }

    public EvsDeviceGbConfig getGbConfig() {
        return this.gbConfig;
    }

    public EvsDeviceRecordingConfig getRecording() {
        return this.recording;
    }

    public EvsDeviceThumbnailConfig getThumbnail() {
        return this.thumbnail;
    }

    public void setSpaceId(Long spaceId) {
        this.spaceId = spaceId;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setType(@NonNull EvsSpaceType type) {
        if (type == null) {
            throw new NullPointerException("type is marked @NonNull but is null");
        }
        this.type = type;
    }

    public void setDeviceStreamId(String deviceStreamId) {
        this.deviceStreamId = deviceStreamId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setGbConfig(EvsDeviceGbConfig gbConfig) {
        this.gbConfig = gbConfig;
    }

    public void setRecording(EvsDeviceRecordingConfig recording) {
        this.recording = recording;
    }

    public void setThumbnail(EvsDeviceThumbnailConfig thumbnail) {
        this.thumbnail = thumbnail;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddEvsDeviceRequest)) {
            return false;
        }
        AddEvsDeviceRequest other = (AddEvsDeviceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$spaceId = this.getSpaceId();
        Long other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !((Object)this$spaceId).equals(other$spaceId)) {
            return false;
        }
        String this$deviceName = this.getDeviceName();
        String other$deviceName = other.getDeviceName();
        if (this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName)) {
            return false;
        }
        EvsSpaceType this$type = this.getType();
        EvsSpaceType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$deviceStreamId = this.getDeviceStreamId();
        String other$deviceStreamId = other.getDeviceStreamId();
        if (this$deviceStreamId == null ? other$deviceStreamId != null : !this$deviceStreamId.equals(other$deviceStreamId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        EvsDeviceGbConfig this$gbConfig = this.getGbConfig();
        EvsDeviceGbConfig other$gbConfig = other.getGbConfig();
        if (this$gbConfig == null ? other$gbConfig != null : !((Object)this$gbConfig).equals(other$gbConfig)) {
            return false;
        }
        EvsDeviceRecordingConfig this$recording = this.getRecording();
        EvsDeviceRecordingConfig other$recording = other.getRecording();
        if (this$recording == null ? other$recording != null : !((Object)this$recording).equals(other$recording)) {
            return false;
        }
        EvsDeviceThumbnailConfig this$thumbnail = this.getThumbnail();
        EvsDeviceThumbnailConfig other$thumbnail = other.getThumbnail();
        return !(this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddEvsDeviceRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : ((Object)$spaceId).hashCode());
        String $deviceName = this.getDeviceName();
        result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
        EvsSpaceType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $deviceStreamId = this.getDeviceStreamId();
        result = result * 59 + ($deviceStreamId == null ? 43 : $deviceStreamId.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        EvsDeviceGbConfig $gbConfig = this.getGbConfig();
        result = result * 59 + ($gbConfig == null ? 43 : ((Object)$gbConfig).hashCode());
        EvsDeviceRecordingConfig $recording = this.getRecording();
        result = result * 59 + ($recording == null ? 43 : ((Object)$recording).hashCode());
        EvsDeviceThumbnailConfig $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        return result;
    }

    public String toString() {
        return "AddEvsDeviceRequest(spaceId=" + this.getSpaceId() + ", deviceName=" + this.getDeviceName() + ", type=" + (Object)((Object)this.getType()) + ", deviceStreamId=" + this.getDeviceStreamId() + ", description=" + this.getDescription() + ", gbConfig=" + this.getGbConfig() + ", recording=" + this.getRecording() + ", thumbnail=" + this.getThumbnail() + ")";
    }

    public AddEvsDeviceRequest(Long spaceId, String deviceName, @NonNull EvsSpaceType type, String deviceStreamId, String description, EvsDeviceGbConfig gbConfig, EvsDeviceRecordingConfig recording, EvsDeviceThumbnailConfig thumbnail) {
        if (type == null) {
            throw new NullPointerException("type is marked @NonNull but is null");
        }
        this.spaceId = spaceId;
        this.deviceName = deviceName;
        this.type = type;
        this.deviceStreamId = deviceStreamId;
        this.description = description;
        this.gbConfig = gbConfig;
        this.recording = recording;
        this.thumbnail = thumbnail;
    }

    public AddEvsDeviceRequest(@NonNull EvsSpaceType type) {
        if (type == null) {
            throw new NullPointerException("type is marked @NonNull but is null");
        }
        this.type = type;
    }

    public static class AddEvsDeviceRequestBuilder {
        private Long spaceId;
        private String deviceName;
        private EvsSpaceType type;
        private String deviceStreamId;
        private String description;
        private EvsDeviceGbConfig gbConfig;
        private EvsDeviceRecordingConfig recording;
        private EvsDeviceThumbnailConfig thumbnail;

        AddEvsDeviceRequestBuilder() {
        }

        public AddEvsDeviceRequestBuilder spaceId(Long spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public AddEvsDeviceRequestBuilder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public AddEvsDeviceRequestBuilder type(EvsSpaceType type) {
            this.type = type;
            return this;
        }

        public AddEvsDeviceRequestBuilder deviceStreamId(String deviceStreamId) {
            this.deviceStreamId = deviceStreamId;
            return this;
        }

        public AddEvsDeviceRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AddEvsDeviceRequestBuilder gbConfig(EvsDeviceGbConfig gbConfig) {
            this.gbConfig = gbConfig;
            return this;
        }

        public AddEvsDeviceRequestBuilder recording(EvsDeviceRecordingConfig recording) {
            this.recording = recording;
            return this;
        }

        public AddEvsDeviceRequestBuilder thumbnail(EvsDeviceThumbnailConfig thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public AddEvsDeviceRequest build() {
            return new AddEvsDeviceRequest(this.spaceId, this.deviceName, this.type, this.deviceStreamId, this.description, this.gbConfig, this.recording, this.thumbnail);
        }

        public String toString() {
            return "AddEvsDeviceRequest.AddEvsDeviceRequestBuilder(spaceId=" + this.spaceId + ", deviceName=" + this.deviceName + ", type=" + (Object)((Object)this.type) + ", deviceStreamId=" + this.deviceStreamId + ", description=" + this.description + ", gbConfig=" + this.gbConfig + ", recording=" + this.recording + ", thumbnail=" + this.thumbnail + ")";
        }
    }
}

