/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cdn.model.util;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeFormatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TimeFormatUtil.class);
    private static final String FORMAT = "yyyy-MM-dd'T'HH:mm:SS'Z'";

    public static String formatToStr(long timestamp, String format, boolean isSecond) {
        long ts = 0L;
        ts = isSecond ? timestamp * 1000L : timestamp;
        DateTime dateTime = new DateTime(ts);
        String result = null;
        try {
            format = format == null ? FORMAT : format;
            result = dateTime.toString(format);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
        }
        return result;
    }

    public static long formatToTs(String timeStr, String format, boolean isSecond) {
        long ret = 0L;
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
        DateTime dt = DateTime.parse((String)timeStr, (DateTimeFormatter)formatter);
        long ts = dt.getMillis();
        ret = isSecond ? ts / 1000L : ts;
        return ret;
    }

    public static String formatTimeStr(String timeStr, String inputFormat, String outputFormat) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)inputFormat);
        DateTime dt = DateTime.parse((String)timeStr, (DateTimeFormatter)formatter);
        long ts = dt.getMillis();
        DateTime dateTime = new DateTime(ts);
        String result = null;
        try {
            result = dateTime.toString(outputFormat);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
        }
        return result;
    }
}

