/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.State;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class StorageManager {
    public static final int BUFFER_SIZE = 8192;
    public static SaveListener saveListener;

    public void setSaveListener(SaveListener saveListener) {
        StorageManager.saveListener = saveListener;
    }

    public static State saveBinaryFile(byte[] data, String path) {
        if (saveListener != null) {
            return saveListener.save(data, path.substring(path.lastIndexOf("/") + 1));
        }
        File file = new File(path);
        State state = StorageManager.valid(file);
        if (!state.isSuccess()) {
            return state;
        }
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            bos.write(data);
            bos.flush();
            bos.close();
        }
        catch (IOException ioe) {
            return new BaseState(false, 4);
        }
        state = new BaseState(true, file.getAbsolutePath());
        state.putInfo("size", data.length);
        state.putInfo("title", file.getName());
        return state;
    }

    public static State saveFileByInputStream(InputStream is, String path, long maxSize) {
        State state = null;
        File tmpFile = StorageManager.getTmpFile();
        byte[] dataBuf = new byte[2048];
        BufferedInputStream bis = new BufferedInputStream(is, 8192);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
            int count = 0;
            while ((count = bis.read(dataBuf)) != -1) {
                bos.write(dataBuf, 0, count);
            }
            bos.flush();
            bos.close();
            if (tmpFile.length() > maxSize) {
                tmpFile.delete();
                return new BaseState(false, 1);
            }
            if (saveListener != null) {
                byte[] bs = StorageManager.File2byte(tmpFile);
                tmpFile.delete();
                return saveListener.save(bs, path.substring(path.lastIndexOf("/") + 1));
            }
            state = StorageManager.saveTmpFile(tmpFile, path);
            if (!state.isSuccess()) {
                tmpFile.delete();
            }
            return state;
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
    }

    public static State saveFileByInputStream(InputStream is, String path) {
        State state = null;
        Object physicsPath = null;
        File tmpFile = StorageManager.getTmpFile();
        byte[] dataBuf = new byte[2048];
        BufferedInputStream bis = new BufferedInputStream(is, 8192);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
            int count = 0;
            while ((count = bis.read(dataBuf)) != -1) {
                bos.write(dataBuf, 0, count);
            }
            bos.flush();
            bos.close();
            if (saveListener != null) {
                byte[] bs = StorageManager.File2byte(tmpFile);
                tmpFile.delete();
                return saveListener.save(bs, path.substring(path.lastIndexOf("/") + 1));
            }
            state = StorageManager.saveTmpFile(tmpFile, path);
            if (!state.isSuccess()) {
                tmpFile.delete();
            }
            return state;
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
    }

    private static File getTmpFile() {
        File tmpDir = FileUtils.getTempDirectory();
        String tmpFileName = (Math.random() * 10000.0 + "").replace(".", "");
        return new File(tmpDir, tmpFileName);
    }

    private static State saveTmpFile(File tmpFile, String path) {
        BaseState state = null;
        File targetFile = new File(path);
        if (targetFile.canWrite()) {
            return new BaseState(false, 2);
        }
        try {
            FileUtils.moveFile((File)tmpFile, (File)targetFile);
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
        state = new BaseState(true);
        state.putInfo("size", targetFile.length());
        state.putInfo("title", targetFile.getName());
        return state;
    }

    private static State valid(File file) {
        File parentPath = file.getParentFile();
        if (!parentPath.exists() && !parentPath.mkdirs()) {
            return new BaseState(false, 3);
        }
        if (!parentPath.canWrite()) {
            return new BaseState(false, 2);
        }
        return new BaseState(true);
    }

    private static byte[] File2byte(File file) {
        byte[] buffer = null;
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static interface SaveListener {
        public State save(byte[] var1, String var2);
    }
}

