/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.code;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.code.AbstractCodeGenerator;
import com.baidu.bjf.remoting.protobuf.code.CodedConstant;
import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import com.baidu.bjf.remoting.protobuf.utils.FieldInfo;
import com.baidu.bjf.remoting.protobuf.utils.MiniTemplator;
import com.baidu.bjf.remoting.protobuf.utils.StringBuilderWriter;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateCodeGenerator
extends AbstractCodeGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TemplateCodeGenerator.class.getCanonicalName());
    private static final String TEMPLATE_FILE = "/jprotobuf_classes_template.tpl";
    private Set<Class<?>> relativeProxyClasses = new HashSet();
    private MiniTemplator templator;
    public static final String DEFAULT_SUFFIX_CLASSNAME = "$$JProtoBufClass";

    public TemplateCodeGenerator(Class<?> cls) {
        super(cls);
        InputStream templateFile = cls.getResourceAsStream(TEMPLATE_FILE);
        try {
            this.templator = new MiniTemplator(TEMPLATE_FILE, templateFile);
        }
        catch (MiniTemplator.TemplateSyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Template file locate failed. " + templateFile, e);
        }
    }

    @Override
    public String getClassName() {
        return ClassHelper.getClassName(this.cls) + DEFAULT_SUFFIX_CLASSNAME;
    }

    @Override
    public String getCode() {
        String pkg = this.getPackage();
        if (!StringUtils.isEmpty(pkg)) {
            pkg = "package " + pkg + ";";
        }
        this.templator.setVariable("package", pkg);
        this.genImportCode();
        String className = this.getClassName();
        this.templator.setVariable("className", className);
        this.templator.setVariable("codecClassName", Codec.class.getName());
        this.templator.setVariable("targetProxyClassName", this.getTargetProxyClassname());
        String descriptorClsName = ClassHelper.getInternalName(Descriptors.Descriptor.class.getCanonicalName());
        this.templator.setVariable("descriptorClsName", descriptorClsName);
        this.initEncodeMethodTemplateVariable();
        this.initDecodeMethodTemplateVariable();
        StringBuilderWriter writer = new StringBuilderWriter();
        try {
            this.templator.generateOutput(writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return writer.toString();
    }

    protected void initEncodeMethodTemplateVariable() {
        HashSet orders = new HashSet();
        for (FieldInfo field : this.fields) {
            boolean isList = field.isList();
            if (!isList) {
                this.checkType(field.getFieldType(), field.getField());
            }
            if (orders.contains(field.getOrder())) {
                throw new IllegalArgumentException("Field order '" + field.getOrder() + "' on field" + field.getField().getName() + " already exsit.");
            }
            FieldType fieldType = field.getFieldType();
            String accessByField = this.getAccessByField("t", field.getField(), this.cls);
            String fieldName = CodedConstant.getFieldName(field.getOrder());
            String encodeFieldType = CodedConstant.getFiledType(fieldType, isList);
            this.templator.setVariable("encodeFieldType", encodeFieldType);
            this.templator.setVariable("encodeFieldName", fieldName);
            this.templator.setVariable("encodeFieldGetter", accessByField);
            String writeValueToField = CodedConstant.getWriteValueToField(fieldType, accessByField, isList);
            this.templator.setVariable("writeValueToField", writeValueToField);
            if (field.isRequired()) {
                this.templator.setVariableOpt("checkNull", CodedConstant.getRequiredCheck(field.getOrder(), field.getField()));
            } else {
                this.templator.setVariable("checkNull", "");
            }
            String calcSize = CodedConstant.getMappedTypeSize(field, field.getOrder(), field.getFieldType(), isList, this.debug, this.outputPath);
            this.templator.setVariable("calcSize", calcSize);
            String encodeWriteFieldValue = CodedConstant.getMappedWriteCode(field, "output", field.getOrder(), field.getFieldType(), isList);
            this.templator.setVariable("encodeWriteFieldValue", encodeWriteFieldValue);
            this.templator.addBlock("encodeFields");
        }
    }

    protected void initDecodeMethodTemplateVariable() {
        String express;
        StringBuilder initListMapFields = new StringBuilder();
        for (FieldInfo field : this.fields) {
            boolean isList = field.isList();
            boolean isMap = field.isMap();
            String e = "";
            if (isList) {
                e = "new ArrayList()";
            } else if (isMap) {
                e = "new HashMap()";
            }
            if (isList || isMap) {
                initListMapFields.append(this.getSetToField("ret", field.getField(), this.cls, e, false, false)).append(";\n");
            }
            if (field.getFieldType() != FieldType.ENUM) continue;
            String clsName = ClassHelper.getInternalName(field.getField().getType().getCanonicalName());
            if (isList) continue;
            express = "CodedConstant.getEnumValue(" + clsName + ".class, " + clsName + ".values()[0].name())";
            String setToField = this.getSetToField("ret", field.getField(), this.cls, express, isList, field.isMap());
            this.templator.setVariable("enumInitialize", setToField);
            this.templator.addBlock("enumFields");
        }
        this.templator.setVariable("initListMapFields", initListMapFields.toString());
        StringBuilder code = new StringBuilder();
        for (FieldInfo field : this.fields) {
            String spath;
            String name;
            Class<?> cls;
            boolean isList = field.isList();
            String t = field.getFieldType().getType();
            t = CodedConstant.capitalize(t);
            boolean listTypeCheck = false;
            String objectDecodeExpress = "";
            String objectDecodeExpressSuffix = "";
            String decodeOrder = "-1";
            decodeOrder = field.getFieldType() != FieldType.DEFAULT ? CodedConstant.makeTag(field.getOrder(), field.getFieldType().getInternalFieldType().getWireType()) + "" : "CodedConstant.makeTag(" + field.getOrder() + ",WireFormat." + field.getFieldType().getWireFormat() + ")";
            this.templator.setVariable("decodeOrder", decodeOrder);
            if (field.getFieldType() == FieldType.ENUM) {
                String clsName = ClassHelper.getInternalName(field.getField().getType().getCanonicalName());
                if (isList && field.getGenericKeyType() != null) {
                    Class<?> cls2 = field.getGenericKeyType();
                    clsName = ClassHelper.getInternalName(cls2.getCanonicalName());
                }
                express = "CodedConstant.getEnumValue(" + clsName + ".class, CodedConstant.getEnumName(" + clsName + ".values(),input.read" + t + "()))";
            } else {
                express = "input.read" + t + "()";
            }
            if (isList && field.getFieldType() == FieldType.OBJECT) {
                if (field.getGenericKeyType() != null) {
                    cls = field.getGenericKeyType();
                    name = ClassHelper.getInternalName(cls.getCanonicalName());
                    code.append("codec = ProtobufProxy.create(").append(name).append(".class");
                    if (this.debug) {
                        code.append(", true");
                    } else {
                        code.append(", false");
                    }
                    spath = "ProtobufProxy.OUTPUT_PATH.get()";
                    code.append(",").append(spath);
                    code.append(")").append(";\n");
                    objectDecodeExpress = code.toString();
                    code.setLength(0);
                    objectDecodeExpress = objectDecodeExpress + "int length = input.readRawVarint32();\n";
                    objectDecodeExpress = objectDecodeExpress + "final int oldLimit = input.pushLimit(length);\n";
                    listTypeCheck = true;
                    express = "(" + name + ") codec.readFrom(input)";
                }
            } else if (field.getFieldType() == FieldType.OBJECT) {
                cls = field.getField().getType();
                name = ClassHelper.getInternalName(cls.getCanonicalName());
                code.append("codec = ProtobufProxy.create(").append(name).append(".class");
                if (this.debug) {
                    code.append(", true");
                } else {
                    code.append(", false");
                }
                spath = "ProtobufProxy.OUTPUT_PATH.get()";
                code.append(",").append(spath);
                code.append(")").append(";\n");
                objectDecodeExpress = code.toString();
                code.setLength(0);
                objectDecodeExpress = objectDecodeExpress + "int length = input.readRawVarint32();\n";
                objectDecodeExpress = objectDecodeExpress + "final int oldLimit = input.pushLimit(length);\n";
                listTypeCheck = true;
                express = "(" + name + ") codec.readFrom(input)";
            }
            if (field.getFieldType() == FieldType.BYTES) {
                express = express + ".toByteArray()";
            }
            String decodeFieldSetValue = this.getSetToField("ret", field.getField(), this.cls, express, isList, field.isMap()) + ";\n";
            if (listTypeCheck) {
                objectDecodeExpressSuffix = objectDecodeExpressSuffix + "input.checkLastTagWas(0);\n";
                objectDecodeExpressSuffix = objectDecodeExpressSuffix + "input.popLimit(oldLimit);\n";
            }
            if (field.isRequired()) {
                this.templator.setVariable("deocdeCheckNull", CodedConstant.getRetRequiredCheck(this.getAccessByField("ret", field.getField(), this.cls), field.getField()));
            } else {
                this.templator.setVariable("deocdeCheckNull", "");
            }
            this.templator.setVariable("objectDecodeExpress", objectDecodeExpress);
            this.templator.setVariable("objectDecodeExpressSuffix", objectDecodeExpressSuffix);
            this.templator.setVariable("decodeFieldSetValue", decodeFieldSetValue);
            this.templator.addBlock("decodeFields");
        }
    }

    private void genImportCode() {
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.util.*");
        imports.add("java.io.IOException");
        imports.add("java.lang.reflect.*");
        imports.add("com.baidu.bjf.remoting.protobuf.code.*");
        imports.add("com.baidu.bjf.remoting.protobuf.utils.*");
        imports.add("com.baidu.bjf.remoting.protobuf.*");
        imports.add("com.google.protobuf.*");
        if (!StringUtils.isEmpty(this.getPackage())) {
            imports.add(this.getTargetProxyClassname());
        }
        for (String pkg : imports) {
            this.templator.setVariable("importPackage", pkg);
            this.templator.addBlock("imports");
        }
    }

    @Override
    public Set<Class<?>> getRelativeProxyClasses() {
        return this.relativeProxyClasses;
    }

    protected String getSetToField(String target, Field field, Class<?> cls, String express, boolean isList, boolean isMap) {
        StringBuilder ret = new StringBuilder();
        if (isList || isMap) {
            ret.append("if ((").append(this.getAccessByField(target, field, cls)).append(") == null) {").append("\n");
        }
        if (Modifier.isPublic(field.getModifiers())) {
            if (isList) {
                ret.append(target).append(".").append(field.getName()).append("= new ArrayList()").append(";\n").append("}").append("\n");
                if (express != null) {
                    ret.append(target).append(".").append(field.getName()).append(".add(").append(express).append(")");
                }
                return ret.toString();
            }
            if (isMap) {
                ret.append(target).append(".").append(field.getName()).append("= new HashMap()").append(";\n").append("}").append("\n");
                return ret.append(express).toString();
            }
            return target + "." + field.getName() + "=" + express;
        }
        String setter = "set" + CodedConstant.capitalize(field.getName());
        try {
            cls.getMethod(setter, field.getType());
            if (isList) {
                ret.append("List __list = new ArrayList()").append(";\n");
                ret.append(target).append(".").append(setter).append("(__list)").append(";\n").append("}");
                if (express != null) {
                    ret.append("(").append(this.getAccessByField(target, field, cls)).append(").add(").append(express).append(")");
                }
                return ret.toString();
            }
            if (isMap) {
                ret.append("Map __map = new HashMap()").append(";\n");
                ret.append(target).append(".").append(setter).append("(__map)").append(";\n").append("}");
                return ret + express;
            }
            return target + "." + setter + "(" + express + ")\n";
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            if (isList) {
                ret.append("List __list = new ArrayList()").append(";\n");
                ret.append("FieldUtils.setField(").append(target).append(", \"").append(field.getName()).append("\", __list)").append(";\n").append("}");
                if (express != null) {
                    ret.append("(").append(this.getAccessByField(target, field, cls)).append(").add(").append(express).append(")");
                }
                return ret.toString();
            }
            if (isMap) {
                ret.append("Map __map = new HashMap()").append(";\n");
                ret.append("FieldUtils.setField(").append(target).append(", \"").append(field.getName()).append("\", __map)").append(";\n").append("}");
                return ret + express;
            }
            String code = "";
            if (express != null) {
                code = "FieldUtils.setField(" + target + ", \"" + field.getName() + "\", " + express + ")";
            }
            return code;
        }
    }
}

