/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.DataChangeDetectionPolicy;
import java.io.IOException;

public final class HighWaterMarkChangeDetectionPolicy
extends DataChangeDetectionPolicy {
    private String odataType = "#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy";
    private final String highWaterMarkColumnName;

    public HighWaterMarkChangeDetectionPolicy(String highWaterMarkColumnName) {
        this.highWaterMarkColumnName = highWaterMarkColumnName;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public String getHighWaterMarkColumnName() {
        return this.highWaterMarkColumnName;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("highWaterMarkColumnName", this.highWaterMarkColumnName);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static HighWaterMarkChangeDetectionPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (HighWaterMarkChangeDetectionPolicy)jsonReader.readObject(reader -> {
            boolean highWaterMarkColumnNameFound = false;
            String highWaterMarkColumnName = null;
            String odataType = "#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("highWaterMarkColumnName".equals(fieldName)) {
                    highWaterMarkColumnName = reader.getString();
                    highWaterMarkColumnNameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (highWaterMarkColumnNameFound) {
                HighWaterMarkChangeDetectionPolicy deserializedHighWaterMarkChangeDetectionPolicy = new HighWaterMarkChangeDetectionPolicy(highWaterMarkColumnName);
                deserializedHighWaterMarkChangeDetectionPolicy.odataType = odataType;
                return deserializedHighWaterMarkChangeDetectionPolicy;
            }
            throw new IllegalStateException("Missing required property: highWaterMarkColumnName");
        });
    }
}

