/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairts;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.tairts.factory.TsBuilderFactory;
import com.aliyun.tair.tairts.params.ExtsAggregationParams;
import com.aliyun.tair.tairts.params.ExtsAttributesParams;
import com.aliyun.tair.tairts.params.ExtsDataPoint;
import com.aliyun.tair.tairts.params.ExtsFilter;
import com.aliyun.tair.tairts.params.ExtsMaddParams;
import com.aliyun.tair.tairts.params.ExtsQueryParams;
import com.aliyun.tair.tairts.params.ExtsSpecifiedKeysParams;
import com.aliyun.tair.tairts.params.ExtsStringAggregationParams;
import com.aliyun.tair.tairts.params.ExtsStringDataPoint;
import com.aliyun.tair.tairts.params.ExtsStringMaddParams;
import com.aliyun.tair.tairts.results.ExtsDataPointResult;
import com.aliyun.tair.tairts.results.ExtsSkeyResult;
import com.aliyun.tair.tairts.results.ExtsStringDataPointResult;
import com.aliyun.tair.tairts.results.ExtsStringSkeyResult;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairTsCluster {
    private JedisCluster jc;

    public TairTsCluster(JedisCluster jc) {
        this.jc = jc;
    }

    public String extsadd(String pkey, String skey, String ts, double value) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSADD, new String[]{pkey, skey, ts, String.valueOf(value)});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsadd(byte[] pkey, byte[] skey, byte[] ts, double value) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSADD, (byte[][])new byte[][]{pkey, skey, ts, Protocol.toByteArray((double)value)});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsadd(String pkey, String skey, String ts, double value, ExtsAttributesParams params) {
        return this.extsadd(SafeEncoder.encode((String)pkey), SafeEncoder.encode((String)skey), SafeEncoder.encode((String)ts), value, params);
    }

    public String extsadd(byte[] pkey, byte[] skey, byte[] ts, double value, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSADD, params.getByteParams(pkey, skey, ts, Protocol.toByteArray((double)value)));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public List<String> extsmadd(String pkey, ArrayList<ExtsDataPoint<String>> skeys) {
        ExtsMaddParams addList = new ExtsMaddParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSMADD, addList.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmadd(byte[] pkey, ArrayList<ExtsDataPoint<byte[]>> skeys) {
        ExtsMaddParams addList = new ExtsMaddParams();
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSMADD, addList.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmadd(String pkey, ArrayList<ExtsDataPoint<String>> skeys, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSMADD, params.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmadd(byte[] pkey, ArrayList<ExtsDataPoint<byte[]>> skeys, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSMADD, params.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public String extsalter(String pkey, String skey, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSALTER, params.getByteParams(pkey, skey));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsalter(byte[] pkey, byte[] skey, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSALTER, params.getByteParams(pkey, skey));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsincr(String pkey, String skey, String ts, double value) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSINCRBY, new String[]{pkey, skey, ts, String.valueOf(value)});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsincr(byte[] pkey, byte[] skey, byte[] ts, double value) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSINCRBY, (byte[][])new byte[][]{pkey, skey, ts, Protocol.toByteArray((double)value)});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsincr(String pkey, String skey, String ts, double value, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSINCRBY, params.getByteParams(pkey, skey, ts, String.valueOf(value)));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsincr(byte[] pkey, byte[] skey, byte[] ts, double value, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSINCRBY, params.getByteParams(pkey, skey, ts, Protocol.toByteArray((double)value)));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public List<String> extsmincr(String pkey, ArrayList<ExtsDataPoint<String>> skeys) {
        ExtsMaddParams addList = new ExtsMaddParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSMINCRBY, addList.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmincr(byte[] pkey, ArrayList<ExtsDataPoint<byte[]>> skeys) {
        ExtsMaddParams addList = new ExtsMaddParams();
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSMINCRBY, addList.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmincr(String pkey, ArrayList<ExtsDataPoint<String>> skeys, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSMINCRBY, params.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmincr(byte[] pkey, ArrayList<ExtsDataPoint<byte[]>> skeys, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSMINCRBY, params.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public String extsdel(String pkey, String skey) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSDEL, new String[]{pkey, skey});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsdel(byte[] pkey, byte[] skey) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSDEL, (byte[][])new byte[][]{pkey, skey});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public ExtsDataPointResult extsget(String pkey, String skey) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSGET, new String[]{pkey, skey});
        return (ExtsDataPointResult)TsBuilderFactory.EXTSGET_RESULT_STRING.build(obj);
    }

    public ExtsDataPointResult extsget(byte[] pkey, byte[] skey) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSGET, (byte[][])new byte[][]{pkey, skey});
        return (ExtsDataPointResult)TsBuilderFactory.EXTSGET_RESULT_STRING.build(obj);
    }

    public List<String> extsquery(String pkey, ArrayList<ExtsFilter<String>> filters) {
        ExtsQueryParams addList = new ExtsQueryParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSQUERYINDEX, addList.getByteParams(pkey, filters));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> extsquery(byte[] pkey, ArrayList<ExtsFilter<byte[]>> filters) {
        ExtsQueryParams addList = new ExtsQueryParams();
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSQUERYINDEX, addList.getByteParams(pkey, filters));
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public ExtsSkeyResult extsrange(String pkey, String skey, String startTs, String endTs) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRANGE, new String[]{pkey, skey, startTs, endTs});
        return (ExtsSkeyResult)TsBuilderFactory.EXTSRANGE_RESULT_STRING.build(obj);
    }

    public ExtsSkeyResult extsrange(byte[] pkey, byte[] skey, byte[] startTs, byte[] endTs) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRANGE, (byte[][])new byte[][]{pkey, skey, startTs, endTs});
        return (ExtsSkeyResult)TsBuilderFactory.EXTSRANGE_RESULT_STRING.build(obj);
    }

    public ExtsSkeyResult extsrange(String pkey, String skey, String startTs, String endTs, ExtsAggregationParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSRANGE, params.getByteRangeParams(pkey, skey, startTs, endTs));
        return (ExtsSkeyResult)TsBuilderFactory.EXTSRANGE_RESULT_STRING.build(obj);
    }

    public ExtsSkeyResult extsrange(byte[] pkey, byte[] skey, byte[] startTs, byte[] endTs, ExtsAggregationParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRANGE, params.getByteRangeParams(pkey, skey, startTs, endTs));
        return (ExtsSkeyResult)TsBuilderFactory.EXTSRANGE_RESULT_STRING.build(obj);
    }

    public List<ExtsSkeyResult> extsmrange(String pkey, ArrayList<String> skeys, String startTs, String endTs) {
        ExtsSpecifiedKeysParams params = new ExtsSpecifiedKeysParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSRANGESPECIFIEDKEYS, params.getByteParams(pkey, skeys, startTs, endTs));
        return (List)TsBuilderFactory.EXTSMRANGE_RESULT_STRING.build(obj);
    }

    public List<ExtsSkeyResult> extsmrange(byte[] pkey, ArrayList<byte[]> skeys, byte[] startTs, byte[] endTs) {
        ExtsSpecifiedKeysParams params = new ExtsSpecifiedKeysParams();
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRANGESPECIFIEDKEYS, params.getByteParams(pkey, skeys, startTs, endTs));
        return (List)TsBuilderFactory.EXTSMRANGE_RESULT_STRING.build(obj);
    }

    public List<ExtsSkeyResult> extsmrange(String pkey, ArrayList<String> skeys, String startTs, String endTs, ExtsAggregationParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSRANGESPECIFIEDKEYS, params.getByteRangeParams(pkey, skeys, startTs, endTs));
        return (List)TsBuilderFactory.EXTSMRANGE_RESULT_STRING.build(obj);
    }

    public List<ExtsSkeyResult> extsmrange(byte[] pkey, ArrayList<byte[]> skeys, byte[] startTs, byte[] endTs, ExtsAggregationParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRANGESPECIFIEDKEYS, params.getByteRangeParams(pkey, skeys, startTs, endTs));
        return (List)TsBuilderFactory.EXTSMRANGE_RESULT_STRING.build(obj);
    }

    public List<ExtsSkeyResult> extsmrange(String pkey, String startTs, String endTs, ArrayList<ExtsFilter<String>> filters) {
        ExtsAggregationParams params = new ExtsAggregationParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSMRANGE, params.getByteMrangeParams(pkey, startTs, endTs, filters));
        return (List)TsBuilderFactory.EXTSMRANGE_RESULT_STRING.build(obj);
    }

    public List<ExtsSkeyResult> extsmrange(byte[] pkey, byte[] startTs, byte[] endTs, ArrayList<ExtsFilter<byte[]>> filters) {
        ExtsAggregationParams params = new ExtsAggregationParams();
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSMRANGE, params.getByteMrangeParams(pkey, startTs, endTs, filters));
        return (List)TsBuilderFactory.EXTSMRANGE_RESULT_STRING.build(obj);
    }

    public List<ExtsSkeyResult> extsmrange(String pkey, String startTs, String endTs, ExtsAggregationParams params, ArrayList<ExtsFilter<String>> filters) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSMRANGE, params.getByteMrangeParams(pkey, startTs, endTs, filters));
        return (List)TsBuilderFactory.EXTSMRANGE_RESULT_STRING.build(obj);
    }

    public List<ExtsSkeyResult> extsmrange(byte[] pkey, byte[] startTs, byte[] endTs, ExtsAggregationParams params, ArrayList<ExtsFilter<byte[]>> filters) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSMRANGE, params.getByteMrangeParams(pkey, startTs, endTs, filters));
        return (List)TsBuilderFactory.EXTSMRANGE_RESULT_STRING.build(obj);
    }

    public ExtsSkeyResult extsprange(String pkey, String startTs, String endTs, String pkeyAggregationType, long pkeyTimeBucket, ArrayList<ExtsFilter<String>> filters) {
        ExtsAggregationParams params = new ExtsAggregationParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSPRANGE, params.getBytePrangeParams(pkey, startTs, endTs, pkeyAggregationType, pkeyTimeBucket, filters));
        return (ExtsSkeyResult)TsBuilderFactory.EXTSRANGE_RESULT_STRING.build(obj);
    }

    public ExtsSkeyResult extsprange(byte[] pkey, byte[] startTs, byte[] endTs, byte[] pkeyAggregationType, long pkeyTimeBucket, ArrayList<ExtsFilter<byte[]>> filters) {
        ExtsAggregationParams params = new ExtsAggregationParams();
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSPRANGE, params.getBytePrangeParams(pkey, startTs, endTs, pkeyAggregationType, pkeyTimeBucket, filters));
        return (ExtsSkeyResult)TsBuilderFactory.EXTSRANGE_RESULT_STRING.build(obj);
    }

    public ExtsSkeyResult extsprange(String pkey, String startTs, String endTs, String pkeyAggregationType, long pkeyTimeBucket, ExtsAggregationParams params, ArrayList<ExtsFilter<String>> filters) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSPRANGE, params.getBytePrangeParams(pkey, startTs, endTs, pkeyAggregationType, pkeyTimeBucket, filters));
        return (ExtsSkeyResult)TsBuilderFactory.EXTSRANGE_RESULT_STRING.build(obj);
    }

    public ExtsSkeyResult extsprange(byte[] pkey, byte[] startTs, byte[] endTs, byte[] pkeyAggregationType, long pkeyTimeBucket, ExtsAggregationParams params, ArrayList<ExtsFilter<byte[]>> filters) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSPRANGE, params.getBytePrangeParams(pkey, startTs, endTs, pkeyAggregationType, pkeyTimeBucket, filters));
        return (ExtsSkeyResult)TsBuilderFactory.EXTSRANGE_RESULT_STRING.build(obj);
    }

    public String extsrawmodify(String pkey, String skey, String ts, double value) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRAWMODIFY, new String[]{pkey, skey, ts, String.valueOf(value)});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsrawmodify(byte[] pkey, byte[] skey, byte[] ts, double value) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRAWMODIFY, (byte[][])new byte[][]{pkey, skey, ts, Protocol.toByteArray((double)value)});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsrawmodify(String pkey, String skey, String ts, double value, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSRAWMODIFY, params.getByteParams(pkey, skey, ts, String.valueOf(value)));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsrawmodify(byte[] pkey, byte[] skey, byte[] ts, double value, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRAWMODIFY, params.getByteParams(pkey, skey, ts, Protocol.toByteArray((double)value)));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public List<String> extsmrawmodify(String pkey, ArrayList<ExtsDataPoint<String>> skeys) {
        ExtsMaddParams addList = new ExtsMaddParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSRAWMULTIMODIFY, addList.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmrawmodify(byte[] pkey, ArrayList<ExtsDataPoint<byte[]>> skeys) {
        ExtsMaddParams addList = new ExtsMaddParams();
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRAWMULTIMODIFY, addList.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmrawmodify(String pkey, ArrayList<ExtsDataPoint<String>> skeys, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSRAWMULTIMODIFY, params.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmrawmodify(byte[] pkey, ArrayList<ExtsDataPoint<byte[]>> skeys, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRAWMULTIMODIFY, params.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public String extsrawincr(String pkey, String skey, String ts, double value) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRAWINCRBY, new String[]{pkey, skey, ts, String.valueOf(value)});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsrawincr(byte[] pkey, byte[] skey, byte[] ts, double value) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRAWINCRBY, (byte[][])new byte[][]{pkey, skey, ts, Protocol.toByteArray((double)value)});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsrawincr(String pkey, String skey, String ts, double value, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSRAWINCRBY, params.getByteParams(pkey, skey, ts, String.valueOf(value)));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsrawincr(byte[] pkey, byte[] skey, byte[] ts, double value, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRAWINCRBY, params.getByteParams(pkey, skey, ts, Protocol.toByteArray((double)value)));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public List<String> extsmrawincr(String pkey, ArrayList<ExtsDataPoint<String>> skeys) {
        ExtsMaddParams addList = new ExtsMaddParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSRAWMULTIINCRBY, addList.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmrawincr(byte[] pkey, ArrayList<ExtsDataPoint<byte[]>> skeys) {
        ExtsMaddParams addList = new ExtsMaddParams();
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRAWMULTIINCRBY, addList.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmrawincr(String pkey, ArrayList<ExtsDataPoint<String>> skeys, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSRAWMULTIINCRBY, params.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmrawincr(byte[] pkey, ArrayList<ExtsDataPoint<byte[]>> skeys, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRAWMULTIINCRBY, params.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public String extsaddstr(String pkey, String skey, String ts, String value) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSADDSTR, new String[]{pkey, skey, ts, value});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsaddstr(byte[] pkey, byte[] skey, byte[] ts, byte[] value) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSADDSTR, (byte[][])new byte[][]{pkey, skey, ts, value});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsaddstr(String pkey, String skey, String ts, String value, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSADDSTR, params.getByteParams(pkey, skey, ts, value));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsaddstr(byte[] pkey, byte[] skey, byte[] ts, byte[] value, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSADDSTR, params.getByteParams(pkey, skey, ts, value));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public List<String> extsmaddstr(String pkey, ArrayList<ExtsStringDataPoint<String>> skeys) {
        ExtsStringMaddParams addList = new ExtsStringMaddParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSMADDSTR, addList.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmaddstr(byte[] pkey, ArrayList<ExtsStringDataPoint<byte[]>> skeys) {
        ExtsStringMaddParams addList = new ExtsStringMaddParams();
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSMADDSTR, addList.getByteParams(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmaddstr(String pkey, ArrayList<ExtsStringDataPoint<String>> skeys, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSMADDSTR, params.getByteParamsStr(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> extsmaddstr(byte[] pkey, ArrayList<ExtsStringDataPoint<byte[]>> skeys, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSMADDSTR, params.getByteParamsStr(pkey, skeys));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public String extsalterstr(String pkey, String skey, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSALTERSTR, params.getByteParams(pkey, skey));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsalterstr(byte[] pkey, byte[] skey, ExtsAttributesParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSALTERSTR, params.getByteParams(pkey, skey));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsdelstr(String pkey, String skey) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSDELSTR, new String[]{pkey, skey});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String extsdelstr(byte[] pkey, byte[] skey) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSDELSTR, (byte[][])new byte[][]{pkey, skey});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public ExtsStringDataPointResult extsgetstr(String pkey, String skey) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSGETSTR, new String[]{pkey, skey});
        return (ExtsStringDataPointResult)TsBuilderFactory.EXTSSTRING_GET_RESULT_STRING.build(obj);
    }

    public ExtsStringDataPointResult extsgetstr(byte[] pkey, byte[] skey) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSGETSTR, (byte[][])new byte[][]{pkey, skey});
        return (ExtsStringDataPointResult)TsBuilderFactory.EXTSSTRING_GET_RESULT_STRING.build(obj);
    }

    public List<String> extsquerystr(String pkey, ArrayList<ExtsFilter<String>> filters) {
        ExtsQueryParams addList = new ExtsQueryParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSQUERYINDEXSTR, addList.getByteParams(pkey, filters));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> extsquerystr(byte[] pkey, ArrayList<ExtsFilter<byte[]>> filters) {
        ExtsQueryParams addList = new ExtsQueryParams();
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSQUERYINDEXSTR, addList.getByteParams(pkey, filters));
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public ExtsStringSkeyResult extsrangestr(String pkey, String skey, String startTs, String endTs) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRANGESTR, new String[]{pkey, skey, startTs, endTs});
        return (ExtsStringSkeyResult)TsBuilderFactory.EXTSSTRING_RANGE_RESULT_STRING.build(obj);
    }

    public ExtsStringSkeyResult extsrangestr(byte[] pkey, byte[] skey, byte[] startTs, byte[] endTs) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRANGESTR, (byte[][])new byte[][]{pkey, skey, startTs, endTs});
        return (ExtsStringSkeyResult)TsBuilderFactory.EXTSSTRING_RANGE_RESULT_STRING.build(obj);
    }

    public ExtsStringSkeyResult extsrangestr(String pkey, String skey, String startTs, String endTs, ExtsStringAggregationParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSRANGESTR, params.getByteRangeParams(pkey, skey, startTs, endTs));
        return (ExtsStringSkeyResult)TsBuilderFactory.EXTSSTRING_RANGE_RESULT_STRING.build(obj);
    }

    public ExtsStringSkeyResult extsrangestr(byte[] pkey, byte[] skey, byte[] startTs, byte[] endTs, ExtsStringAggregationParams params) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSRANGESTR, params.getByteRangeParams(pkey, skey, startTs, endTs));
        return (ExtsStringSkeyResult)TsBuilderFactory.EXTSSTRING_RANGE_RESULT_STRING.build(obj);
    }

    public List<ExtsStringSkeyResult> extsmrangestr(String pkey, String startTs, String endTs, ArrayList<ExtsFilter<String>> filters) {
        ExtsStringAggregationParams params = new ExtsStringAggregationParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSMRANGESTR, params.getByteMrangeParams(pkey, startTs, endTs, filters));
        return (List)TsBuilderFactory.EXTSSTRING_MRANGE_RESULT_STRING.build(obj);
    }

    public List<ExtsStringSkeyResult> extsmrangestr(byte[] pkey, byte[] startTs, byte[] endTs, ArrayList<ExtsFilter<byte[]>> filters) {
        ExtsStringAggregationParams params = new ExtsStringAggregationParams();
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSMRANGESTR, params.getByteMrangeParams(pkey, startTs, endTs, filters));
        return (List)TsBuilderFactory.EXTSSTRING_MRANGE_RESULT_STRING.build(obj);
    }

    public List<ExtsStringSkeyResult> extsmrangestr(String pkey, String startTs, String endTs, ExtsStringAggregationParams params, ArrayList<ExtsFilter<String>> filters) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)pkey), (ProtocolCommand)ModuleCommand.TSSMRANGESTR, params.getByteMrangeParams(pkey, startTs, endTs, filters));
        return (List)TsBuilderFactory.EXTSSTRING_MRANGE_RESULT_STRING.build(obj);
    }

    public List<ExtsStringSkeyResult> extsmrangestr(byte[] pkey, byte[] startTs, byte[] endTs, ExtsStringAggregationParams params, ArrayList<ExtsFilter<byte[]>> filters) {
        Object obj = this.jc.sendCommand(pkey, (ProtocolCommand)ModuleCommand.TSSMRANGESTR, params.getByteMrangeParams(pkey, startTs, endTs, filters));
        return (List)TsBuilderFactory.EXTSSTRING_MRANGE_RESULT_STRING.build(obj);
    }
}

