/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.builder;

import com.aliyun.tair.tairsearch.common.Nullable;
import com.aliyun.tair.tairsearch.index.query.QueryBuilder;
import com.aliyun.tair.tairsearch.search.aggregations.AggregationBuilder;
import com.aliyun.tair.tairsearch.search.aggregations.AggregatorFactories;
import com.aliyun.tair.tairsearch.search.fetch.subphase.FetchSourceContext;
import com.aliyun.tair.tairsearch.search.sort.SortBuilder;
import com.aliyun.tair.tairsearch.search.sort.SortBuilders;
import com.aliyun.tair.tairsearch.search.sort.SortOrder;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseSearchSourceBuilder<SSB extends BaseSearchSourceBuilder<SSB>> {
    public static final String SIZE_FIELD = "size";
    public static final String QUERY_FIELD = "query";
    public static final String SOURCE_FIELD = "_source";
    public static final String TRACK_TOTAL_HITS_FIELD = "track_total_hits";
    public static final String AGGREGATIONS_FIELD = "aggregations";
    public static final String AGGS_FIELD = "aggs";
    public static final String SORT_FIELD = "sort";
    protected QueryBuilder queryBuilder;
    protected int size = -1;
    protected boolean trackTotalHits = false;
    protected FetchSourceContext fetchSourceContext;
    protected List<SortBuilder<?>> sorts;
    protected AggregatorFactories.Builder aggregations;

    public SSB query(QueryBuilder query) {
        this.queryBuilder = query;
        return (SSB)this;
    }

    public QueryBuilder query() {
        return this.queryBuilder;
    }

    public SSB trackTotalHits(boolean trackTotalHits) {
        this.trackTotalHits = trackTotalHits;
        return (SSB)this;
    }

    public boolean trackTotalHits() {
        return this.trackTotalHits;
    }

    public SSB size(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("[size] parameter cannot be negative, found [" + size + "]");
        }
        this.size = size;
        return (SSB)this;
    }

    public int size() {
        return this.size;
    }

    public SSB fetchSource(boolean fetch) {
        FetchSourceContext fetchSourceContext = this.fetchSourceContext != null ? this.fetchSourceContext : FetchSourceContext.FETCH_SOURCE;
        this.fetchSourceContext = new FetchSourceContext(fetch, fetchSourceContext.includes(), fetchSourceContext.excludes());
        return (SSB)this;
    }

    public SSB fetchSource(@Nullable String include, @Nullable String exclude) {
        String[] stringArray;
        String[] stringArray2;
        if (include == null) {
            stringArray2 = FetchSourceContext.EMPTY_ARRAY;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = include;
        }
        if (exclude == null) {
            stringArray = FetchSourceContext.EMPTY_ARRAY;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = exclude;
        }
        return this.fetchSource(stringArray2, stringArray);
    }

    public SSB fetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        FetchSourceContext fetchSourceContext = this.fetchSourceContext != null ? this.fetchSourceContext : FetchSourceContext.FETCH_SOURCE;
        this.fetchSourceContext = new FetchSourceContext(fetchSourceContext.fetchSource(), includes, excludes);
        return (SSB)this;
    }

    public SSB fetchSource(@Nullable FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return (SSB)this;
    }

    public FetchSourceContext fetchSource() {
        return this.fetchSourceContext;
    }

    public SSB sort(String name, SortOrder order) {
        if (name.equals("_score")) {
            return this.sort((SortBuilder<?>)SortBuilders.scoreSort().order(order));
        }
        return this.sort((SortBuilder<?>)SortBuilders.fieldSort(name).order(order));
    }

    public SSB sort(String name) {
        if (name.equals("_score")) {
            return this.sort(SortBuilders.scoreSort());
        }
        return this.sort(SortBuilders.fieldSort(name));
    }

    public SSB sort(SortBuilder<?> sort) {
        if (this.sorts == null) {
            this.sorts = new ArrayList();
        }
        this.sorts.add(sort);
        return (SSB)this;
    }

    public List<SortBuilder<?>> sorts() {
        return this.sorts;
    }

    public SSB aggregation(AggregationBuilder aggregation) {
        if (this.aggregations == null) {
            this.aggregations = AggregatorFactories.builder();
        }
        this.aggregations.addAggregator(aggregation);
        return (SSB)this;
    }

    public AggregatorFactories.Builder aggregations() {
        return this.aggregations;
    }

    public abstract JsonObject constructJSON();

    public String toString() {
        return this.constructJSON().toString();
    }
}

