/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search;

import com.aliyun.tair.tairsearch.common.Nullable;
import com.aliyun.tair.tairsearch.search.SearchHit;
import com.aliyun.tair.tairsearch.search.TotalHits;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Objects;

public class SearchHits {
    public static final String HITS = "hits";
    public static final String TOTAL = "total";
    public static final String MAX_SCORE = "max_score";
    private final JsonObject searchHits;
    private final SearchHit[] hits;
    private final TotalHits totalHits;
    private float maxScore = 0.0f;

    public SearchHits(JsonObject in) {
        this.searchHits = in;
        JsonArray hitsJSON = in.getAsJsonArray(HITS);
        this.hits = new SearchHit[hitsJSON.size()];
        for (int i = 0; i < hitsJSON.size(); ++i) {
            this.hits[i] = new SearchHit(hitsJSON.get(i).getAsJsonObject());
        }
        this.totalHits = new TotalHits(in.getAsJsonObject(TOTAL));
        if (!in.get(MAX_SCORE).isJsonNull()) {
            this.maxScore = in.get(MAX_SCORE).getAsFloat();
        }
    }

    @Nullable
    public TotalHits getTotalHits() {
        return this.totalHits;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    public SearchHit[] getHits() {
        return this.hits;
    }

    public SearchHit getAt(int position) {
        return this.hits[position];
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchHits other = (SearchHits)obj;
        return Objects.equals(this.totalHits, other.totalHits) && Objects.equals(Float.valueOf(this.maxScore), Float.valueOf(other.maxScore)) && Arrays.equals(this.hits, other.hits);
    }

    public int hashCode() {
        return Objects.hash(this.totalHits, Float.valueOf(this.maxScore), Arrays.hashCode(this.hits));
    }

    public String toString() {
        return this.searchHits.toString();
    }
}

