/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SearchHit {
    public static final String ID = "_id";
    public static final String INDEX = "_index";
    public static final String SCORE = "_score";
    public static final String SOURCE = "_source";
    private final JsonObject searchHit;
    private final String id;
    private final float score;
    private final String index;
    private final JsonObject source;
    private Map<String, Object> sourceAsMap;

    public SearchHit(JsonObject in) {
        this.searchHit = in;
        this.id = in.get(ID).getAsString();
        this.index = in.get(INDEX).getAsString();
        this.score = in.get(SCORE).getAsFloat();
        this.source = in.get(SOURCE).getAsJsonObject();
    }

    public String getIndex() {
        return this.index;
    }

    public String getId() {
        return this.id;
    }

    public float getScore() {
        return this.score;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getSourceAsString() {
        if (this.source.size() == 0) {
            return null;
        }
        return this.source.toString();
    }

    public Map<String, Object> getSourceAsMap() {
        if (this.source.size() == 0) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = this.getJsonObjectAsMap(this.source);
        return this.sourceAsMap;
    }

    private Map<String, Object> getJsonObjectAsMap(JsonObject json) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : json.entrySet()) {
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonPrimitive()) {
                JsonPrimitive v = (JsonPrimitive)value;
                if (v.isString()) {
                    result.put((String)entry.getKey(), value.getAsString());
                    continue;
                }
                if (v.isNumber()) {
                    result.put((String)entry.getKey(), value.getAsNumber());
                    continue;
                }
                if (v.isBoolean()) {
                    result.put((String)entry.getKey(), value.getAsBoolean());
                    continue;
                }
                result.put((String)entry.getKey(), null);
                continue;
            }
            if (!value.isJsonObject()) continue;
            result.put((String)entry.getKey(), this.getJsonObjectAsMap(value.getAsJsonObject()));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchHit other = (SearchHit)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.source, other.source) && Objects.equals(this.index, other.index);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.index);
    }

    public String toString() {
        return this.searchHit.toString();
    }
}

