/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.index.query;

import com.aliyun.tair.tairsearch.index.query.AbstractQueryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TermsQueryBuilder
extends AbstractQueryBuilder<TermsQueryBuilder> {
    public static final String NAME = "terms";
    public static final String LOWERCASE_FIELD = "lowercase";
    protected final String fieldName;
    protected List<Object> values;
    protected boolean lowercase = true;

    public TermsQueryBuilder(String fieldName, String ... values) {
        this(fieldName, values != null ? Arrays.asList(values) : null);
    }

    public TermsQueryBuilder(String fieldName, int ... values) {
        this(fieldName, values != null ? (Iterable)Arrays.stream(values).mapToObj(s -> s).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, long ... values) {
        this(fieldName, values != null ? (Iterable)Arrays.stream(values).mapToObj(s -> s).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, float ... values) {
        this(fieldName, values != null ? (Iterable)IntStream.range(0, values.length).mapToObj(i -> Float.valueOf(values[i])).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, double ... values) {
        this(fieldName, values != null ? (Iterable)Arrays.stream(values).mapToObj(s -> s).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, Object ... values) {
        this(fieldName, values != null ? Arrays.asList(values) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, Iterable<?> values) {
        if (fieldName == null || fieldName.length() == 0) {
            throw new IllegalArgumentException("field name cannot be null.");
        }
        if (values == null) {
            throw new IllegalArgumentException("No value specified for terms query");
        }
        this.fieldName = fieldName;
        if (values instanceof List) {
            this.values = (List)values;
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object o : values) {
                arrayList.add(o);
            }
            this.values = arrayList;
        }
    }

    public String fieldName() {
        return this.fieldName;
    }

    public List<Object> values() {
        return this.values;
    }

    public TermsQueryBuilder lowercase(boolean lowercase) {
        this.lowercase = lowercase;
        return this;
    }

    public boolean lowercase() {
        return this.lowercase;
    }

    @Override
    public JsonObject constructJSON() {
        JsonObject valueObject = new JsonObject();
        JsonArray valuesArray = new JsonArray(this.values.size());
        for (Object value : this.values) {
            valuesArray.add(new Gson().toJsonTree(value));
        }
        valueObject.add(this.fieldName, (JsonElement)valuesArray);
        valueObject.addProperty("boost", (Number)Float.valueOf(this.boost));
        if (!this.lowercase) {
            valueObject.addProperty(LOWERCASE_FIELD, Boolean.valueOf(this.lowercase));
        }
        JsonObject queryObject = new JsonObject();
        queryObject.add(NAME, (JsonElement)valueObject);
        return queryObject;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.values, this.lowercase);
    }

    @Override
    protected boolean doEquals(TermsQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.values, other.values) && Objects.equals(this.lowercase, other.lowercase);
    }
}

