/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairhash;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.jedis3.ScanParams;
import com.aliyun.tair.jedis3.ScanResult;
import com.aliyun.tair.tairhash.factory.HashBuilderFactory;
import com.aliyun.tair.tairhash.params.ExhgetwithverResult;
import com.aliyun.tair.tairhash.params.ExhincrByFloatParams;
import com.aliyun.tair.tairhash.params.ExhincrByParams;
import com.aliyun.tair.tairhash.params.ExhmsetwithoptsParams;
import com.aliyun.tair.tairhash.params.ExhsetParams;
import com.aliyun.tair.util.JoinParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairHashCluster {
    private JedisCluster jc;

    public TairHashCluster(JedisCluster jc) {
        this.jc = jc;
    }

    public Long exhset(String key, String field, String value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHSET, new String[]{key, field, value});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exhset(byte[] key, byte[] field, byte[] value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHSET, (byte[][])new byte[][]{key, field, value});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exhset(String key, String field, String value, ExhsetParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXHSET, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), SafeEncoder.encode((String)value)));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exhset(byte[] key, byte[] field, byte[] value, ExhsetParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHSET, params.getByteParams(key, field, value));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exhsetnx(String key, String field, String value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHSETNX, new String[]{key, field, value});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exhsetnx(byte[] key, byte[] field, byte[] value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHSETNX, (byte[][])new byte[][]{key, field, value});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public String exhmset(String key, Map<String, String> hash) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(hash.size());
        for (Map.Entry<String, String> entry : hash.entrySet()) {
            bhash.put(SafeEncoder.encode((String)entry.getKey()), SafeEncoder.encode((String)entry.getValue()));
        }
        return this.exhmset(SafeEncoder.encode((String)key), bhash);
    }

    public String exhmset(byte[] key, Map<byte[], byte[]> hash) {
        ArrayList<byte[]> params = new ArrayList<byte[]>();
        params.add(key);
        for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHMSET, (byte[][])params.toArray((T[])new byte[params.size()][]));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String exhmsetwithopts(String key, List<ExhmsetwithoptsParams<String>> params) {
        ArrayList<ExhmsetwithoptsParams<byte[]>> bexhash = new ArrayList<ExhmsetwithoptsParams<byte[]>>();
        for (ExhmsetwithoptsParams<String> entry : params) {
            bexhash.add(new ExhmsetwithoptsParams<byte[]>(SafeEncoder.encode((String)entry.getField()), SafeEncoder.encode((String)entry.getValue()), entry.getVer(), entry.getExp()));
        }
        return this.exhmsetwithopts(SafeEncoder.encode((String)key), bexhash);
    }

    public String exhmsetwithopts(byte[] key, List<ExhmsetwithoptsParams<byte[]>> params) {
        ArrayList<byte[]> p = new ArrayList<byte[]>();
        p.add(key);
        for (ExhmsetwithoptsParams<byte[]> entry : params) {
            p.add(entry.getField());
            p.add(entry.getValue());
            p.add(Protocol.toByteArray((long)entry.getVer()));
            p.add(Protocol.toByteArray((long)entry.getExp()));
        }
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHMSETWITHOPTS, (byte[][])p.toArray((T[])new byte[params.size()][]));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public Boolean exhpexpire(String key, String field, int milliseconds) {
        return this.exhpexpire(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), milliseconds);
    }

    public Boolean exhpexpire(String key, String field, int milliseconds, boolean noactive) {
        return this.exhpexpire(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), milliseconds, noactive);
    }

    public Boolean exhpexpire(byte[] key, byte[] field, int milliseconds) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHPEXPIRE, (byte[][])new byte[][]{key, field, Protocol.toByteArray((int)milliseconds)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean exhpexpire(byte[] key, byte[] field, int milliseconds, boolean noactive) {
        Object obj = noactive ? this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHPEXPIRE, (byte[][])new byte[][]{key, field, Protocol.toByteArray((int)milliseconds), SafeEncoder.encode((String)"noactive")}) : this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHPEXPIRE, (byte[][])new byte[][]{key, field, Protocol.toByteArray((int)milliseconds)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean exhpexpireAt(String key, String field, long unixTime) {
        return this.exhpexpireAt(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), unixTime);
    }

    public Boolean exhpexpireAt(String key, String field, long unixTime, boolean noactive) {
        return this.exhpexpireAt(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), unixTime, noactive);
    }

    public Boolean exhpexpireAt(byte[] key, byte[] field, long unixTime) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHPEXPIREAT, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)unixTime)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean exhpexpireAt(byte[] key, byte[] field, long unixTime, boolean noactive) {
        Object obj = noactive ? this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHPEXPIREAT, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)unixTime), SafeEncoder.encode((String)"noactive")}) : this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHPEXPIREAT, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)unixTime)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean exhexpire(String key, String field, int seconds, boolean noactive) {
        return this.exhexpire(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), seconds, noactive);
    }

    public Boolean exhexpire(String key, String field, int seconds) {
        return this.exhexpire(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), seconds);
    }

    public Boolean exhexpire(byte[] key, byte[] field, int seconds) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHEXPIRE, (byte[][])new byte[][]{key, field, Protocol.toByteArray((int)seconds)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean exhexpire(byte[] key, byte[] field, int seconds, boolean noactive) {
        Object obj = noactive ? this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHEXPIRE, (byte[][])new byte[][]{key, field, Protocol.toByteArray((int)seconds), SafeEncoder.encode((String)"noactive")}) : this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHEXPIRE, (byte[][])new byte[][]{key, field, Protocol.toByteArray((int)seconds)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean exhexpireAt(String key, String field, long unixTime) {
        return this.exhexpireAt(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), unixTime);
    }

    public Boolean exhexpireAt(String key, String field, long unixTime, boolean noactive) {
        return this.exhexpireAt(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), unixTime, noactive);
    }

    public Boolean exhexpireAt(byte[] key, byte[] field, long unixTime) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHEXPIREAT, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)unixTime)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean exhexpireAt(byte[] key, byte[] field, long unixTime, boolean noactive) {
        Object obj = noactive ? this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHEXPIREAT, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)unixTime), SafeEncoder.encode((String)"noactive")}) : this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHEXPIREAT, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)unixTime)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Long exhpttl(String key, String field) {
        return this.exhpttl(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    public Long exhpttl(byte[] key, byte[] field) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHPTTL, (byte[][])new byte[][]{key, field});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exhttl(String key, String field) {
        return this.exhttl(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    public Long exhttl(byte[] key, byte[] field) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHTTL, (byte[][])new byte[][]{key, field});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exhver(String key, String field) {
        return this.exhver(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    public Long exhver(byte[] key, byte[] field) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHVER, (byte[][])new byte[][]{key, field});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Boolean exhsetver(String key, String field, long version) {
        return this.exhsetver(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), version);
    }

    public Boolean exhsetver(byte[] key, byte[] field, long version) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHSETVER, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)version)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Long exhincrBy(String key, String field, long value) {
        return this.exhincrBy(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value);
    }

    public Long exhincrBy(byte[] key, byte[] field, long value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHINCRBY, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)value)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exhincrBy(String key, String field, long value, ExhincrByParams params) {
        return this.exhincrBy(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value, params);
    }

    public Long exhincrBy(byte[] key, byte[] field, long value, ExhincrByParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHINCRBY, params.getByteParams(key, field, Protocol.toByteArray((long)value)));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Double exhincrByFloat(String key, String field, double value) {
        return this.exhincrByFloat(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value);
    }

    public Double exhincrByFloat(byte[] key, byte[] field, double value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHINCRBYFLOAT, (byte[][])new byte[][]{key, field, Protocol.toByteArray((double)value)});
        return (Double)BuilderFactory.DOUBLE.build(obj);
    }

    public Double exhincrByFloat(String key, String field, double value, ExhincrByFloatParams params) {
        return this.exhincrByFloat(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value, params);
    }

    public Double exhincrByFloat(byte[] key, byte[] field, double value, ExhincrByFloatParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHINCRBYFLOAT, params.getByteParams(key, field, Protocol.toByteArray((double)value)));
        return (Double)BuilderFactory.DOUBLE.build(obj);
    }

    public String exhget(String key, String field) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHGET, new String[]{key, field});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public byte[] exhget(byte[] key, byte[] field) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHGET, (byte[][])new byte[][]{key, field});
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public ExhgetwithverResult<String> exhgetwithver(String key, String field) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHGETWITHVER, new String[]{key, field});
        return (ExhgetwithverResult)HashBuilderFactory.EXHGETWITHVER_RESULT_STRING.build(obj);
    }

    public ExhgetwithverResult<byte[]> exhgetwithver(byte[] key, byte[] field) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHGETWITHVER, (byte[][])new byte[][]{key, field});
        return (ExhgetwithverResult)HashBuilderFactory.EXHGETWITHVER_RESULT_BYTE.build(obj);
    }

    public List<String> exhmget(String key, String ... fields) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXHMGET, JoinParameters.joinParameters(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])fields)));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exhmget(byte[] key, byte[] ... fields) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHMGET, JoinParameters.joinParameters(key, fields));
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<ExhgetwithverResult<String>> exhmgetwithver(String key, String ... fields) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXHMGETWITHVER, JoinParameters.joinParameters(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])fields)));
        return (List)HashBuilderFactory.EXHMGETWITHVER_RESULT_STRING_LIST.build(obj);
    }

    public List<ExhgetwithverResult<byte[]>> exhmgetwithver(byte[] key, byte[] ... fields) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHMGETWITHVER, JoinParameters.joinParameters(key, fields));
        return (List)HashBuilderFactory.EXHMGETWITHVER_RESULT_BYTE_LIST.build(obj);
    }

    public Long exhdel(String key, String ... fields) {
        return this.exhdel(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])fields));
    }

    public Long exhdel(byte[] key, byte[] ... fields) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHDEL, JoinParameters.joinParameters(key, fields));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exhlen(String key) {
        return this.exhlen(SafeEncoder.encode((String)key));
    }

    public Long exhlen(String key, boolean noexp) {
        return this.exhlen(SafeEncoder.encode((String)key), noexp);
    }

    public Long exhlen(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHLEN, (byte[][])new byte[][]{key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exhlen(byte[] key, boolean noexp) {
        Object obj = noexp ? this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHLEN, (byte[][])new byte[][]{key, SafeEncoder.encode((String)"noexp")}) : this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHLEN, (byte[][])new byte[][]{key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Boolean exhexists(String key, String field) {
        return this.exhexists(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    public Boolean exhexists(byte[] key, byte[] field) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHEXISTS, (byte[][])new byte[][]{key, field});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Long exhstrlen(String key, String field) {
        return this.exhstrlen(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    public Long exhstrlen(byte[] key, byte[] field) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHSTRLEN, (byte[][])new byte[][]{key, field});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Set<String> exhkeys(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHKEYS, new String[]{key});
        return (Set)Jedis3BuilderFactory.STRING_ZSET.build(obj);
    }

    public Set<byte[]> exhkeys(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHKEYS, (byte[][])new byte[][]{key});
        return (Set)Jedis3BuilderFactory.BYTE_ARRAY_ZSET.build(obj);
    }

    public List<String> exhvals(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHVALS, new String[]{key});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exhvals(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHVALS, (byte[][])new byte[][]{key});
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public Map<String, String> exhgetAll(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHGETALL, new String[]{key});
        return (Map)BuilderFactory.STRING_MAP.build(obj);
    }

    public Map<byte[], byte[]> exhgetAll(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHGETALL, (byte[][])new byte[][]{key});
        return (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build(obj);
    }

    public ScanResult<Map.Entry<String, String>> exhscan(String key, String op, String subkey) {
        return this.exhscan(key, op, subkey, new ScanParams());
    }

    public ScanResult<Map.Entry<String, String>> exhscan(String key, String op, String subkey, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)op));
        args.add(SafeEncoder.encode((String)subkey));
        args.addAll(params.getParams());
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXHSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (ScanResult)HashBuilderFactory.EXHSCAN_RESULT_STRING.build(obj);
    }

    public ScanResult<Map.Entry<byte[], byte[]>> exhscan(byte[] key, byte[] op, byte[] subkey) {
        return this.exhscan(key, op, subkey, new ScanParams());
    }

    public ScanResult<Map.Entry<byte[], byte[]>> exhscan(byte[] key, byte[] op, byte[] subkey, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(op);
        args.add(subkey);
        args.addAll(params.getParams());
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (ScanResult)HashBuilderFactory.EXHSCAN_RESULT_BYTE.build(obj);
    }

    public ScanResult<Map.Entry<String, String>> exhscanunorder(String key, String cursor) {
        return this.exhscanunorder(key, cursor, new ScanParams());
    }

    public ScanResult<Map.Entry<byte[], byte[]>> exhscanunorder(byte[] key, byte[] cursor) {
        return this.exhscanunorder(key, cursor, new ScanParams());
    }

    public ScanResult<Map.Entry<String, String>> exhscanunorder(String key, String cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)cursor));
        args.addAll(params.getParams());
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXHSCANUNORDER, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (ScanResult)HashBuilderFactory.EXHSCAN_RESULT_STRING.build(obj);
    }

    public ScanResult<Map.Entry<byte[], byte[]>> exhscanunorder(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXHSCANUNORDER, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (ScanResult)HashBuilderFactory.EXHSCAN_RESULT_BYTE.build(obj);
    }
}

