/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairgis.factory;

import com.aliyun.tair.tairgis.params.GisSearchResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.util.SafeEncoder;

public class GisBuilderFactory {
    public static final Builder<Map<String, String>> GISSEARCH_RESULT_MAP_STRING = new Builder<Map<String, String>>(){

        public Map<String, String> build(Object data) {
            List rawResults;
            List result = (List)data;
            if (null == result || 0 == result.size()) {
                return new HashMap<String, String>();
            }
            List flatHash = rawResults = (List)result.get(1);
            HashMap<String, String> hash = new HashMap<String, String>(flatHash.size() / 2, 1.0f);
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                hash.put(SafeEncoder.encode((byte[])((byte[])iterator.next())), SafeEncoder.encode((byte[])((byte[])iterator.next())));
            }
            return hash;
        }

        public String toString() {
            return "gisResult";
        }
    };
    public static final Builder<Map<byte[], byte[]>> GISSEARCH_RESULT_MAP_BYTE = new Builder<Map<byte[], byte[]>>(){

        public Map<byte[], byte[]> build(Object data) {
            List rawResults;
            List result = (List)data;
            if (null == result || 0 == result.size()) {
                return new HashMap<byte[], byte[]>();
            }
            List flatHash = rawResults = (List)result.get(1);
            HashMap<byte[], byte[]> hash = new HashMap<byte[], byte[]>(flatHash.size() / 2, 1.0f);
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                hash.put((byte[])iterator.next(), (byte[])iterator.next());
            }
            return hash;
        }

        public String toString() {
            return "gisResult";
        }
    };
    public static final Builder<List<String>> GISSEARCH_RESULT_LIST_STRING = new Builder<List<String>>(){

        public List<String> build(Object data) {
            List objectList = (List)data;
            if (objectList == null || objectList.isEmpty()) {
                return null;
            }
            List l = (List)objectList.get(1);
            ArrayList<String> result = new ArrayList<String>(l.size());
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(SafeEncoder.encode((byte[])barray));
            }
            return result;
        }

        public String toString() {
            return "gisResult<List<String>>";
        }
    };
    public static final Builder<List<byte[]>> GISSEARCH_RESULT_BYTE_ARRAY_LIST = new Builder<List<byte[]>>(){

        public List<byte[]> build(Object data) {
            if (null == data) {
                return null;
            }
            return (List)data;
        }

        public String toString() {
            return "gisResult<List<byte[]>>";
        }
    };
    public static final Builder<List<GisSearchResponse>> GISSEARCH_WITH_PARAMS_RESULT = new Builder<List<GisSearchResponse>>(){

        public List<GisSearchResponse> build(Object data) {
            List objectList = (List)data;
            if (objectList == null || objectList.isEmpty()) {
                return null;
            }
            long number = (Long)objectList.get(0);
            List rawResults = (List)objectList.get(1);
            ArrayList<GisSearchResponse> responses = new ArrayList<GisSearchResponse>();
            if (number == 0L || rawResults.isEmpty()) {
                return responses;
            }
            int size = rawResults.size() / (int)number;
            int i = 0;
            while ((long)i < number) {
                GisSearchResponse resp = new GisSearchResponse();
                resp.setField((byte[])rawResults.get(i * size));
                for (int j = i * size + 1; j < (i + 1) * size; ++j) {
                    Object obj = rawResults.get(j);
                    if (GisBuilderFactory.canConvertToDouble(obj)) {
                        resp.setDistance((Double)BuilderFactory.DOUBLE.build(obj));
                        continue;
                    }
                    resp.setValue((byte[])obj);
                }
                responses.add(resp);
                ++i;
            }
            return responses;
        }
    };

    private static boolean canConvertToDouble(Object data) {
        String string = (String)BuilderFactory.STRING.build(data);
        if (string == null) {
            return false;
        }
        try {
            Double.valueOf(string);
            return true;
        }
        catch (NumberFormatException e) {
            return string.equals("inf") || string.equals("+inf") || string.equals("-inf");
        }
    }
}

