/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.taircpc;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.taircpc.factory.CpcBuilderFactory;
import com.aliyun.tair.taircpc.params.CpcArrayMultiData;
import com.aliyun.tair.taircpc.params.CpcData;
import com.aliyun.tair.taircpc.params.CpcMultiArrayUpdateParams;
import com.aliyun.tair.taircpc.params.CpcMultiUpdateParams;
import com.aliyun.tair.taircpc.params.CpcUpdateParams;
import com.aliyun.tair.taircpc.results.Update2JudResult;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.SafeEncoder;

public class TairCpc {
    private Jedis jedis;
    private JedisPool jedisPool;

    public TairCpc(Jedis jedis) {
        this.jedis = jedis;
    }

    public TairCpc(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private Jedis getJedis() {
        if (this.jedisPool != null) {
            return this.jedisPool.getResource();
        }
        return this.jedis;
    }

    private void releaseJedis(Jedis jedis) {
        if (this.jedisPool != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcEstimate(String key) throws JedisConnectionException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCESTIMATE, new String[]{key});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcEstimate(byte[] key) throws JedisConnectionException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCESTIMATE, (byte[][])new byte[][]{key});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cpcMUpdate(ArrayList<CpcData> keys) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (keys == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcData key : keys) {
            if (key.getKey() != null) continue;
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcData key : keys) {
            if (key.getItem() != null) continue;
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            CpcMultiUpdateParams keyList = new CpcMultiUpdateParams();
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCMUPDATE, keyList.getByteParams(keys));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> cpcMUpdate2Est(ArrayList<CpcData> keys) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (keys == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcData key : keys) {
            if (key.getKey() != null) continue;
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcData key : keys) {
            if (key.getItem() != null) continue;
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            CpcMultiUpdateParams keyList = new CpcMultiUpdateParams();
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCMUPDATE2EST, keyList.getByteParams(keys));
            List list = (List)CpcBuilderFactory.CPCUPDATE2EST_MULTI_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Update2JudResult> cpcMUpdate2Jud(ArrayList<CpcData> keys) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (keys == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcData key : keys) {
            if (key.getKey() != null) continue;
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcData key : keys) {
            if (key.getItem() != null) continue;
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            CpcMultiUpdateParams keyList = new CpcMultiUpdateParams();
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCMUPDATE2JUD, keyList.getByteParams(keys));
            List list = (List)CpcBuilderFactory.CPCUPDATE2JUD_MULTI_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cpcUpdate(String key, String item) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCUPDATE, new String[]{key, item});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cpcUpdate(byte[] key, byte[] item) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCUPDATE, (byte[][])new byte[][]{key, item});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cpcUpdate(String key, String item, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCUPDATE, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)item)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cpcUpdate(byte[] key, byte[] item, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCUPDATE, params.getByteParams(key, item));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Update2JudResult cpcUpdate2Jud(String key, String item) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCUPDATE2JUD, new String[]{key, item});
            Update2JudResult update2JudResult = (Update2JudResult)CpcBuilderFactory.CPCUPDATE2JUD_RESULT.build(obj);
            return update2JudResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Update2JudResult cpcUpdate2Jud(byte[] key, byte[] item) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCUPDATE2JUD, (byte[][])new byte[][]{key, item});
            Update2JudResult update2JudResult = (Update2JudResult)CpcBuilderFactory.CPCUPDATE2JUD_RESULT.build(obj);
            return update2JudResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Update2JudResult cpcUpdate2Jud(String key, String item, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCUPDATE2JUD, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)item)));
            Update2JudResult update2JudResult = (Update2JudResult)CpcBuilderFactory.CPCUPDATE2JUD_RESULT.build(obj);
            return update2JudResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Update2JudResult cpcUpdate2Jud(byte[] key, byte[] item, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCUPDATE2JUD, params.getByteParams(key, item));
            Update2JudResult update2JudResult = (Update2JudResult)CpcBuilderFactory.CPCUPDATE2JUD_RESULT.build(obj);
            return update2JudResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcUpdate2Est(String key, String item) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCUPDATE2EST, new String[]{key, item});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcUpdate2Est(byte[] key, byte[] item) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCUPDATE2EST, (byte[][])new byte[][]{key, item});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcUpdate2Est(String key, String item, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCUPDATE2EST, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)item)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcUpdate2Est(byte[] key, byte[] item, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCUPDATE2EST, params.getByteParams(key, item));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cpcArrayUpdate(String key, long timestamp, String item) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE, new String[]{key, String.valueOf(timestamp), item});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cpcArrayUpdate(byte[] key, long timestamp, byte[] item) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp), item});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cpcArrayUpdate(String key, long timestamp, String item, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), SafeEncoder.encode((String)item)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cpcArrayUpdate(byte[] key, long timestamp, byte[] item, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE, params.getByteParams(key, Protocol.toByteArray((long)timestamp), item));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcArrayUpdate2Est(String key, long timestamp, String item) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2EST, new String[]{key, String.valueOf(timestamp), item});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcArrayUpdate2Est(byte[] key, long timestamp, byte[] item) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2EST, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp), item});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcArrayUpdate2Est(String key, long timestamp, String item, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2EST, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), SafeEncoder.encode((String)item)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcArrayUpdate2Est(byte[] key, long timestamp, byte[] item, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2EST, params.getByteParams(key, Protocol.toByteArray((long)timestamp), item));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Update2JudResult cpcArrayUpdate2Jud(String key, long timestamp, String item) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2JUD, new String[]{key, String.valueOf(timestamp), item});
            Update2JudResult update2JudResult = (Update2JudResult)CpcBuilderFactory.CPCUPDATE2JUD_RESULT.build(obj);
            return update2JudResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Update2JudResult cpcArrayUpdate2Jud(byte[] key, long timestamp, byte[] item) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2JUD, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp), item});
            Update2JudResult update2JudResult = (Update2JudResult)CpcBuilderFactory.CPCUPDATE2JUD_RESULT.build(obj);
            return update2JudResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Update2JudResult cpcArrayUpdate2Jud(String key, long timestamp, String item, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2JUD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), SafeEncoder.encode((String)item)));
            Update2JudResult update2JudResult = (Update2JudResult)CpcBuilderFactory.CPCUPDATE2JUD_RESULT.build(obj);
            return update2JudResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Update2JudResult cpcArrayUpdate2Jud(byte[] key, long timestamp, byte[] item, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2JUD, params.getByteParams(key, Protocol.toByteArray((long)timestamp), item));
            Update2JudResult update2JudResult = (Update2JudResult)CpcBuilderFactory.CPCUPDATE2JUD_RESULT.build(obj);
            return update2JudResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcArrayEstimate(String key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATE, new String[]{key, String.valueOf(timestamp)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcArrayEstimate(byte[] key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> cpcArrayEstimateRange(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATERANGE, new String[]{key, String.valueOf(starttime), String.valueOf(endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_ESTIMATE_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> cpcArrayEstimateRange(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATERANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_ESTIMATE_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcArrayEstimateRangeSum(String key, long timestamp, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATERANGESUM, new String[]{key, String.valueOf(timestamp), String.valueOf(range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcArrayEstimateRangeSum(byte[] key, long timestamp, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATERANGESUM, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((long)range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcArrayEstimateRangeMerge(String key, long timestamp, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATERANGEMERGE, new String[]{key, String.valueOf(timestamp), String.valueOf(range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcArrayEstimateRangeMerge(byte[] key, long timestamp, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATERANGEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((long)range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public int getSlot(String key) throws JedisConnectionException {
        return JedisClusterCRC16.getSlot((String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcArrayEstimateTimeMerge(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATETIMEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double cpcArrayEstimateTimeMerge(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATETIMEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumAdd(String key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMADD, new String[]{key, String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumAdd(byte[] key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMADD, (byte[][])new byte[][]{key, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumAdd(String key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMADD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumAdd(byte[] key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMADD, params.getByteParams(key, Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumSet(String key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMSET, new String[]{key, String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumSet(byte[] key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMSET, (byte[][])new byte[][]{key, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumSet(String key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMSET, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumSet(byte[] key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMSET, params.getByteParams(key, Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumGet(String key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMGET, new String[]{key});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumGet(byte[] key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMGET, (byte[][])new byte[][]{key});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumArrayAdd(String key, long timestamp, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMARRAYADD, new String[]{key, String.valueOf(timestamp), String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumArrayAdd(byte[] key, long timestamp, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMARRAYADD, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumArrayAdd(String key, long timestamp, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMARRAYADD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumArrayAdd(byte[] key, long timestamp, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMARRAYADD, params.getByteParams(key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumArrayGet(String key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMARRAYGET, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumArrayGet(byte[] key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMARRAYGET, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> sumArrayGetRange(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMARRAYGETRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> sumArrayGetRange(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMARRAYGETRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumArrayGetRangeTimeMerge(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMARRAYGETTIMEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMARRAYGETTIMEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumArrayGetRangeMerge(String key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMARRAYGETRANGEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double sumArrayGetRangeMerge(byte[] key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SUMARRAYGETRANGEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxAdd(String key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXADD, new String[]{key, String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxAdd(byte[] key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXADD, (byte[][])new byte[][]{key, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxAdd(String key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXADD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxAdd(byte[] key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXADD, params.getByteParams(key, Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxSet(String key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXSET, new String[]{key, String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxSet(byte[] key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXSET, (byte[][])new byte[][]{key, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxSet(String key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXSET, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxSet(byte[] key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXSET, params.getByteParams(key, Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxGet(String key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXGET, new String[]{key});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxGet(byte[] key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXGET, (byte[][])new byte[][]{key});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxArrayAdd(String key, long timestamp, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXARRAYADD, new String[]{key, String.valueOf(timestamp), String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxArrayAdd(byte[] key, long timestamp, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXARRAYADD, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxArrayAdd(String key, long timestamp, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXARRAYADD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxArrayAdd(byte[] key, long timestamp, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXARRAYADD, params.getByteParams(key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxArrayGet(String key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXARRAYGET, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Double maxArrayGet(byte[] key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Object obj = this.jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXARRAYGET, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp)});
        return (Double)BuilderFactory.DOUBLE.build(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> maxArrayGetRange(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXARRAYGETRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> maxArrayGetRange(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXARRAYGETRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxArrayGetRangeTimeMerge(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXARRAYGETTIMEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXARRAYGETTIMEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxArrayGetRangeMerge(String key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXARRAYGETRANGEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double maxArrayGetRangeMerge(byte[] key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MAXARRAYGETRANGEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minAdd(String key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINADD, new String[]{key, String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minAdd(byte[] key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINADD, (byte[][])new byte[][]{key, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minAdd(String key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINADD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minAdd(byte[] key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINADD, params.getByteParams(key, Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minSet(String key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINSET, new String[]{key, String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minSet(byte[] key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINSET, (byte[][])new byte[][]{key, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minSet(String key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINSET, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minSet(byte[] key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINSET, params.getByteParams(key, Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minGet(String key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINGET, new String[]{key});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minGet(byte[] key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINGET, (byte[][])new byte[][]{key});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minArrayAdd(String key, long timestamp, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINARRAYADD, new String[]{key, String.valueOf(timestamp), String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minArrayAdd(byte[] key, long timestamp, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINARRAYADD, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minArrayAdd(String key, long timestamp, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINARRAYADD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minArrayAdd(byte[] key, long timestamp, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINARRAYADD, params.getByteParams(key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minArrayGet(String key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINARRAYGET, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minArrayGet(byte[] key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINARRAYGET, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> minArrayGetRange(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINARRAYGETRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> minArrayGetRange(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINARRAYGETRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minArrayGetRangeTimeMerge(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINARRAYGETTIMEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINARRAYGETTIMEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minArrayGetRangeMerge(String key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINARRAYGETRANGEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double minArrayGetRangeMerge(byte[] key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.MINARRAYGETRANGEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstAdd(String key, String content, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTADD, new String[]{key, content, String.valueOf(value)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstAdd(byte[] key, byte[] content, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTADD, (byte[][])new byte[][]{key, content, Protocol.toByteArray((double)value)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstAdd(String key, String content, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTADD, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)content), Protocol.toByteArray((double)value)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstAdd(byte[] key, byte[] content, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTADD, params.getByteParams(key, content, Protocol.toByteArray((double)value)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstSet(String key, String content, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTSET, new String[]{key, content, String.valueOf(value)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstSet(byte[] key, byte[] content, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTSET, (byte[][])new byte[][]{key, content, Protocol.toByteArray((double)value)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstSet(String key, String content, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTSET, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)content), Protocol.toByteArray((double)value)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstSet(byte[] key, byte[] content, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTSET, params.getByteParams(key, content, Protocol.toByteArray((double)value)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstGet(String key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTGET, new String[]{key});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstGet(byte[] key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTGET, (byte[][])new byte[][]{key});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstArrayAdd(String key, long timestamp, String content, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTARRAYADD, new String[]{key, String.valueOf(timestamp), content, String.valueOf(value)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstArrayAdd(byte[] key, long timestamp, byte[] content, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTARRAYADD, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp), content, Protocol.toByteArray((double)value)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstArrayAdd(String key, long timestamp, String content, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTARRAYADD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), SafeEncoder.encode((String)content), Protocol.toByteArray((double)value)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstArrayAdd(byte[] key, long timestamp, byte[] content, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTARRAYADD, params.getByteParams(key, Protocol.toByteArray((long)timestamp), content, Protocol.toByteArray((double)value)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstArrayGet(String key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTARRAYGET, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstArrayGet(byte[] key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTARRAYGET, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstArrayGetRangeTimeMerge(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTARRAYGETTIMEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTARRAYGETTIMEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstArrayGetRangeMerge(String key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTARRAYGETRANGEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstArrayGetRangeMerge(byte[] key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.FIRSTARRAYGETRANGEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastAdd(String key, String content, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTADD, new String[]{key, content, String.valueOf(value)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastAdd(byte[] key, byte[] content, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTADD, (byte[][])new byte[][]{key, content, Protocol.toByteArray((double)value)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastAdd(String key, String content, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTADD, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)content), Protocol.toByteArray((double)value)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastAdd(byte[] key, byte[] content, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTADD, params.getByteParams(key, content, Protocol.toByteArray((double)value)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastSet(String key, String content, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTSET, new String[]{key, content, String.valueOf(value)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastSet(byte[] key, byte[] content, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTSET, (byte[][])new byte[][]{key, content, Protocol.toByteArray((double)value)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastSet(String key, String content, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTSET, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)content), Protocol.toByteArray((double)value)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastSet(byte[] key, byte[] content, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTSET, params.getByteParams(key, content, Protocol.toByteArray((double)value)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastGet(String key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTGET, new String[]{key});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastGet(byte[] key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTGET, (byte[][])new byte[][]{key});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastArrayAdd(String key, long timestamp, String content, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTARRAYADD, new String[]{key, String.valueOf(timestamp), content, String.valueOf(value)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastArrayAdd(byte[] key, long timestamp, byte[] content, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTARRAYADD, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp), content, Protocol.toByteArray((double)value)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastArrayAdd(String key, long timestamp, String content, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTARRAYADD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), SafeEncoder.encode((String)content), Protocol.toByteArray((double)value)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastArrayAdd(byte[] key, long timestamp, byte[] content, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTARRAYADD, params.getByteParams(key, Protocol.toByteArray((long)timestamp), content, Protocol.toByteArray((double)value)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastArrayGet(String key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTARRAYGET, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastArrayGet(byte[] key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTARRAYGET, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastArrayGetRangeTimeMerge(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTARRAYGETTIMEEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTARRAYGETTIMEEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastArrayGetRangeMerge(String key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTARRAYGETRANGEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastArrayGetRangeMerge(byte[] key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.LASTARRAYGETRANGEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgAdd(String key, long count, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGADD, new String[]{key, String.valueOf(count), String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgAdd(byte[] key, long count, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGADD, (byte[][])new byte[][]{key, Protocol.toByteArray((long)count), Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgAdd(String key, long count, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGADD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)count), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgAdd(byte[] key, long count, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGADD, params.getByteParams(key, Protocol.toByteArray((long)count), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgSet(String key, long count, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGSET, new String[]{key, String.valueOf(count), String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgSet(byte[] key, long count, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGSET, (byte[][])new byte[][]{key, Protocol.toByteArray((long)count), Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgSet(String key, long count, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGSET, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)count), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgSet(byte[] key, long count, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGSET, params.getByteParams(key, Protocol.toByteArray((long)count), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgGet(String key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGGET, new String[]{key});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgGet(byte[] key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGGET, (byte[][])new byte[][]{key});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgArrayAdd(String key, long timestamp, long count, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGARRAYADD, new String[]{key, String.valueOf(timestamp), String.valueOf(count), String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgArrayAdd(byte[] key, long timestamp, long count, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGARRAYADD, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((long)count), Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgArrayAdd(String key, long timestamp, long count, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGARRAYADD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), Protocol.toByteArray((long)count), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgArrayAdd(byte[] key, long timestamp, long count, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGARRAYADD, params.getByteParams(key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((long)count), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgArrayGet(String key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGARRAYGET, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgArrayGet(byte[] key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGARRAYGET, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> avgArrayGetRange(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGARRAYGETRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> avgArrayGetRange(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGARRAYGETRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgArrayGetRangeTimeMerge(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGARRAYGETTIMEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGARRAYGETTIMEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgArrayGetRangeMerge(String key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGARRAYGETRANGEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double avgArrayGetRangeMerge(byte[] key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.AVGARRAYGETRANGEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevAdd(String key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVADD, new String[]{key, String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevAdd(byte[] key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVADD, (byte[][])new byte[][]{key, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevAdd(String key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVADD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevAdd(byte[] key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVADD, params.getByteParams(key, Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevSet(String key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVSET, new String[]{key, String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevSet(byte[] key, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVSET, (byte[][])new byte[][]{key, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevSet(String key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVSET, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevSet(byte[] key, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVSET, params.getByteParams(key, Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevGet(String key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVGET, new String[]{key});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevGet(byte[] key) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVGET, (byte[][])new byte[][]{key});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevArrayAdd(String key, long timestamp, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVARRAYADD, new String[]{key, String.valueOf(timestamp), String.valueOf(value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevArrayAdd(byte[] key, long timestamp, double value) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVARRAYADD, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevArrayAdd(String key, long timestamp, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVARRAYADD, params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevArrayAdd(byte[] key, long timestamp, double value, CpcUpdateParams params) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVARRAYADD, params.getByteParams(key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevArrayGet(String key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVARRAYGET, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevArrayGet(byte[] key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVARRAYGET, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> stddevArrayGetRange(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVARRAYGETRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> stddevArrayGetRange(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVARRAYGETRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevArrayGetRangeTimeMerge(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVARRAYGETTIMEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVARRAYGETTIMEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevArrayGetRangeMerge(String key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVARRAYGETRANGEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double stddevArrayGetRangeMerge(byte[] key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.STDDEVARRAYGETRANGEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sketchesBatchWrite(ArrayList<CpcArrayMultiData> keys) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcArrayMultiData key : keys) {
            if (key.getKey() != null) continue;
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            CpcMultiArrayUpdateParams keyList = new CpcMultiArrayUpdateParams();
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SKETCHESBATCHWRITE, keyList.getByteMultiParams(keys));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sketchesGet(String key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SKETCHESGET, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp)});
            Object object = CpcBuilderFactory.SKETCHES_GET_RESULT.build(obj);
            return object;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sketchesGet(byte[] key, long timestamp) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SKETCHESGET, (byte[][])new byte[][]{key, Protocol.toByteArray((long)timestamp)});
            Object object = CpcBuilderFactory.SKETCHES_GET_RESULT.build(obj);
            return object;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sketchesGetRangeMerge(String key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SKETCHESRANGEMERGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            Object object = CpcBuilderFactory.SKETCHES_GET_RESULT.build(obj);
            return object;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sketchesGetRangeMerge(byte[] key, long endtime, long range) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SKETCHESRANGEMERGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)endtime), Protocol.toByteArray((long)range)});
            Object object = CpcBuilderFactory.SKETCHES_GET_RESULT.build(obj);
            return object;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> sketchesGetRange(String key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SKETCHESRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> sketchesGetRange(byte[] key, long starttime, long endtime) throws JedisConnectionException, IllegalArgumentException, JedisDataException {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.SKETCHESRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)starttime), Protocol.toByteArray((long)endtime)});
            List list = (List)CpcBuilderFactory.CPCARRAY_RANGE_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }
}

