/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.utils;

import com.aliyun.odps.utils.OdpsCommonUtils;
import com.aliyun.odps.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class NameSpaceSchemaUtils {
    public static String getFullName(String project, String schema, String objectName) {
        if (NameSpaceSchemaUtils.isSchemaEnabled(schema)) {
            return OdpsCommonUtils.quoteRef(project) + "." + OdpsCommonUtils.quoteRef(schema) + "." + OdpsCommonUtils.quoteRef(objectName);
        }
        return OdpsCommonUtils.quoteRef(project) + "." + OdpsCommonUtils.quoteRef(objectName);
    }

    public static Map<String, String> setSchemaFlagInHints(Map<String, String> hints, String schemaName) {
        if (NameSpaceSchemaUtils.isSchemaEnabled(schemaName)) {
            if (hints == null) {
                hints = new HashMap<String, String>();
            }
            if (!hints.containsKey("odps.namespace.schema")) {
                hints.put("odps.namespace.schema", "true");
            }
            if (!hints.containsKey("odps.sql.allow.namespace.schema")) {
                hints.put("odps.sql.allow.namespace.schema", "true");
            }
        }
        return hints;
    }

    public static HashMap<String, String> initParamsWithSchema(String schemaName) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (NameSpaceSchemaUtils.isSchemaEnabled(schemaName)) {
            params.put("curr_schema", schemaName);
        }
        return params;
    }

    public static boolean isSchemaEnabled(String schemaName) {
        return !StringUtils.isNullOrEmpty((String)schemaName);
    }
}

